/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SlottedItemStackHandler
extends ItemStackHandler {
    protected final int[] slots;
    protected final boolean allowInput;
    protected final boolean allowOutput;
    protected final Predicate<ItemStack> itemPredicate;

    public SlottedItemStackHandler(NonNullList<ItemStack> stacks, int[] slots, boolean allowInput, boolean allowOutput, Predicate<ItemStack> itemPredicate) {
        this.stacks = stacks;
        this.slots = slots;
        this.allowInput = allowInput;
        this.allowOutput = allowOutput;
        this.itemPredicate = itemPredicate;
    }

    public SlottedItemStackHandler(NonNullList<ItemStack> stacks, int[] slots, boolean allowInput, boolean allowOutput) {
        this(stacks, slots, allowInput, allowOutput, null);
    }

    public SlottedItemStackHandler(NonNullList<ItemStack> stacks, int[] slots) {
        this(stacks, slots, true, true, null);
    }

    public boolean isItemAllowed(ItemStack stack) {
        if (this.itemPredicate != null) {
            return this.itemPredicate.test(stack);
        }
        return true;
    }

    public boolean isSlotValid(int slot) {
        for (int i : this.slots) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!(this.allowInput && this.isSlotValid(slot) && this.isItemAllowed(stack))) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowOutput || !this.isSlotValid(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = (ItemStack)this.stacks.get(slot);
        if (!this.isItemAllowed(itemStack)) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public void changeItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }
}

