/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import net.minecraft.core.Direction;
import net.minecraft.nbt.IntArrayTag;

public class SideConfig {
    private final Value[] values = new Value[]{Value.OUTPUT, Value.INPUT, Value.NONE, Value.NONE, Value.OUTPUT, Value.INPUT};

    public SideConfig() {
    }

    public SideConfig(int[] intValues) {
        for (int i = 0; i < Math.min(intValues.length, 6); ++i) {
            this.values[i] = Value.values()[intValues[i]];
        }
    }

    public Value getValue(Direction direction) {
        return this.values[direction.ordinal()];
    }

    public int[] getIntValues() {
        int[] array = new int[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            array[i] = this.values[i].ordinal();
        }
        return array;
    }

    public void switchValue(Direction direction, boolean forward) {
        int ordinal = this.values[direction.ordinal()].ordinal();
        ordinal = forward ? (ordinal + 1) % Value.values().length : (ordinal == 0 ? Value.values().length - 1 : ordinal - 1);
        this.values[direction.ordinal()] = Value.values()[ordinal];
    }

    public void setValue(Direction direction, Value value) {
        this.values[direction.ordinal()] = value;
    }

    public IntArrayTag toNbt() {
        return new IntArrayTag(this.getIntValues());
    }

    public static SideConfig fromNbt(IntArrayTag tag) {
        SideConfig sideConfig = new SideConfig();
        int[] array = tag.m_128648_();
        for (int i = 0; i < Math.min(array.length, 6); ++i) {
            sideConfig.values[i] = Value.values()[array[i]];
        }
        return sideConfig;
    }

    public static SideConfig fromIntArray(int[] array) {
        SideConfig sideConfig = new SideConfig();
        for (int i = 0; i < Math.min(array.length, 6); ++i) {
            sideConfig.values[i] = Value.values()[array[i]];
        }
        return sideConfig;
    }

    public static Direction directionRelative(Direction from, Direction relative) {
        if (relative == Direction.UP || relative == Direction.DOWN) {
            return relative;
        }
        return switch (from) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> relative;
            case Direction.SOUTH -> relative.m_122424_();
            case Direction.EAST -> relative.m_122428_();
            case Direction.WEST -> relative.m_122427_();
            case Direction.UP -> Direction.UP;
            case Direction.DOWN -> Direction.DOWN;
        };
    }

    public static enum Value {
        NONE,
        INPUT,
        OUTPUT,
        REJECTION_OUTPUT;

    }
}

