/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import me.khajiitos.jackseconomy.init.ItemBlockReg;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OIMWalletCapabilityWrapper
implements IItemHandlerModifiable,
ICapabilityProvider {
    private final ItemStack stack;
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
    private NonNullList<ItemStack> slots;
    private CompoundTag cachedTag;

    private OIMWalletCapabilityWrapper(ItemStack itemStack) {
        this.stack = itemStack;
    }

    public static OIMWalletCapabilityWrapper create(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof OIMWalletItem) {
            return new OIMWalletCapabilityWrapper(itemStack);
        }
        return null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
    }

    public int getSlots() {
        return 15;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.getItemList().get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        int limit = Math.min(this.getSlotLimit(slot), stack.m_41741_());
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                itemStacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.setItemList(itemStacks);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)itemStacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                itemStacks.set(slot, (Object)ItemStack.f_41583_);
                this.setItemList(itemStacks);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            itemStacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.setItemList(itemStacks);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    public int getSlotLimit(int slot) {
        return ((CurrencyItem)ItemBlockReg.DOLLAR_BILL_ITEM.get()).m_41459_();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.m_41720_().m_142095_();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + stack + " for slot " + slot + ")");
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    private NonNullList<ItemStack> getItemList() {
        CompoundTag rootTag = this.stack.m_41783_();
        if (this.cachedTag == null || !this.cachedTag.equals((Object)rootTag)) {
            this.slots = this.refreshItemList(rootTag);
        }
        return this.slots;
    }

    private NonNullList<ItemStack> refreshItemList(CompoundTag rootTag) {
        NonNullList itemStacks = NonNullList.m_122780_((int)this.getSlots(), (Object)ItemStack.f_41583_);
        if (rootTag != null && rootTag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)rootTag, (NonNullList)itemStacks);
        }
        this.cachedTag = rootTag;
        return itemStacks;
    }

    private void setItemList(NonNullList<ItemStack> itemStacks) {
        CompoundTag existing = this.stack.m_41784_();
        this.cachedTag = ContainerHelper.m_18973_((CompoundTag)existing, itemStacks);
    }
}

