/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NewShopUnlocks {
    public Set<String> unlockedCategories = new HashSet<String>();
    public Set<Item> unlockedItems = new HashSet<Item>();

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag items = new ListTag();
        ListTag categories = new ListTag();
        this.unlockedItems.forEach(item -> {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("slot", item.slot);
            itemTag.m_128359_("category", item.category);
            items.add((Object)itemTag);
        });
        this.unlockedCategories.forEach(category -> categories.add((Object)StringTag.m_129297_((String)category)));
        tag.m_128365_("items", (Tag)items);
        tag.m_128365_("categories", (Tag)categories);
        return tag;
    }

    public static NewShopUnlocks fromNbt(CompoundTag nbt) {
        NewShopUnlocks newShopUnlocks = new NewShopUnlocks();
        if (nbt.m_128425_("items", 9) && nbt.m_128425_("categories", 9)) {
            ListTag items = nbt.m_128437_("items", 10);
            ListTag categories = nbt.m_128437_("categories", 8);
            items.forEach(tag -> {
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)tag;
                    int slot = compoundTag.m_128451_("slot");
                    String category = compoundTag.m_128461_("category");
                    newShopUnlocks.unlockedItems.add(new Item(slot, category));
                }
            });
            categories.forEach(tag -> {
                if (tag instanceof StringTag) {
                    StringTag stringTag = (StringTag)tag;
                    newShopUnlocks.unlockedCategories.add(stringTag.m_7916_());
                }
            });
        }
        return newShopUnlocks;
    }

    public void merge(NewShopUnlocks another) {
        this.unlockedItems.addAll(another.unlockedItems);
        this.unlockedCategories.addAll(another.unlockedCategories);
    }

    public void reduce(NewShopUnlocks acknowledgedUnlocks) {
        this.unlockedItems.removeIf(acknowledgedUnlocks.unlockedItems::contains);
        this.unlockedCategories.removeIf(acknowledgedUnlocks.unlockedCategories::contains);
    }

    public boolean isEmpty() {
        return this.unlockedCategories.isEmpty() && this.unlockedItems.isEmpty();
    }

    public record Item(int slot, String category) {
    }
}

