/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import me.khajiitos.jackseconomy.JacksEconomy;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTUtil {
    public static JsonElement nbtToJson(Tag tag) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return new JsonPrimitive(stringTag.m_7916_());
        }
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return new JsonPrimitive((Number)intTag.m_7047_());
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return new JsonPrimitive((Number)doubleTag.m_7061_());
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return new JsonPrimitive((Number)shortTag.m_7053_());
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            JsonObject resultObj = new JsonObject();
            compoundTag.m_128431_().forEach(key -> {
                Tag objTag = compoundTag.m_128423_(key);
                if (objTag == null) {
                    return;
                }
                resultObj.add(key, NBTUtil.nbtToJson(objTag));
            });
            return resultObj;
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            JsonArray resultArray = new JsonArray();
            listTag.forEach(arrayTag -> {
                if (arrayTag == null) {
                    return;
                }
                resultArray.add(NBTUtil.nbtToJson(arrayTag));
            });
            return resultArray;
        }
        JacksEconomy.LOGGER.warn("NBTUtil::nbtToJson - unsupported tag type " + tag.getClass().getSimpleName());
        return null;
    }

    public static Tag jsonToNbt(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive.isBoolean()) {
                return ByteTag.m_128273_((boolean)jsonElement.getAsBoolean());
            }
            if (jsonPrimitive.isNumber()) {
                return DoubleTag.m_128500_((double)jsonPrimitive.getAsDouble());
            }
            if (jsonPrimitive.isString()) {
                return StringTag.m_129297_((String)jsonPrimitive.getAsString());
            }
        } else {
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                CompoundTag resultTag = new CompoundTag();
                jsonObject.entrySet().forEach(entry -> {
                    Tag tag;
                    if (entry.getValue() != null && (tag = NBTUtil.jsonToNbt((JsonElement)entry.getValue())) != null) {
                        resultTag.m_128365_((String)entry.getKey(), tag);
                    }
                });
                return resultTag;
            }
            if (jsonElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                ListTag listTag = new ListTag();
                jsonArray.forEach(element -> listTag.add((Object)NBTUtil.jsonToNbt(element)));
                return listTag;
            }
            JacksEconomy.LOGGER.warn("NBTUtil::jsonToNbt - unsupported element type " + jsonElement.getClass().getSimpleName());
        }
        return null;
    }
}

