/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import java.math.BigDecimal;
import me.khajiitos.jackseconomy.block.CurrencyStackBlock;
import me.khajiitos.jackseconomy.init.ItemBlockReg;
import me.khajiitos.jackseconomy.item.CurrencyItem;

public enum CurrencyType {
    PENNY((CurrencyItem)ItemBlockReg.PENNY_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.PENNY_STACK_BLOCK.get())),
    NICKEL((CurrencyItem)ItemBlockReg.NICKEL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.NICKEL_STACK_BLOCK.get())),
    DIME((CurrencyItem)ItemBlockReg.DIME_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.DIME_STACK_BLOCK.get())),
    QUARTER((CurrencyItem)ItemBlockReg.QUARTER_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.QUARTER_STACK_BLOCK.get())),
    DOLLAR_BILL((CurrencyItem)ItemBlockReg.DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.DOLLAR_BILL_STACK_BLOCK.get())),
    FIVE_DOLLAR_BILL((CurrencyItem)ItemBlockReg.FIVE_DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.FIVE_DOLLAR_BILL_STACK_BLOCK.get())),
    TEN_DOLLAR_BILL((CurrencyItem)ItemBlockReg.TEN_DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.TEN_DOLLAR_BILL_STACK_BLOCK.get())),
    TWENTY_DOLLAR_BILL((CurrencyItem)ItemBlockReg.TWENTY_DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.TWENTY_DOLLAR_BILL_STACK_BLOCK.get())),
    FIFTY_DOLLAR_BILL((CurrencyItem)ItemBlockReg.FIFTY_DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.FIFTY_DOLLAR_BILL_STACK_BLOCK.get())),
    HUNDRED_DOLLAR_BILL((CurrencyItem)ItemBlockReg.HUNDRED_DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.HUNDRED_DOLLAR_BILL_STACK_BLOCK.get())),
    THOUSAND_DOLLAR_BILL((CurrencyItem)ItemBlockReg.THOUSAND_DOLLAR_BILL_ITEM.get(), (CurrencyStackBlock)((Object)ItemBlockReg.THOUSAND_DOLLAR_BILL_STACK_BLOCK.get()));

    public final BigDecimal worth;
    public final CurrencyItem item;
    public final CurrencyStackBlock stackBlock;

    private CurrencyType(CurrencyItem item) {
        this.item = item;
        this.worth = item.value;
        this.stackBlock = null;
    }

    private CurrencyType(CurrencyItem item, CurrencyStackBlock stackBlock) {
        this.item = item;
        this.worth = item.value;
        this.stackBlock = stackBlock;
    }

    public BigDecimal getWorth() {
        return this.worth;
    }

    public String getTranslationName() {
        return this.item.m_5524_();
    }

    public CurrencyType next() {
        return CurrencyType.values()[(this.ordinal() + 1) % CurrencyType.values().length];
    }

    public CurrencyType previous() {
        if (this.ordinal() == 0) {
            return CurrencyType.values()[CurrencyType.values().length - 1];
        }
        return CurrencyType.values()[this.ordinal() - 1];
    }

    public static CurrencyType get(CurrencyItem currencyItem) {
        for (CurrencyType currencyType : CurrencyType.values()) {
            if (currencyType.item != currencyItem) continue;
            return currencyType;
        }
        return null;
    }
}

