/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.util.CurrencyType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CurrencyHelper {
    private static final BigDecimal TRILLION = new BigDecimal("1000000000000");
    private static final BigDecimal BILLION = new BigDecimal("1000000000");
    private static final BigDecimal MILLION = new BigDecimal("1000000");
    private static final BigDecimal THOUSAND = new BigDecimal("1000");

    public static List<ItemStack> getCurrencyItems(BigDecimal value) {
        List<CurrencyType> sortedCurrencies;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        List<CurrencyType> list = sortedCurrencies = (Boolean)Config.oneItemCurrencyMode.get() != false ? List.of(CurrencyType.DOLLAR_BILL) : Arrays.stream(CurrencyType.values()).sorted(Comparator.comparing(CurrencyType::getWorth).reversed()).toList();
        while (value.compareTo(BigDecimal.ZERO) > 0) {
            boolean anything = false;
            for (CurrencyType currencyType : sortedCurrencies) {
                if (value.compareTo(currencyType.worth) < 0) continue;
                int count = Math.min(currencyType.item.m_41459_(), value.divide(currencyType.worth, RoundingMode.DOWN).intValue());
                items.add(new ItemStack((ItemLike)currencyType.item, count));
                value = value.subtract(currencyType.worth.multiply(new BigDecimal(count)));
                anything = true;
                break;
            }
            if (anything) continue;
            break;
        }
        return items;
    }

    public static String format(double value) {
        return DecimalFormat.getCurrencyInstance(Locale.US).format(value);
    }

    public static String formatShortened(BigDecimal bigDecimal) {
        String sign = bigDecimal.compareTo(BigDecimal.ZERO) < 0 ? "-" : "";
        BigDecimal bigDecimalAbs = bigDecimal.abs();
        if (bigDecimalAbs.compareTo(TRILLION) >= 0) {
            return "$" + sign + bigDecimalAbs.divide(TRILLION, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN) + "T";
        }
        if (bigDecimalAbs.compareTo(BILLION) >= 0) {
            return "$" + sign + bigDecimalAbs.divide(BILLION, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN) + "B";
        }
        if (bigDecimalAbs.compareTo(MILLION) >= 0) {
            return "$" + sign + bigDecimalAbs.divide(MILLION, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN) + "M";
        }
        if (bigDecimalAbs.compareTo(THOUSAND) >= 0) {
            return "$" + sign + bigDecimalAbs.divide(THOUSAND, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN) + "K";
        }
        return CurrencyHelper.format(bigDecimal);
    }

    public static String format(BigDecimal bigDecimal) {
        return CurrencyHelper.format(bigDecimal.doubleValue());
    }
}

