/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.price.ItemDescription;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TicketPreviewWidget
extends AbstractWidget {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/ticket_slot_preview.png");
    private final boolean openable;
    private boolean open = false;
    private final List<ItemDescription> items;
    private int tickCount;
    private final ItemDescription selectedItemDescription;
    private final Consumer<ItemDescription> onSelect;
    private final Consumer<List<Component>> onTooltip;

    public boolean isOpen() {
        return this.open;
    }

    public TicketPreviewWidget(int pX, int pY, boolean openable, List<ItemDescription> items, @Nullable ItemDescription selectedItemDescription, @Nullable Consumer<ItemDescription> onSelect, @Nullable Consumer<List<Component>> onTooltip) {
        super(pX, pY, 18, 18, (Component)Component.m_237119_());
        this.openable = openable;
        this.items = items;
        this.selectedItemDescription = selectedItemDescription;
        this.onSelect = onSelect;
        this.onTooltip = onTooltip;
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.open) {
            this.f_93618_ = this.items.size() * 18;
            guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -12303292);
            int x = this.m_252754_();
            for (ItemDescription itemDescription : this.items) {
                guiGraphics.m_280398_(BACKGROUND, x, this.m_252907_(), 0, itemDescription.equals(this.selectedItemDescription) ? 18.0f : 0.0f, 0.0f, 18, 18, 36, 18);
                ItemStack itemStack = itemDescription.createItemStack();
                guiGraphics.m_280480_(itemStack, x + 1, this.m_252907_() + 1);
                if (pMouseX >= x + 1 && pMouseX <= x + 17 && pMouseY >= this.m_252907_() + 1 && pMouseY <= this.m_252907_() + 17) {
                    AbstractContainerScreen.m_280359_((GuiGraphics)guiGraphics, (int)(x + 1), (int)(this.m_252907_() + 1), (int)0);
                    if (this.onTooltip != null) {
                        List tooltip = itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_);
                        if (itemDescription.equals(this.selectedItemDescription)) {
                            tooltip.add(Component.m_237113_((String)" "));
                            tooltip.add(Component.m_237115_((String)"jackseconomy.selected").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY}));
                        }
                        this.onTooltip.accept(tooltip);
                    }
                }
                x += 18;
            }
        } else {
            this.f_93618_ = 18;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
            guiGraphics.m_280398_(BACKGROUND, this.m_252754_(), this.m_252907_(), this.f_93618_, 0.0f, 0.0f, 18, 18, 36, 18);
            if (!this.items.isEmpty()) {
                ItemDescription item = this.openable ? (this.items.stream().anyMatch(desc -> desc.equals(this.selectedItemDescription)) ? this.selectedItemDescription : this.items.get(0)) : this.items.get(this.tickCount / 20 % this.items.size());
                ItemStack itemStack = item.createItemStack();
                guiGraphics.m_280480_(itemStack, this.m_252754_() + 1, this.m_252907_() + 1);
                if (pMouseX >= this.m_252754_() + 1 && pMouseX <= this.m_252754_() + 17 && pMouseY >= this.m_252907_() + 1 && pMouseY <= this.m_252907_() + 17) {
                    AbstractContainerScreen.m_280359_((GuiGraphics)guiGraphics, (int)(this.m_252754_() + 1), (int)(this.m_252907_() + 1), (int)0);
                    this.onTooltip.accept(itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_));
                }
            }
        }
    }

    public void tick() {
        ++this.tickCount;
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        if (this.openable && !this.open) {
            this.open = true;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.open && !this.f_93622_) {
            this.open = false;
            return true;
        }
        if (this.onSelect != null && this.open) {
            int x = this.m_252754_();
            for (ItemDescription itemDescription : this.items) {
                if (pMouseX >= (double)(x + 1) && pMouseX <= (double)(x + 17) && pMouseY >= (double)(this.m_252907_() + 1) && pMouseY <= (double)(this.m_252907_() + 17)) {
                    this.onSelect.accept(itemDescription);
                    return true;
                }
                x += 18;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

