/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.packet.UpdateSideConfigPacket;
import me.khajiitos.jackseconomy.util.SideConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SideConfigWidget
extends AbstractWidget {
    private static final ResourceLocation IMAGE = new ResourceLocation("jackseconomy", "textures/gui/side_config.png");
    private final ResourceLocation faceTexture;
    private static final ResourceLocation NONE_TEXTURE = new ResourceLocation("jackseconomy", "textures/block/machine.png");
    private static final ResourceLocation INPUT_TEXTURE = new ResourceLocation("jackseconomy", "textures/block/input.png");
    private static final ResourceLocation OUTPUT_TEXTURE = new ResourceLocation("jackseconomy", "textures/block/output.png");
    private static final ResourceLocation REJECTION_OUTPUT_TEXTURE = new ResourceLocation("jackseconomy", "textures/block/rejection_output.png");
    private boolean open;
    private final Set<Direction> allowedDirections;
    private final Supplier<SideConfig> sideConfigSupplier;
    private final Consumer<List<Component>> onTooltip;

    public SideConfigWidget(int pX, int pY, ResourceLocation faceTexture, Set<Direction> allowedDirections, Supplier<SideConfig> sideConfigSupplier, Consumer<List<Component>> onTooltip) {
        super(pX, pY, 16, 16, (Component)Component.m_237119_());
        this.faceTexture = faceTexture;
        this.allowedDirections = allowedDirections;
        this.sideConfigSupplier = sideConfigSupplier;
        this.onTooltip = onTooltip;
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    protected SideConfig.Value getValue(Direction direction) {
        return this.sideConfigSupplier.get().getValue(direction);
    }

    protected ResourceLocation getSideTexture(Direction direction) {
        if (direction == Direction.NORTH) {
            return this.faceTexture;
        }
        return switch (this.sideConfigSupplier.get().getValue(direction)) {
            default -> throw new IncompatibleClassChangeError();
            case SideConfig.Value.NONE -> NONE_TEXTURE;
            case SideConfig.Value.INPUT -> INPUT_TEXTURE;
            case SideConfig.Value.OUTPUT -> OUTPUT_TEXTURE;
            case SideConfig.Value.REJECTION_OUTPUT -> REJECTION_OUTPUT_TEXTURE;
        };
    }

    protected Pair<Integer, Integer> getDirectionOffsets(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Pair.of((Object)40, (Object)60);
            case Direction.UP -> Pair.of((Object)40, (Object)20);
            case Direction.SOUTH -> Pair.of((Object)60, (Object)60);
            case Direction.EAST -> Pair.of((Object)20, (Object)40);
            case Direction.WEST -> Pair.of((Object)60, (Object)40);
            case Direction.NORTH -> Pair.of((Object)40, (Object)40);
        };
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.open) {
            this.f_93618_ = 96;
            this.f_93619_ = 96;
        } else {
            this.f_93618_ = 16;
            this.f_93619_ = 16;
        }
        boolean buttonHovered = pMouseX >= this.m_252754_() && pMouseX <= this.m_252754_() + 16 && pMouseY >= this.m_252907_() && pMouseY <= this.m_252907_() + 16;
        guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -10066330);
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -13421773);
        guiGraphics.m_280398_(IMAGE, this.m_252754_(), this.m_252907_(), 0, 0.0f, buttonHovered ? 16.0f : 0.0f, 16, 16, 16, 32);
        if (this.open) {
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jackseconomy.configuration").m_130940_(ChatFormatting.YELLOW), this.m_252754_() + 18, this.m_252907_() + 4, -1);
            for (Direction direction : this.allowedDirections) {
                Pair<Integer, Integer> offsets = this.getDirectionOffsets(direction);
                int xOffset = (Integer)offsets.getFirst();
                int yOffset = (Integer)offsets.getSecond();
                if (pMouseX >= this.m_252754_() + xOffset && pMouseX <= this.m_252754_() + xOffset + 16 && pMouseY >= this.m_252907_() + yOffset && pMouseY <= this.m_252907_() + yOffset + 16) {
                    RenderSystem.setShaderColor((float)1.5f, (float)1.5f, (float)1.5f, (float)1.0f);
                    this.onTooltip.accept(List.of(Component.m_237115_((String)("jackseconomy.direction." + direction.m_122433_())).m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)("jackseconomy.sidevalue." + this.getValue(direction).name().toLowerCase()))));
                }
                guiGraphics.m_280398_(this.getSideTexture(direction), this.m_252754_() + xOffset, this.m_252907_() + yOffset, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Pair<Integer, Integer> offsets = this.getDirectionOffsets(Direction.NORTH);
            guiGraphics.m_280398_(this.getSideTexture(Direction.NORTH), this.m_252754_() + (Integer)offsets.getFirst(), this.m_252907_() + (Integer)offsets.getSecond(), 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton != 0 && pButton != 1) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (pMouseX >= (double)this.m_252754_() && pMouseX <= (double)(this.m_252754_() + 16) && pMouseY >= (double)this.m_252907_() && pMouseY <= (double)(this.m_252907_() + 16)) {
            this.open = !this.open;
            return false;
        }
        for (Direction direction : this.allowedDirections) {
            Pair<Integer, Integer> offsets = this.getDirectionOffsets(direction);
            int xOffset = (Integer)offsets.getFirst();
            int yOffset = (Integer)offsets.getSecond();
            if (!(pMouseX >= (double)(this.m_252754_() + xOffset)) || !(pMouseX <= (double)(this.m_252754_() + xOffset + 16)) || !(pMouseY >= (double)(this.m_252907_() + yOffset)) || !(pMouseY <= (double)(this.m_252907_() + yOffset + 16))) continue;
            this.sideConfigSupplier.get().switchValue(direction, pButton == 0);
            Packets.sendToServer(new UpdateSideConfigPacket(this.sideConfigSupplier.get().getIntValues()));
            return false;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

