/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen.widget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BalanceProgressWidget
extends AbstractWidget {
    protected static final ResourceLocation BALANCE_PROGRESS = new ResourceLocation("jackseconomy", "textures/gui/balance_progress.png");
    private final Supplier<BigDecimal> balanceSupplier;
    private final Supplier<BigDecimal> maxBalanceSupplier;
    private final Consumer<List<Component>> onTooltip;

    public BalanceProgressWidget(int pX, int pY, Supplier<BigDecimal> balanceSupplier, Supplier<BigDecimal> maxBalanceSupplier, Consumer<List<Component>> onTooltip) {
        super(pX, pY, 5, 65, (Component)Component.m_237113_((String)""));
        this.balanceSupplier = balanceSupplier;
        this.maxBalanceSupplier = maxBalanceSupplier;
        this.onTooltip = onTooltip;
    }

    public boolean m_274382_() {
        return this.f_93622_;
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        BigDecimal balance = this.balanceSupplier.get();
        BigDecimal capacity = this.maxBalanceSupplier.get();
        double progress = balance.divide(capacity, RoundingMode.DOWN).min(BigDecimal.ONE).doubleValue();
        int startX = this.m_252754_();
        int startY = this.m_252907_();
        int pixels = (int)(65.0 * progress);
        guiGraphics.m_280398_(BALANCE_PROGRESS, startX, startY, 0, 56.0f, 0.0f, 5, 65, 256, 256);
        guiGraphics.m_280398_(BALANCE_PROGRESS, startX, startY + (65 - pixels), 0, 51.0f, (float)(65 - pixels), 5, pixels, 256, 256);
        if (this.m_274382_()) {
            this.onTooltip.accept(List.of(Component.m_237110_((String)"jackseconomy.balance", (Object[])new Object[]{Component.m_237113_((String)((Boolean)Config.oneItemCurrencyMode.get() != false ? "$" + balance.longValue() : CurrencyHelper.format(balance))).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), Component.m_237110_((String)"jackseconomy.max_storage", (Object[])new Object[]{Component.m_237113_((String)((Boolean)Config.oneItemCurrencyMode.get() != false ? "$" + capacity.longValue() : CurrencyHelper.format(capacity))).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)((int)(progress * 100.0) + "%")).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW)));
        }
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

