/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import me.khajiitos.jackseconomy.JacksEconomyClient;
import me.khajiitos.jackseconomy.config.ClientConfig;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.menu.WalletMenu;
import me.khajiitos.jackseconomy.packet.CreateCheckPacket;
import me.khajiitos.jackseconomy.packet.DepositAllPacket;
import me.khajiitos.jackseconomy.packet.WithdrawBalanceSpecificPacket;
import me.khajiitos.jackseconomy.screen.ShoppingCartScreen;
import me.khajiitos.jackseconomy.screen.widget.CheckCreatorWidget;
import me.khajiitos.jackseconomy.screen.widget.SimpleButton;
import me.khajiitos.jackseconomy.screen.widget.TextBox;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.CurrencyType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WalletScreen
extends AbstractContainerScreen<WalletMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/wallet.png");
    private static final ResourceLocation ADMIN_SHOP_ICON = new ResourceLocation("jackseconomy", "textures/gui/admin_shop_icon.png");
    private static final ResourceLocation ID_CARD = new ResourceLocation("jackseconomy", "textures/gui/id_card.png");
    private List<Component> tooltip;
    private boolean tooltipShift = false;
    private final List<ClickableCurrencyItem> clickableCurrencyItems = new ArrayList<ClickableCurrencyItem>();
    private final ItemStack itemStack;
    private TextBox balanceTextbox;

    public WalletScreen(WalletMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.itemStack = pMenu.getItemStack();
        this.f_97727_ = 198;
        this.f_97729_ = -100;
        this.f_97731_ = -100;
    }

    public BigDecimal getBalance() {
        return WalletItem.getBalance(this.itemStack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addClickableCurrencyItems();
        this.m_142416_((GuiEventListener)new CheckCreatorWidget(this.f_97735_ - 21, this.f_97736_ + 1, value -> {
            if (value.compareTo(BigDecimal.ZERO) > 0 && value.compareTo(WalletItem.getBalance(this.itemStack)) <= 0) {
                Packets.sendToServer(new CreateCheckPacket((BigDecimal)value));
            }
        }, tooltip -> {
            this.tooltip = tooltip;
        }));
        this.balanceTextbox = (TextBox)this.m_142416_((GuiEventListener)new TextBox(this.f_97735_ + 70, this.f_97736_ + 10, 101, 15, "", -4473925));
        this.m_142416_((GuiEventListener)new SimpleButton(this.f_97735_ + 6, this.f_97736_ + 90, 56, 16, (Component)Component.m_237115_((String)"jackseconomy.deposit_all"), b -> Packets.sendToServer(new DepositAllPacket())));
    }

    private void addClickableCurrencyItems() {
        this.clickableCurrencyItems.clear();
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 2, this.f_97736_ + 14, 16, 16, CurrencyType.PENNY));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 18, this.f_97736_ + 14, 16, 16, CurrencyType.NICKEL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 34, this.f_97736_ + 14, 16, 16, CurrencyType.DIME));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 50, this.f_97736_ + 14, 16, 16, CurrencyType.QUARTER));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 3, this.f_97736_ - 4, 9, 16, CurrencyType.DOLLAR_BILL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 12, this.f_97736_ - 4, 9, 16, CurrencyType.FIVE_DOLLAR_BILL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 21, this.f_97736_ - 4, 9, 16, CurrencyType.TEN_DOLLAR_BILL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 30, this.f_97736_ - 4, 9, 16, CurrencyType.TWENTY_DOLLAR_BILL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 39, this.f_97736_ - 4, 9, 16, CurrencyType.FIFTY_DOLLAR_BILL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 48, this.f_97736_ - 4, 9, 16, CurrencyType.HUNDRED_DOLLAR_BILL));
        this.clickableCurrencyItems.add(new ClickableCurrencyItem(this.f_97735_ + 57, this.f_97736_ - 4, 9, 16, CurrencyType.THOUSAND_DOLLAR_BILL));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.tooltip = null;
        this.tooltipShift = false;
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
        BigDecimal balance = WalletItem.getBalance(this.itemStack);
        this.balanceTextbox.setText(CurrencyHelper.format(balance));
    }

    private static void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        guiGraphics.m_280649_(pFont, formattedcharsequence, pX - pFont.m_92724_(formattedcharsequence) / 2, pY, pColor, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean nothingHeld;
        int space;
        MutableComponent header;
        int headerWidth;
        float scale;
        Item item2;
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.m_280398_(ID_CARD, this.f_97735_ + 75, this.f_97736_ + 40, 0, 0.0f, 0.0f, 91, 44, 91, 44);
        if (Minecraft.m_91087_().f_91074_ != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Minecraft.m_91087_().f_91074_.m_108560_());
            PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)Minecraft.m_91087_().f_91074_.m_108560_(), (int)(this.f_97735_ + 75 + 4), (int)(this.f_97736_ + 40 + 15), (int)25);
        }
        if ((item2 = this.itemStack.m_41720_()) instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item2;
            if (WalletItem.getBalance(this.itemStack).compareTo(BigDecimal.valueOf(walletItem.getCapacity())) >= 0) {
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jackseconomy.capacity_overflow_reached").m_130940_(ChatFormatting.RED), this.f_96543_ / 2, this.f_97736_ - 15, -1);
            }
        }
        if ((scale = (headerWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)(header = Component.m_237110_((String)"jackseconomy.item_owner", (Object[])new Object[]{Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()), this.itemStack.m_41720_().m_41466_()})))) > (space = 82) ? (float)space / (float)headerWidth : 1.0f) != 1.0f) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        }
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)header, (int)((float)(this.f_97735_ + 78) / scale), (int)((float)(this.f_97736_ + 43) / scale), -16777216, false);
        if (scale != 1.0f) {
            guiGraphics.m_280168_().m_85849_();
        }
        float contentScale = 0.6f;
        float contentScaleInv = 1.0f / contentScale;
        AtomicInteger lineCount = new AtomicInteger();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(contentScale, contentScale, contentScale);
        Minecraft.m_91087_().f_91062_.m_92865_().m_92393_((FormattedText)Component.m_237115_((String)"jackseconomy.thanks_for_using"), (int)(57.0f * contentScaleInv), Style.f_131099_, (line, idk) -> {
            int count = lineCount.getAndAdd(1);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, line.getString(), (int)((float)(this.f_97735_ + 108) * contentScaleInv), (int)((float)(this.f_97736_ + 59 + count * 6) * contentScaleInv), -16777216, false);
        });
        guiGraphics.m_280168_().m_85849_();
        Item item3 = this.itemStack.m_41720_();
        if (item3 instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item3;
            BigDecimal balance = WalletItem.getBalance(this.itemStack);
            BigDecimal capacity = BigDecimal.valueOf(walletItem.getCapacity());
            double progress = balance.divide(capacity, RoundingMode.DOWN).min(BigDecimal.ONE).doubleValue();
            guiGraphics.m_280398_(ShoppingCartScreen.BALANCE_PROGRESS, this.f_97735_ + 70, this.f_97736_ + 28, 0, 0.0f, 65.0f, 101, 5, 256, 256);
            guiGraphics.m_280398_(ShoppingCartScreen.BALANCE_PROGRESS, this.f_97735_ + 70, this.f_97736_ + 28, 0, 0.0f, 70.0f, (int)(101.0 * progress), 5, 256, 256);
            if (pMouseX >= this.f_97735_ + 70 && pMouseX <= this.f_97735_ + 70 + 101 && pMouseY >= this.f_97736_ + 28 && pMouseY <= this.f_97736_ + 28 + 5) {
                this.tooltip = List.of(Component.m_237110_((String)"jackseconomy.max_storage", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(capacity)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)((int)(progress * 100.0) + "%")).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW));
            }
        }
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_ + 3, this.f_97736_ + 6, 176, 0, 65, 4);
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_ + 3, this.f_97736_ + 21, 176, 0, 65, 4);
        for (ClickableCurrencyItem item4 : this.clickableCurrencyItems.stream().sorted(Comparator.comparing(item -> pMouseX > item.x() && pMouseX <= item.x() + item.width && pMouseY > item.y && pMouseY <= item.y + item.height ? 1 : 0)).toList()) {
            boolean hovered;
            boolean bl = hovered = pMouseX > item4.x() && pMouseX <= item4.x() + item4.width && pMouseY > item4.y && pMouseY <= item4.y + item4.height;
            if (hovered) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
                guiGraphics.m_280168_().m_85837_(-1.0, -2.5, 0.0);
                RenderSystem.setShaderColor((float)1.25f, (float)1.25f, (float)1.25f, (float)1.0f);
                boolean shiftHeld = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
                boolean ctrlHeld = !shiftHeld && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341);
                nothingHeld = !shiftHeld && !ctrlHeld;
                this.tooltip = List.of(item4.currencyType.item.m_41466_(), Component.m_237115_((String)"jackseconomy.click_to_withdraw").m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)"jackseconomy.shift_coins").m_130940_(shiftHeld ? ChatFormatting.AQUA : ChatFormatting.GRAY), Component.m_237115_((String)"jackseconomy.ctrl_coins").m_130940_(ctrlHeld ? ChatFormatting.AQUA : ChatFormatting.GRAY), Component.m_237115_((String)"jackseconomy.normal_coins").m_130940_(nothingHeld ? ChatFormatting.AQUA : ChatFormatting.GRAY));
                this.tooltipShift = true;
            }
            guiGraphics.m_280163_(item4.getTexture(), (int)((float)item4.x() * (hovered ? 0.8f : 1.0f)), (int)((float)item4.y * (hovered ? 0.8f : 1.0f)), 0.0f, 0.0f, item4.width, item4.height, item4.width, item4.height);
            if (!hovered) continue;
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_ + 3, this.f_97736_ + 10, 176, 4, 67, 5);
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_ + 3, this.f_97736_ + 25, 176, 4, 67, 5);
        if (JacksEconomyClient.balanceDifPopup != null) {
            long maxTimeDelta;
            long timeDelta = System.currentTimeMillis() - JacksEconomyClient.balanceDifPopupStartMillis;
            if (timeDelta > (maxTimeDelta = (long)((Double)ClientConfig.balanceChangePopupTime.get() * 1000.0))) {
                JacksEconomyClient.balanceDifPopup = null;
                JacksEconomyClient.balanceDifPopupStartMillis = -1L;
                return;
            }
            int alpha = timeDelta < 500L ? (int)(255.0 * Mth.m_14139_((double)((double)timeDelta / 500.0), (double)0.0, (double)1.0)) : (timeDelta >= maxTimeDelta - 500L ? (int)(255.0 * Mth.m_14139_((double)((double)(maxTimeDelta - timeDelta) / 500.0), (double)0.0, (double)1.0)) : 255);
            if (alpha < 0 || alpha > 256) {
                nothingHeld = true;
            }
            String balanceDif = CurrencyHelper.formatShortened(JacksEconomyClient.balanceDifPopup);
            boolean positive = JacksEconomyClient.balanceDifPopup.compareTo(BigDecimal.ZERO) > 0;
            MutableComponent balanceDifComponent = Component.m_237113_((String)((positive ? "(+" : "(") + balanceDif + ")")).m_130940_(positive ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
            WalletScreen.drawCenteredStringNoShadow(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)balanceDifComponent, this.f_97735_ + 120, this.f_97736_ + 2, 0xFFFFFF | alpha << 24);
        }
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        if (this.tooltip != null) {
            if (this.tooltipShift) {
                int maxWidth = this.tooltip.stream().map(a -> Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)a)).max(Comparator.naturalOrder()).orElse(0);
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX - maxWidth / 2 - 10, this.f_97736_ + 48);
            } else {
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
            }
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            for (ClickableCurrencyItem item : this.clickableCurrencyItems) {
                if (!(pMouseX > (double)item.x()) || !(pMouseX <= (double)(item.x() + item.width)) || !(pMouseY > (double)item.y) || !(pMouseY <= (double)(item.y + item.height))) continue;
                BigDecimal balance = this.getBalance();
                BigDecimal worth = item.currencyType.worth;
                int count = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) ? Math.min(64, balance.divide(worth, RoundingMode.DOWN).intValue()) : (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) ? Math.min(10, balance.divide(worth, RoundingMode.DOWN).intValue()) : Math.min(1, balance.divide(worth, RoundingMode.DOWN).intValue()));
                if (count > 0) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    Packets.sendToServer(new WithdrawBalanceSpecificPacket(count, item.currencyType));
                    return true;
                }
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)0.9f));
                return false;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private record ClickableCurrencyItem(int x, int y, int width, int height, CurrencyType currencyType) {
        private static final ResourceLocation PENNY_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/penny.png");
        private static final ResourceLocation NICKEL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/nickel.png");
        private static final ResourceLocation DIME_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/dime.png");
        private static final ResourceLocation QUARTER_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/quarter.png");
        private static final ResourceLocation DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/dollar_bill.png");
        private static final ResourceLocation FIVE_DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/five_dollar_bill.png");
        private static final ResourceLocation TEN_DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/ten_dollar_bill.png");
        private static final ResourceLocation TWENTY_DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/twenty_dollar_bill.png");
        private static final ResourceLocation FIFTY_DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/fifty_dollar_bill.png");
        private static final ResourceLocation HUNDRED_DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/hundred_dollar_bill.png");
        private static final ResourceLocation THOUSAND_DOLLAR_BILL_TEXTURE = new ResourceLocation("jackseconomy", "textures/gui/wallet_items/thousand_dollar_bill.png");

        public ResourceLocation getTexture() {
            return switch (this.currencyType) {
                default -> throw new IncompatibleClassChangeError();
                case CurrencyType.PENNY -> PENNY_TEXTURE;
                case CurrencyType.NICKEL -> NICKEL_TEXTURE;
                case CurrencyType.DIME -> DIME_TEXTURE;
                case CurrencyType.QUARTER -> QUARTER_TEXTURE;
                case CurrencyType.DOLLAR_BILL -> DOLLAR_BILL_TEXTURE;
                case CurrencyType.FIVE_DOLLAR_BILL -> FIVE_DOLLAR_BILL_TEXTURE;
                case CurrencyType.TEN_DOLLAR_BILL -> TEN_DOLLAR_BILL_TEXTURE;
                case CurrencyType.TWENTY_DOLLAR_BILL -> TWENTY_DOLLAR_BILL_TEXTURE;
                case CurrencyType.FIFTY_DOLLAR_BILL -> FIFTY_DOLLAR_BILL_TEXTURE;
                case CurrencyType.HUNDRED_DOLLAR_BILL -> HUNDRED_DOLLAR_BILL_TEXTURE;
                case CurrencyType.THOUSAND_DOLLAR_BILL -> THOUSAND_DOLLAR_BILL_TEXTURE;
            };
        }
    }
}

