/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.gamestages.GameStagesManager;
import me.khajiitos.jackseconomy.init.ItemBlockReg;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.init.Sounds;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.menu.AdminShopMenu;
import me.khajiitos.jackseconomy.packet.AdminShopPurchasePacket;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.screen.AdminShopScreen;
import me.khajiitos.jackseconomy.screen.widget.BetterScrollPanel;
import me.khajiitos.jackseconomy.screen.widget.ShoppingCartEntry;
import me.khajiitos.jackseconomy.screen.widget.ShoppingCartSellEntry;
import me.khajiitos.jackseconomy.screen.widget.TextWidget;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ShoppingCartScreen
extends AbstractContainerScreen<AdminShopMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/shopping_cart.png");
    private static final ResourceLocation NO_WALLET = new ResourceLocation("jackseconomy", "textures/gui/no_wallet.png");
    protected static final ResourceLocation BALANCE_PROGRESS = new ResourceLocation("jackseconomy", "textures/gui/balance_progress.png");
    public final AdminShopScreen parent;
    private BetterScrollPanel shoppingCartPanel;
    private List<Component> tooltip;
    private Button purchaseButton;
    private final boolean oneItemCurrencyMode;

    public ShoppingCartScreen(AdminShopMenu pMenu, Inventory pPlayerInventory, AdminShopScreen parent) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)Component.m_237119_());
        this.parent = parent;
        this.f_97727_ = 232;
        this.f_97731_ = this.f_97727_ - 94;
        this.oneItemCurrencyMode = parent.oneItemCurrencyMode;
    }

    public BigDecimal getShoppingCartValue() {
        BigDecimal value = BigDecimal.ZERO;
        for (Map.Entry<AdminShopScreen.CategorizedShopItem, Integer> items : this.parent.shoppingCart.entrySet()) {
            value = value.add(BigDecimal.valueOf(items.getKey().price()).multiply(new BigDecimal(items.getValue())));
        }
        return value;
    }

    public BigDecimal getSoldValue() {
        BigDecimal value = BigDecimal.ZERO;
        for (Map.Entry<ItemDescription, Integer> item : this.parent.itemsToSell.entrySet()) {
            BigDecimal itemValue = BigDecimal.valueOf(this.parent.sellPrices.get(item.getKey()).worth());
            value = value.add(itemValue.multiply(new BigDecimal(item.getValue())));
        }
        return value;
    }

    public void addPurchaseButton() {
        boolean canAfford;
        ItemStack wallet = CuriosWallet.get((Player)Minecraft.m_91087_().f_91074_);
        BigDecimal toPay = this.getShoppingCartValue().subtract(this.getSoldValue());
        if (this.oneItemCurrencyMode) {
            canAfford = OIMWalletItem.getTotalDollars(wallet, (Player)Minecraft.m_91087_().f_91074_) >= toPay.longValue();
        } else {
            boolean bl = canAfford = !wallet.m_41619_() && WalletItem.getBalance(wallet).compareTo(toPay) >= 0;
        }
        MutableComponent buttonName = !this.parent.itemsToSell.isEmpty() ? (this.parent.shoppingCart.isEmpty() ? Component.m_237115_((String)"jackseconomy.sell") : Component.m_237115_((String)"jackseconomy.purchase_and_sell")) : Component.m_237115_((String)"jackseconomy.purchase");
        this.purchaseButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)buttonName.m_130940_(canAfford && (!this.parent.shoppingCart.isEmpty() || !this.parent.itemsToSell.isEmpty()) ? ChatFormatting.GREEN : ChatFormatting.RED), b -> {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)Sounds.CHECKOUT.get()), (float)1.0f));
            HashMap<AdminShopPurchasePacket.ShopItemDescription, Integer> map = new HashMap<AdminShopPurchasePacket.ShopItemDescription, Integer>();
            this.parent.shoppingCart.forEach((shopItem, amount) -> map.put(new AdminShopPurchasePacket.ShopItemDescription(shopItem.itemDescription(), shopItem.slot(), shopItem.category()), (Integer)amount));
            Packets.sendToServer(new AdminShopPurchasePacket(map, this.parent.itemsToSell));
            this.parent.shoppingCart.clear();
            this.parent.itemsToSell.clear();
            this.m_169413_();
            this.m_7856_();
        }).m_252987_(this.f_97735_ + 82, this.f_97736_ + 125, 87, 20).m_253136_());
        if (!canAfford || this.parent.shoppingCart.isEmpty() && this.parent.itemsToSell.isEmpty()) {
            this.purchaseButton.f_93623_ = false;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.shoppingCartPanel = (BetterScrollPanel)this.m_142416_((GuiEventListener)new BetterScrollPanel(this.f_96541_, this.f_97735_ + 7, this.f_97736_ + 12, 162, 109));
        if (!this.parent.shoppingCart.isEmpty()) {
            this.shoppingCartPanel.children.add(new TextWidget(0, 0, 162, (Component)Component.m_237115_((String)"jackseconomy.buying").m_130940_(ChatFormatting.GRAY)));
        }
        for (Map.Entry<AdminShopScreen.CategorizedShopItem, Integer> entry : this.parent.shoppingCart.entrySet()) {
            this.shoppingCartPanel.children.add(new ShoppingCartEntry(0, 0, 162, 20, this.oneItemCurrencyMode, entry, () -> {
                this.m_169411_((GuiEventListener)this.purchaseButton);
                this.addPurchaseButton();
            }, () -> {
                this.parent.shoppingCart.remove(shoppingCartEntry.getKey());
                this.m_169413_();
                this.m_7856_();
            }));
        }
        if (!this.parent.itemsToSell.isEmpty()) {
            this.shoppingCartPanel.children.add(new TextWidget(0, 0, 162, (Component)Component.m_237115_((String)"jackseconomy.selling").m_130940_(ChatFormatting.GRAY)));
        }
        for (Map.Entry<Object, Integer> entry : this.parent.itemsToSell.entrySet()) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            this.shoppingCartPanel.children.add(new ShoppingCartSellEntry(0, 0, 162, 20, this.oneItemCurrencyMode, entry, this.parent.sellPrices.get(entry.getKey()).worth(), Minecraft.m_91087_().f_91074_.m_150109_(), () -> {
                this.parent.reduceSellItemsIfMissing();
                this.m_169411_((GuiEventListener)this.purchaseButton);
                this.addPurchaseButton();
            }, () -> {
                this.parent.itemsToSell.remove(itemToSell.getKey());
                this.m_169413_();
                this.m_7856_();
            }));
        }
        this.addPurchaseButton();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(BACKGROUND, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        BigDecimal soldValue;
        ItemStack wallet;
        this.tooltip = null;
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        AdminShopScreen.renderDollarSignForSellableItems(guiGraphics, this.f_97735_, this.f_97736_, (List<Slot>)((AdminShopMenu)this.m_6262_()).f_38839_, this.parent.itemsToSell, this.parent.sellPrices);
        if (this.purchaseButton.m_274382_()) {
            boolean canAfford;
            wallet = CuriosWallet.get((Player)Minecraft.m_91087_().f_91074_);
            BigDecimal shoppingCartValue = this.getShoppingCartValue();
            soldValue = this.getSoldValue();
            BigDecimal totalValue = shoppingCartValue.subtract(soldValue);
            if (this.oneItemCurrencyMode) {
                canAfford = OIMWalletItem.getTotalDollars(wallet, (Player)Minecraft.m_91087_().f_91074_) >= totalValue.longValue();
            } else {
                boolean bl = canAfford = !wallet.m_41619_() && WalletItem.getBalance(wallet).compareTo(totalValue) >= 0;
            }
            if (wallet.m_41619_() && !this.oneItemCurrencyMode) {
                this.tooltip = List.of(Component.m_237115_((String)"jackseconomy.no_wallet").m_130940_(ChatFormatting.YELLOW));
            } else if (!canAfford) {
                this.tooltip = List.of(Component.m_237115_((String)"jackseconomy.cant_afford").m_130940_(ChatFormatting.RED));
            } else if (this.parent.shoppingCart.isEmpty() && this.parent.itemsToSell.isEmpty()) {
                this.tooltip = List.of(Component.m_237115_((String)"jackseconomy.shopping_cart_empty").m_130940_(ChatFormatting.YELLOW));
            } else {
                this.tooltip = new ArrayList<Component>();
                if (!this.parent.shoppingCart.isEmpty()) {
                    this.tooltip.add((Component)Component.m_237110_((String)"jackseconomy.bought_items", (Object[])new Object[]{Component.m_237113_((String)((Boolean)Config.oneItemCurrencyMode.get() != false ? "$" + shoppingCartValue.longValue() : CurrencyHelper.format(shoppingCartValue))).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_AQUA));
                }
                if (!this.parent.itemsToSell.isEmpty()) {
                    this.tooltip.add((Component)Component.m_237110_((String)"jackseconomy.sold_items", (Object[])new Object[]{Component.m_237113_((String)((Boolean)Config.oneItemCurrencyMode.get() != false ? "$" + soldValue.longValue() : CurrencyHelper.format(soldValue))).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_AQUA));
                }
                this.tooltip.add((Component)Component.m_237110_((String)"jackseconomy.total", (Object[])new Object[]{Component.m_237113_((String)((Boolean)Config.oneItemCurrencyMode.get() != false ? "$" + totalValue.longValue() : CurrencyHelper.format(totalValue))).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_AQUA));
                if (!this.parent.shoppingCart.isEmpty()) {
                    this.tooltip.add((Component)Component.m_237113_((String)" "));
                    this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.buying").m_130940_(ChatFormatting.GRAY));
                    this.parent.shoppingCart.forEach((shopItem, amount) -> this.tooltip.add((Component)shopItem.itemDescription().item().m_41466_().m_6881_().m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(" x" + amount)).m_130940_(ChatFormatting.BLUE))));
                }
                if (!this.parent.itemsToSell.isEmpty()) {
                    this.tooltip.add((Component)Component.m_237113_((String)" "));
                    this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.selling").m_130940_(ChatFormatting.GRAY));
                    this.parent.itemsToSell.forEach((itemDescription, amount) -> this.tooltip.add((Component)itemDescription.item().m_41466_().m_6881_().m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(" x" + amount)).m_130940_(ChatFormatting.BLUE))));
                }
            }
        }
        wallet = CuriosWallet.get((Player)Minecraft.m_91087_().f_91074_);
        if (!((Boolean)Config.oneItemCurrencyMode.get()).booleanValue() && wallet != null && (soldValue = wallet.m_41720_()) instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)((Object)soldValue);
            BigDecimal balance = WalletItem.getBalance(wallet);
            MutableComponent component = Component.m_237113_((String)CurrencyHelper.formatShortened(balance));
            int textWidth = this.f_96547_.m_92852_((FormattedText)component);
            int totalWidth = 29 + textWidth;
            guiGraphics.m_280509_(this.f_97735_ + 181, this.f_97736_ + 5, this.f_97735_ + 181 + totalWidth, this.f_97736_ + 35, -11776948);
            guiGraphics.m_280509_(this.f_97735_ + 182, this.f_97736_ + 6, this.f_97735_ + 182 + totalWidth, this.f_97736_ + 34, -3750202);
            guiGraphics.m_280480_(wallet, this.f_97735_ + 183, this.f_97736_ + 8);
            guiGraphics.m_280430_(this.f_96547_, (Component)component, this.f_97735_ + 203, this.f_97736_ + 13, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BALANCE_PROGRESS);
            int barStartX = this.f_97735_ + 181 + (totalWidth - 51) / 2;
            int barStartY = this.f_97736_ + 26;
            double progress = balance.divide(BigDecimal.valueOf(walletItem.getCapacity()), RoundingMode.DOWN).min(BigDecimal.ONE).doubleValue();
            guiGraphics.m_280398_(BALANCE_PROGRESS, barStartX, barStartY, 0, 0.0f, 0.0f, 51, 5, 256, 256);
            guiGraphics.m_280398_(BALANCE_PROGRESS, barStartX, barStartY, 0, 0.0f, 5.0f, (int)(51.0 * progress), 5, 256, 256);
            if (pMouseX >= barStartX && pMouseX <= barStartX + 51 && pMouseY >= barStartY && pMouseY <= barStartY + 5) {
                this.tooltip = List.of(Component.m_237110_((String)"jackseconomy.balance_out_of", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(balance)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)CurrencyHelper.format(walletItem.getCapacity()))}).m_130940_(ChatFormatting.GOLD));
            }
        } else if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue()) {
            long balance = OIMWalletItem.getTotalDollars(wallet, (Player)Minecraft.m_91087_().f_91074_);
            MutableComponent component = Component.m_237113_((String)("$" + balance));
            int textWidth = this.f_96547_.m_92852_((FormattedText)component);
            int totalWidth = 29 + textWidth;
            guiGraphics.m_280509_(this.f_97735_ + 181, this.f_97736_ + 5, this.f_97735_ + 181 + totalWidth, this.f_97736_ + 27, -11776948);
            guiGraphics.m_280509_(this.f_97735_ + 182, this.f_97736_ + 6, this.f_97735_ + 182 + totalWidth, this.f_97736_ + 26, -3750202);
            guiGraphics.m_280480_(wallet != null && !wallet.m_41619_() ? wallet : new ItemStack((ItemLike)ItemBlockReg.WALLET_ITEM.get()), this.f_97735_ + 183, this.f_97736_ + 8);
            guiGraphics.m_280430_(this.f_96547_, (Component)component, this.f_97735_ + 203, this.f_97736_ + 13, -1);
        } else {
            MutableComponent component = Component.m_237115_((String)"jackseconomy.no_wallet").m_130940_(ChatFormatting.DARK_RED);
            int width = this.f_96547_.m_92852_((FormattedText)component);
            guiGraphics.m_280509_(this.f_97735_ + 181, this.f_97736_ + 5, this.f_97735_ + 209 + width, this.f_97736_ + 25, -11776948);
            guiGraphics.m_280509_(this.f_97735_ + 182, this.f_97736_ + 6, this.f_97735_ + 208 + width, this.f_97736_ + 24, -3750202);
            guiGraphics.m_280398_(NO_WALLET, this.f_97735_ + 183, this.f_97736_ + 8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, this.f_97735_ + 203, this.f_97736_ + 13, -1, false);
        }
        if (((AdminShopMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            double price;
            ItemStack itemstack = this.f_97734_.m_7993_();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(this.m_280553_(itemstack));
            ItemDescription itemDescription2 = ItemDescription.ofItem(itemstack);
            AdminShopScreen.ItemSellabilityInfo info = this.parent.sellPrices.get(itemDescription2);
            String stage = info != null ? info.stage() : null;
            double d = price = info != null ? info.worth() : -1.0;
            if (!((Boolean)Config.disableAdminShopSelling.get()).booleanValue()) {
                tooltip.add(Component.m_237113_((String)" "));
                if (stage != null && !GameStagesManager.hasGameStage((Player)Minecraft.m_91087_().f_91074_, stage)) {
                    if (((Boolean)Config.showStageForLockedSellItems.get()).booleanValue()) {
                        tooltip.add(Component.m_237110_((String)"jackseconomy.selling_locked_behind_gamestage", (Object[])new Object[]{stage}).m_130940_(ChatFormatting.GRAY));
                    } else {
                        tooltip.add(Component.m_237115_((String)"jackseconomy.selling_locked").m_130940_(ChatFormatting.GRAY));
                    }
                } else if (price != -1.0) {
                    tooltip.add(Component.m_237113_((String)(this.oneItemCurrencyMode ? "$" + (long)price : CurrencyHelper.format(price))).m_130940_(ChatFormatting.GRAY));
                    tooltip.add(Component.m_237110_((String)"jackseconomy.to_sell", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.parent.itemsToSell.getOrDefault(itemDescription2, 0))).m_130940_(ChatFormatting.AQUA)}));
                } else {
                    tooltip.add(Component.m_237115_((String)"jackseconomy.no_sell_price").m_130940_(ChatFormatting.GRAY));
                }
            }
            guiGraphics.renderTooltip(this.f_96547_, tooltip, itemstack.m_150921_(), itemstack, pMouseX, pMouseY);
        }
        if (this.tooltip != null) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    protected void m_6597_(Slot pSlot, int pSlotId, int pMouseButton, @NotNull ClickType pType) {
        if (!(((Boolean)Config.disableAdminShopSelling.get()).booleanValue() || pSlot == null || pType != ClickType.QUICK_MOVE && pType != ClickType.SWAP && pType != ClickType.PICKUP || pMouseButton != 0 && pMouseButton != 1)) {
            String stage;
            ItemDescription itemDescription = ItemDescription.ofItem(pSlot.m_7993_());
            AdminShopScreen.ItemSellabilityInfo info = this.parent.sellPrices.get(itemDescription);
            String string = stage = info != null ? info.stage() : null;
            if (stage != null && !GameStagesManager.hasGameStage((Player)Minecraft.m_91087_().f_91074_, stage)) {
                return;
            }
            if (this.parent.sellPrices.containsKey(itemDescription)) {
                int newAmount;
                int oldAmount = this.parent.itemsToSell.getOrDefault(itemDescription, 0);
                int count = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) ? 64 : (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) ? 10 : 1);
                if (pMouseButton == 1) {
                    count *= -1;
                }
                if ((newAmount = Math.max(0, oldAmount + count)) > 0) {
                    this.parent.itemsToSell.put(itemDescription, Math.max(0, oldAmount + count));
                } else {
                    this.parent.itemsToSell.remove(itemDescription);
                }
                if (!this.parent.reduceSellItemsIfMissing()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)(pMouseButton == 1 ? 0.75f : 1.25f)));
                    this.m_169413_();
                    this.m_7856_();
                }
            }
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.parent.reduceSellItemsIfMissing()) {
            this.m_169413_();
            this.m_7856_();
        }
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.f_91080_ = this.parent;
        this.f_96541_.f_91080_.m_6575_(this.f_96541_, this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_());
    }
}

