/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import me.khajiitos.jackseconomy.JacksEconomyClient;
import me.khajiitos.jackseconomy.config.ClientConfig;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.menu.OIMWalletMenu;
import me.khajiitos.jackseconomy.screen.widget.TextBox;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class OIMWalletScreen
extends AbstractContainerScreen<OIMWalletMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/oim_wallet.png");
    private static final ResourceLocation ID_CARD = new ResourceLocation("jackseconomy", "textures/gui/id_card.png");
    private List<Component> tooltip;
    private boolean tooltipShift = false;
    private final ItemStack itemStack;
    private TextBox balanceTextbox;

    public OIMWalletScreen(OIMWalletMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.itemStack = pMenu.getItemStack();
        this.f_97727_ = 198;
        this.f_97729_ = -100;
        this.f_97731_ = -100;
    }

    public BigDecimal getBalance() {
        return WalletItem.getBalance(this.itemStack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.balanceTextbox = (TextBox)this.m_142416_((GuiEventListener)new TextBox(this.f_97735_ + 70, this.f_97736_ + 10, 101, 15, "", -4473925));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.tooltip = null;
        this.tooltipShift = false;
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
        long balance = OIMWalletItem.getDollars(this.itemStack);
        this.balanceTextbox.setText("$" + balance);
    }

    private static void drawCenteredStringNoShadow(GuiGraphics guiGraphics, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        guiGraphics.m_280649_(pFont, formattedcharsequence, pX - pFont.m_92724_(formattedcharsequence) / 2, pY, pColor, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int space;
        MutableComponent header;
        int headerWidth;
        float scale;
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.m_280398_(ID_CARD, this.f_97735_ + 75, this.f_97736_ + 40, 0, 0.0f, 0.0f, 91, 44, 91, 44);
        if (Minecraft.m_91087_().f_91074_ != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Minecraft.m_91087_().f_91074_.m_108560_());
            PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)Minecraft.m_91087_().f_91074_.m_108560_(), (int)(this.f_97735_ + 75 + 4), (int)(this.f_97736_ + 40 + 15), (int)25);
        }
        if ((scale = (headerWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)(header = Component.m_237110_((String)"jackseconomy.item_owner", (Object[])new Object[]{Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()), this.itemStack.m_41720_().m_41466_()})))) > (space = 82) ? (float)space / (float)headerWidth : 1.0f) != 1.0f) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        }
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)header, (int)((float)(this.f_97735_ + 78) / scale), (int)((float)(this.f_97736_ + 43) / scale), -16777216, false);
        if (scale != 1.0f) {
            guiGraphics.m_280168_().m_85849_();
        }
        float contentScale = 0.6f;
        float contentScaleInv = 1.0f / contentScale;
        AtomicInteger lineCount = new AtomicInteger();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(contentScale, contentScale, contentScale);
        Minecraft.m_91087_().f_91062_.m_92865_().m_92393_((FormattedText)Component.m_237115_((String)"jackseconomy.thanks_for_using"), (int)(57.0f * contentScaleInv), Style.f_131099_, (line, idk) -> {
            int count = lineCount.getAndAdd(1);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, line.getString(), (int)((float)(this.f_97735_ + 108) * contentScaleInv), (int)((float)(this.f_97736_ + 59 + count * 6) * contentScaleInv), -16777216, false);
        });
        guiGraphics.m_280168_().m_85849_();
        if (JacksEconomyClient.balanceDifPopup != null) {
            long maxTimeDelta;
            long timeDelta = System.currentTimeMillis() - JacksEconomyClient.balanceDifPopupStartMillis;
            if (timeDelta > (maxTimeDelta = (long)((Double)ClientConfig.balanceChangePopupTime.get() * 1000.0))) {
                JacksEconomyClient.balanceDifPopup = null;
                JacksEconomyClient.balanceDifPopupStartMillis = -1L;
                return;
            }
            int alpha = timeDelta < 500L ? (int)(255.0 * Mth.m_14139_((double)((double)timeDelta / 500.0), (double)0.0, (double)1.0)) : (timeDelta >= maxTimeDelta - 500L ? (int)(255.0 * Mth.m_14139_((double)((double)(maxTimeDelta - timeDelta) / 500.0), (double)0.0, (double)1.0)) : 255);
            if (alpha < 0 || alpha > 256) {
                boolean bl = true;
            }
            String balanceDif = CurrencyHelper.formatShortened(JacksEconomyClient.balanceDifPopup);
            boolean positive = JacksEconomyClient.balanceDifPopup.compareTo(BigDecimal.ZERO) > 0;
            MutableComponent balanceDifComponent = Component.m_237113_((String)((positive ? "(+" : "(") + balanceDif + ")")).m_130940_(positive ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
            OIMWalletScreen.drawCenteredStringNoShadow(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)balanceDifComponent, this.f_97735_ + 120, this.f_97736_ + 2, 0xFFFFFF | alpha << 24);
        }
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        if (this.tooltip != null) {
            if (this.tooltipShift) {
                int maxWidth = this.tooltip.stream().map(a -> Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)a)).max(Comparator.naturalOrder()).orElse(0);
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX - maxWidth / 2 - 10, this.f_97736_ + 48);
            } else {
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
            }
        }
    }
}

