/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import java.util.List;
import java.util.Optional;
import me.khajiitos.jackseconomy.blockentity.ExporterBlockEntity;
import me.khajiitos.jackseconomy.blockentity.TransactionMachineBlockEntity;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.menu.ExporterMenu;
import me.khajiitos.jackseconomy.packet.ChangeSpeedPacket;
import me.khajiitos.jackseconomy.screen.AbstractExporterScreen;
import me.khajiitos.jackseconomy.screen.widget.EnergyStatusWidget;
import me.khajiitos.jackseconomy.screen.widget.SpeedVerticalSlider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.energy.IEnergyStorage;

public class ExporterScreen
extends AbstractExporterScreen<ExporterBlockEntity, ExporterMenu> {
    private SpeedVerticalSlider slider;
    private EnergyStatusWidget energyStatus;

    public ExporterScreen(ExporterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, (Component)Component.m_237119_());
        this.f_97727_ = 177;
        this.f_97731_ = this.f_97727_ - 96;
    }

    private ExporterBlockEntity getBlockEntity() {
        TransactionMachineBlockEntity transactionMachineBlockEntity = ((ExporterMenu)this.f_97732_).getBlockEntity();
        if (transactionMachineBlockEntity instanceof ExporterBlockEntity) {
            ExporterBlockEntity blockEntity = (ExporterBlockEntity)transactionMachineBlockEntity;
            return blockEntity;
        }
        return null;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ExporterBlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity != null) {
            this.slider = (SpeedVerticalSlider)this.m_142416_((GuiEventListener)new SpeedVerticalSlider(this.f_96543_ / 2 + 70, this.f_96544_ / 2 - 79, 12, 65, blockEntity.getSpeed(), newValue -> {
                blockEntity.setSpeed(newValue.floatValue());
                Packets.sendToServer(new ChangeSpeedPacket(newValue.floatValue()));
            }));
            this.energyStatus = (EnergyStatusWidget)this.m_142416_((GuiEventListener)new EnergyStatusWidget(this.f_96543_ / 2 + 50, this.f_96544_ / 2 - 79, blockEntity.getEnergyStorage()));
        }
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        super.m_94757_(pMouseX, pMouseY);
        this.slider.m_94757_(pMouseX, pMouseY);
    }

    @Override
    protected void renderTooltipsOrSomething(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ExporterBlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity != null) {
            if (this.energyStatus.m_274382_()) {
                IEnergyStorage energyStorage = blockEntity.getEnergyStorage();
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)(energyStorage.getEnergyStored() + "FE/" + energyStorage.getMaxEnergyStored() + "FE")), mouseX, mouseY);
            } else if (this.slider.m_274382_()) {
                int fePerTick = blockEntity.getEnergyUsagePerTick();
                String progressPerTickPercent = String.format("%.2f%%", blockEntity.getProgressPerTick() * 100.0);
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237110_((String)"jackseconomy.fe_per_tick", (Object[])new Object[]{fePerTick}).m_130940_(ChatFormatting.GRAY), Component.m_237110_((String)"jackseconomy.progress_per_tick", (Object[])new Object[]{progressPerTickPercent}).m_130940_(ChatFormatting.GRAY)), Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean b = super.m_6375_(pMouseX, pMouseY, pButton);
        if (pMouseX >= (double)this.slider.m_252754_() && pMouseX <= (double)(this.slider.m_252754_() + this.slider.m_5711_()) && pMouseY >= (double)this.slider.m_252907_() && pMouseY <= (double)(this.slider.m_252907_() + this.slider.m_93694_())) {
            this.slider.dragging = true;
        }
        return b;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.slider.dragging = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }
}

