/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.gamestages.GameStagesCheck;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.menu.AdminShopMenu;
import me.khajiitos.jackseconomy.packet.UpdateAdminShopPacket;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.screen.AdminShopScreen;
import me.khajiitos.jackseconomy.screen.widget.BetterScrollPanel;
import me.khajiitos.jackseconomy.screen.widget.EditCategoryEntry;
import me.khajiitos.jackseconomy.screen.widget.FloatingEditBoxWidget;
import me.khajiitos.jackseconomy.util.ItemHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EditAdminShopScreen
extends AdminShopScreen {
    protected AdminShopScreen.ShopItem itemOnCursor;
    protected FloatingEditBoxWidget floatingEditBox;

    public EditAdminShopScreen(AdminShopMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        pMenu.setSlotsLocked(true);
    }

    @Override
    protected boolean isHoverObstructed(int mouseX, int mouseY) {
        return this.floatingEditBox != null && mouseX >= this.floatingEditBox.m_252754_() && mouseX <= this.floatingEditBox.m_252754_() + this.floatingEditBox.m_5711_() && mouseY >= this.floatingEditBox.m_252907_() && mouseY <= this.floatingEditBox.m_252907_() + this.floatingEditBox.m_5711_();
    }

    @Override
    protected void initCategoryPanel() {
        if (this.categoryPanel != null) {
            this.m_169411_((GuiEventListener)this.categoryPanel);
        }
        this.categoryPanel = (BetterScrollPanel)this.m_142416_((GuiEventListener)new BetterScrollPanel(Minecraft.m_91087_(), this.f_97735_ - 80, this.f_97736_ + 20, 75, this.f_97727_ - 40));
        for (AdminShopScreen.Category category : this.shopItems.keySet()) {
            this.categoryPanel.children.add(new EditCategoryEntry(0, 0, 75, 25, category, (categoryEntry, button) -> {
                if (button == 0) {
                    if (this.itemOnCursor != null) {
                        category.item = this.itemOnCursor.itemDescription().item();
                        this.itemOnCursor = null;
                    } else {
                        this.selectBigCategory(category);
                    }
                } else if (button == 1) {
                    if (this.floatingEditBox != null) {
                        this.m_169411_((GuiEventListener)this.floatingEditBox);
                        this.floatingEditBox = null;
                    }
                    this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, categoryEntry.m_252754_() + 37, categoryEntry.m_252907_() + 20, 75, 15, value -> {
                        for (AdminShopScreen.Category otherCategory : this.shopItems.keySet()) {
                            if (this.shopItems.size() > 1 && otherCategory == category) continue;
                            if (otherCategory.name.equals(value)) {
                                return;
                            }
                            category.name = value;
                            if (this.floatingEditBox != null) {
                                this.m_169411_((GuiEventListener)this.floatingEditBox);
                                this.floatingEditBox = null;
                            }
                            return;
                        }
                    }));
                    this.m_7522_((GuiEventListener)this.floatingEditBox);
                } else if (button == 2) {
                    this.shopItems.remove(category);
                    if (this.selectedCategory == category) {
                        this.selectedCategory = null;
                        Iterator iterator = this.shopItems.keySet().iterator();
                        if (iterator.hasNext()) {
                            AdminShopScreen.Category category1 = (AdminShopScreen.Category)iterator.next();
                            this.selectBigCategory(category1);
                        }
                        if (this.selectedCategory == null) {
                            this.selectBigCategory(null);
                        }
                    }
                    this.initCategoryPanel();
                }
            }, () -> this.selectedBigCategory == category, () -> {
                this.tooltip = List.of(Component.m_237115_((String)"jackseconomy.right_click_to_rename").m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)"jackseconomy.middle_click_to_remove_category").m_130940_(ChatFormatting.RED));
            }));
        }
        this.categoryPanel.children.add(new EditCategoryEntry(0, 0, 75, 25, null, (categoryEntry, button) -> {
            if (button == 0 && this.itemOnCursor != null) {
                AdminShopScreen.Category category = new AdminShopScreen.Category(this.getUnnamedCategoryName(), this.itemOnCursor.itemDescription().item());
                this.shopItems.put(category, new LinkedHashMap());
                this.initCategoryPanel();
                this.itemOnCursor = null;
            }
        }, () -> false, () -> {
            this.tooltip = List.of(Component.m_237115_((String)"jackseconomy.drop_item_to_create_category"));
        }));
    }

    @Override
    protected List<AdminShopScreen.InnerCategory> getInnerCategories(AdminShopScreen.Category category) {
        return ((LinkedHashMap)this.shopItems.get(category)).keySet().stream().toList();
    }

    protected String getUnnamedInnerCategoryName() {
        List<AdminShopScreen.InnerCategory> categories = this.getInnerCategories();
        int i = -1;
        while (true) {
            String name = "Unnamed" + (String)(i == -1 ? "" : " " + i);
            boolean exists = false;
            for (AdminShopScreen.InnerCategory category : categories) {
                if (!category.name.equals(name)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                return name;
            }
            ++i;
        }
    }

    protected String getUnnamedCategoryName() {
        List categories = this.shopItems.keySet().stream().toList();
        int i = -1;
        while (true) {
            String name = "Unnamed" + (String)(i == -1 ? "" : " " + i);
            boolean exists = false;
            for (AdminShopScreen.InnerCategory category : categories) {
                if (!category.name.equals(name)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                return name;
            }
            ++i;
        }
    }

    @Override
    protected boolean onCategorySlotClicked(int pButton, int categoryId) {
        AdminShopScreen.InnerCategory category;
        if (pButton == 0) {
            List<AdminShopScreen.InnerCategory> categories = this.getInnerCategories();
            if (categoryId == categories.size() && this.itemOnCursor != null && this.floatingEditBox == null) {
                AdminShopScreen.InnerCategory category2 = new AdminShopScreen.InnerCategory(this.getUnnamedInnerCategoryName(), this.itemOnCursor.itemDescription().item());
                if (this.selectedCategory == null) {
                    this.selectedCategory = category2;
                }
                ((LinkedHashMap)this.shopItems.get(this.selectedBigCategory)).put(category2, new ArrayList());
                int categoryRenderId = categoryId - this.categoryOffset;
                int categoryX = this.f_97735_ + 17 + categoryRenderId * 18;
                int categoryY = this.f_97736_ + 27;
                this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, categoryX + 8, categoryY + 18, 50, 15, value -> {
                    for (AdminShopScreen.InnerCategory otherCategory : this.shopItems.keySet()) {
                        if (otherCategory == category2) continue;
                        if (otherCategory.name.equals(value)) {
                            return;
                        }
                        category.name = value;
                        if (this.floatingEditBox != null) {
                            this.m_169411_((GuiEventListener)this.floatingEditBox);
                            this.floatingEditBox = null;
                        }
                        return;
                    }
                }));
                this.m_7522_((GuiEventListener)this.floatingEditBox);
                this.itemOnCursor = null;
                return true;
            }
        } else if (pButton == 1) {
            int categoryRenderId = categoryId - this.categoryOffset;
            int categoryX = this.f_97735_ + 17 + categoryRenderId * 18;
            int categoryY = this.f_97736_ + 27;
            AdminShopScreen.InnerCategory category3 = this.getCategoryById(categoryId);
            if (category3 != null && this.floatingEditBox == null) {
                this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, categoryX + 8, categoryY + 18, 50, 15, value -> {
                    category.name = value;
                    this.m_169411_((GuiEventListener)this.floatingEditBox);
                    this.floatingEditBox = null;
                }));
                this.m_7522_((GuiEventListener)this.floatingEditBox);
            }
        } else if (pButton == 2 && (category = this.getCategoryById(categoryId)) != null) {
            ((LinkedHashMap)this.shopItems.get(this.selectedBigCategory)).remove(category);
            if (this.selectedCategory == category) {
                this.selectedCategory = null;
            }
        }
        return super.onCategorySlotClicked(pButton, categoryId);
    }

    @Override
    protected void onSlotClicked(int slot, int pButton) {
        if (pButton == 0) {
            AdminShopScreen.ShopItem onCursorBefore = this.itemOnCursor;
            if (onCursorBefore != null && onCursorBefore.price() == -1.0 && this.floatingEditBox == null) {
                Pair<Integer, Integer> slotPos = this.getSlotPos(slot);
                this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, (Integer)slotPos.getFirst() + 8, (Integer)slotPos.getSecond() + 18, 50, 15, value -> {
                    try {
                        double newPrice = Double.parseDouble(value);
                        this.setItemAtSlot(new AdminShopScreen.ShopItem(onCursorBefore.itemDescription(), newPrice, slot, onCursorBefore.customName(), onCursorBefore.stage()), slot, this.selectedCategory);
                        this.m_169411_((GuiEventListener)this.floatingEditBox);
                        this.floatingEditBox = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }));
                this.m_7522_((GuiEventListener)this.floatingEditBox);
            }
            this.itemOnCursor = this.setItemAtSlot(this.itemOnCursor, slot, this.selectedCategory);
        } else if (pButton == 1) {
            if (this.floatingEditBox != null) {
                this.m_169411_((GuiEventListener)this.floatingEditBox);
                this.floatingEditBox = null;
                return;
            }
            AdminShopScreen.ShopItem itemAtSlot = this.getItemAtSlot(slot, this.selectedCategory);
            if (itemAtSlot == null) {
                return;
            }
            Pair<Integer, Integer> slotPos = this.getSlotPos(slot);
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, (Integer)slotPos.getFirst() + 8, (Integer)slotPos.getSecond() + 16, 50, 15, value -> {
                    if (!value.isEmpty()) {
                        this.setItemAtSlot(new AdminShopScreen.ShopItem(itemAtSlot.itemDescription(), itemAtSlot.price(), slot, value, itemAtSlot.stage()), slot, this.selectedCategory);
                    } else {
                        this.setItemAtSlot(new AdminShopScreen.ShopItem(itemAtSlot.itemDescription(), itemAtSlot.price(), slot, null, itemAtSlot.stage()), slot, this.selectedCategory);
                    }
                    this.m_169411_((GuiEventListener)this.floatingEditBox);
                    this.floatingEditBox = null;
                }));
                if (itemAtSlot.customName() != null) {
                    this.floatingEditBox.m_94144_(itemAtSlot.customName());
                }
            } else if (GameStagesCheck.isInstalled() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341)) {
                this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, (Integer)slotPos.getFirst() + 8, (Integer)slotPos.getSecond() + 16, 50, 15, value -> {
                    if (!value.isEmpty()) {
                        this.setItemAtSlot(new AdminShopScreen.ShopItem(itemAtSlot.itemDescription(), itemAtSlot.price(), slot, itemAtSlot.customName(), value), slot, this.selectedCategory);
                    } else {
                        this.setItemAtSlot(new AdminShopScreen.ShopItem(itemAtSlot.itemDescription(), itemAtSlot.price(), slot, itemAtSlot.customName(), null), slot, this.selectedCategory);
                    }
                    this.m_169411_((GuiEventListener)this.floatingEditBox);
                    this.floatingEditBox = null;
                }));
                if (itemAtSlot.customName() != null) {
                    this.floatingEditBox.m_94144_(itemAtSlot.customName());
                }
            } else {
                this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, (Integer)slotPos.getFirst() + 8, (Integer)slotPos.getSecond() + 16, 50, 15, value -> {
                    try {
                        double newPrice = Double.parseDouble(value);
                        this.setItemAtSlot(new AdminShopScreen.ShopItem(itemAtSlot.itemDescription(), newPrice, slot, itemAtSlot.customName(), itemAtSlot.stage()), slot, this.selectedCategory);
                        this.m_169411_((GuiEventListener)this.floatingEditBox);
                        this.floatingEditBox = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }));
                this.floatingEditBox.m_94144_(String.format(Locale.US, "%.2f", itemAtSlot.price()));
            }
            this.m_7522_((GuiEventListener)this.floatingEditBox);
        } else if (pButton == 2) {
            AdminShopScreen.ShopItem itemAtSlot = this.getItemAtSlot(slot, this.selectedCategory);
            if (itemAtSlot == null) {
                return;
            }
            this.setItemAtSlot(null, slot, this.selectedCategory);
        }
    }

    @Override
    protected boolean isEditMode() {
        return true;
    }

    public CompoundTag toAdminShopUpdateCompound() {
        CompoundTag tag = new CompoundTag();
        ListTag itemsTag = new ListTag();
        ListTag categoriesTag = new ListTag();
        HashMap<ItemDescription, List> tagsForItems = new HashMap<ItemDescription, List>();
        this.shopItems.forEach((category, innerCategories) -> {
            String itemName = ItemHelper.getItemName(category.item);
            if (itemName == null) {
                return;
            }
            CompoundTag categoryTag = new CompoundTag();
            categoryTag.m_128359_("name", category.name);
            categoryTag.m_128359_("item", itemName);
            ListTag innerCategoriesTag = new ListTag();
            for (Map.Entry entry : innerCategories.entrySet()) {
                String innerItemName = ItemHelper.getItemName(((AdminShopScreen.InnerCategory)entry.getKey()).item);
                if (innerItemName == null) {
                    return;
                }
                CompoundTag innerCategoryTag = new CompoundTag();
                innerCategoryTag.m_128359_("name", ((AdminShopScreen.InnerCategory)entry.getKey()).name);
                innerCategoryTag.m_128359_("item", innerItemName);
                for (AdminShopScreen.ShopItem shopItem : (List)entry.getValue()) {
                    CompoundTag itemTag = shopItem.itemDescription().toNbt();
                    itemTag.m_128347_("adminShopBuyPrice", shopItem.price());
                    itemTag.m_128359_("category", category.name + ":" + ((AdminShopScreen.InnerCategory)entry.getKey()).name);
                    itemTag.m_128405_("slot", shopItem.slot());
                    if (shopItem.customName() != null) {
                        itemTag.m_128359_("customAdminShopName", shopItem.customName());
                    }
                    if (shopItem.stage() != null) {
                        itemTag.m_128359_("adminShopStage", shopItem.stage());
                    }
                    tagsForItems.computeIfAbsent(shopItem.itemDescription(), a -> new ArrayList()).add(itemTag);
                }
                innerCategoriesTag.add((Object)innerCategoryTag);
            }
            categoryTag.m_128365_("categories", (Tag)innerCategoriesTag);
            categoriesTag.add((Object)categoryTag);
        });
        this.sellPrices.forEach((itemDescription, info) -> {
            if (info.worth() > 0.0) {
                CompoundTag itemTag = itemDescription.toNbt();
                itemTag.m_128347_("adminShopSellPrice", info.worth());
                if (info.stage() != null) {
                    itemTag.m_128359_("adminShopSellStage", info.stage());
                }
                tagsForItems.computeIfAbsent((ItemDescription)itemDescription, a -> new ArrayList()).add(itemTag);
            }
        });
        tagsForItems.forEach((itemDescription, compoundTags) -> itemsTag.addAll((Collection)compoundTags));
        tag.m_128365_("items", (Tag)itemsTag);
        tag.m_128365_("categories", (Tag)categoriesTag);
        return tag;
    }

    private void sendChanges() {
        Packets.sendToServer(new UpdateAdminShopPacket(this.toAdminShopUpdateCompound()));
    }

    @Override
    public void renderStageTwo(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderStageTwo(guiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.itemOnCursor != null) {
            guiGraphics.m_280480_(this.itemOnCursor.itemDescription().createItemStack(), pMouseX - 8, pMouseY - 8);
        }
    }

    @Override
    protected void m_6597_(@Nullable Slot pSlot, int pSlotId, int pMouseButton, ClickType pType) {
        if (pMouseButton == 0) {
            if (this.itemOnCursor == null && pSlot != null) {
                ItemStack itemStack = pSlot.m_7993_();
                if (!itemStack.m_41619_()) {
                    this.itemOnCursor = new AdminShopScreen.ShopItem(ItemDescription.ofItem(itemStack), -1.0, -1, null, null);
                }
            } else if (pSlot == null) {
                this.itemOnCursor = null;
                if (this.floatingEditBox != null) {
                    this.m_169411_((GuiEventListener)this.floatingEditBox);
                    this.floatingEditBox = null;
                }
            }
        } else if (pMouseButton == 1 && pSlot != null) {
            ItemStack itemStack;
            if (this.floatingEditBox != null) {
                this.m_169411_((GuiEventListener)this.floatingEditBox);
                this.floatingEditBox = null;
            }
            if (!(itemStack = pSlot.m_7993_()).m_41619_()) {
                ItemDescription itemDescription = ItemDescription.ofItem(itemStack);
                if (GameStagesCheck.isInstalled() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                    this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, this.f_97735_ + pSlot.f_40220_ + 8, this.f_97736_ + pSlot.f_40221_ + 16, 50, 15, value -> {
                        if (this.sellPrices.containsKey(itemDescription)) {
                            this.sellPrices.put(itemDescription, new AdminShopScreen.ItemSellabilityInfo(((AdminShopScreen.ItemSellabilityInfo)this.sellPrices.get(itemDescription)).worth(), value));
                        } else {
                            this.sellPrices.put(itemDescription, new AdminShopScreen.ItemSellabilityInfo(-1.0, value));
                        }
                        this.m_169411_((GuiEventListener)this.floatingEditBox);
                        this.floatingEditBox = null;
                    }));
                    if (this.sellPrices.containsKey(itemDescription)) {
                        this.floatingEditBox.m_94144_(((AdminShopScreen.ItemSellabilityInfo)this.sellPrices.get(itemDescription)).stage());
                    }
                    this.m_7522_((GuiEventListener)this.floatingEditBox);
                } else {
                    this.floatingEditBox = (FloatingEditBoxWidget)this.m_142416_((GuiEventListener)new FloatingEditBoxWidget(this.f_96547_, this.f_97735_ + pSlot.f_40220_ + 8, this.f_97736_ + pSlot.f_40221_ + 16, 50, 15, value -> {
                        try {
                            double newPrice = Double.parseDouble(value);
                            if (this.sellPrices.containsKey(itemDescription)) {
                                this.sellPrices.put(itemDescription, new AdminShopScreen.ItemSellabilityInfo(newPrice, ((AdminShopScreen.ItemSellabilityInfo)this.sellPrices.get(itemDescription)).stage()));
                            } else {
                                this.sellPrices.put(itemDescription, new AdminShopScreen.ItemSellabilityInfo(newPrice, null));
                            }
                            this.m_169411_((GuiEventListener)this.floatingEditBox);
                            this.floatingEditBox = null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }));
                    if (this.sellPrices.containsKey(itemDescription)) {
                        this.floatingEditBox.m_94144_(String.format(Locale.US, "%.2f", ((AdminShopScreen.ItemSellabilityInfo)this.sellPrices.get(itemDescription)).worth()));
                    }
                    this.m_7522_((GuiEventListener)this.floatingEditBox);
                }
            }
        } else if (pMouseButton == 2 && pSlot != null) {
            ItemStack itemStack = pSlot.m_7993_();
            if (itemStack.m_41619_()) {
                return;
            }
            ItemDescription itemDescription = ItemDescription.ofItem(itemStack);
            if (GameStagesCheck.isInstalled() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                AdminShopScreen.ItemSellabilityInfo info = (AdminShopScreen.ItemSellabilityInfo)this.sellPrices.get(itemDescription);
                if (info != null && info.stage() != null) {
                    this.sellPrices.put(itemDescription, new AdminShopScreen.ItemSellabilityInfo(info.worth(), null));
                }
            } else {
                this.sellPrices.remove(itemDescription);
            }
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.m_7222_() instanceof FloatingEditBoxWidget) {
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        if (pKeyCode == 263) {
            AbstractWidget widget;
            GuiEventListener guiEventListener = this.m_7222_();
            if (guiEventListener instanceof AbstractWidget && this.f_169369_.contains(widget = (AbstractWidget)guiEventListener)) {
                return false;
            }
            int categoryIndex = ((LinkedHashMap)this.shopItems.get(this.selectedBigCategory)).keySet().stream().toList().indexOf(this.selectedCategory);
            if (categoryIndex == -1 || categoryIndex == 0) {
                return false;
            }
            List items = (List)((LinkedHashMap)this.shopItems.get(this.selectedBigCategory)).remove(this.selectedCategory);
            this.addAtIndex((LinkedHashMap)this.shopItems.get(this.selectedBigCategory), this.selectedCategory, items, categoryIndex - 1);
            return true;
        }
        if (pKeyCode == 262) {
            AbstractWidget widget;
            Object items = this.m_7222_();
            if (items instanceof AbstractWidget && this.f_169369_.contains(widget = (AbstractWidget)items)) {
                return false;
            }
            int categoryIndex = ((LinkedHashMap)this.shopItems.get(this.selectedBigCategory)).keySet().stream().toList().indexOf(this.selectedCategory);
            if (categoryIndex == -1 || categoryIndex == this.shopItems.size() - 1) {
                return false;
            }
            items = (List)((LinkedHashMap)this.shopItems.get(this.selectedBigCategory)).remove(this.selectedCategory);
            this.addAtIndex((LinkedHashMap)this.shopItems.get(this.selectedBigCategory), this.selectedCategory, items, categoryIndex + 1);
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public void m_7379_() {
        this.sendChanges();
        super.m_7379_();
    }
}

