/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.blockentity.CurrencyConverterBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.menu.CurrencyConverterMenu;
import me.khajiitos.jackseconomy.packet.ChangeCurrencyTypePacket;
import me.khajiitos.jackseconomy.screen.ShoppingCartScreen;
import me.khajiitos.jackseconomy.screen.widget.CurrencyToggleButton;
import me.khajiitos.jackseconomy.screen.widget.SideConfigWidget;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.CurrencyType;
import me.khajiitos.jackseconomy.util.SideConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CurrencyConverterScreen
extends AbstractContainerScreen<CurrencyConverterMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/currency_converter.png");
    private CurrencyType currencyType;
    private final CurrencyConverterBlockEntity blockEntity;
    private List<Component> tooltip;
    protected SideConfigWidget sideConfig;

    public CurrencyConverterScreen(CurrencyConverterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)Component.m_237119_());
        this.f_97727_ = 177;
        this.f_97731_ = this.f_97727_ - 96;
        this.currencyType = pMenu.blockEntity.selectedCurrencyType;
        this.blockEntity = pMenu.blockEntity;
    }

    @Nullable
    protected SideConfig getSideConfig() {
        CurrencyConverterBlockEntity blockEntity = this.getBlockEntity();
        return blockEntity != null ? blockEntity.getSideConfig() : new SideConfig();
    }

    private CurrencyConverterBlockEntity getBlockEntity() {
        return ((CurrencyConverterMenu)this.f_97732_).blockEntity;
    }

    public void refreshSideConfig() {
        if (this.sideConfig != null) {
            this.m_169411_((GuiEventListener)this.sideConfig);
        }
        int x = this.f_97735_ + this.f_97726_ + 8;
        int y = this.f_97736_;
        if (this.sideConfig == null) {
            this.sideConfig = new SideConfigWidget(x, y, new ResourceLocation("jackseconomy", "textures/block/currency_converter.png"), this.getAllowedDirections(), this::getSideConfig, tooltip -> {
                this.tooltip = tooltip;
            });
        } else {
            this.sideConfig.m_252865_(x);
            this.sideConfig.m_253211_(y);
        }
        this.m_142416_((GuiEventListener)this.sideConfig);
    }

    protected Set<Direction> getAllowedDirections() {
        return Set.of(Direction.DOWN, Direction.WEST, Direction.EAST, Direction.UP, Direction.SOUTH);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new CurrencyToggleButton(this.f_97735_ + 70, this.f_97736_ + 38, 18, 18, newCurrencyType -> {
            this.currencyType = newCurrencyType;
            Packets.sendToServer(new ChangeCurrencyTypePacket(newCurrencyType));
        }, a -> {
            this.tooltip = List.of(this.currencyType.item.m_41466_());
        }, this.currencyType));
        this.refreshSideConfig();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.tooltip = null;
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(BACKGROUND, this.f_97735_, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        BigDecimal currency = this.blockEntity == null ? BigDecimal.ZERO : this.blockEntity.getTotalBalance();
        BigDecimal capacity = BigDecimal.valueOf((Double)Config.maxCurrencyConverterBalance.get());
        double progress = currency.divide(capacity, RoundingMode.DOWN).min(BigDecimal.ONE).doubleValue();
        int startX = (this.f_96543_ - 51) / 2;
        int startY = this.f_96544_ / 2 - 81;
        guiGraphics.m_280398_(ShoppingCartScreen.BALANCE_PROGRESS, startX, startY, 0, 0.0f, 0.0f, 51, 5, 256, 256);
        guiGraphics.m_280398_(ShoppingCartScreen.BALANCE_PROGRESS, startX, startY, 0, 0.0f, 5.0f, (int)(51.0 * progress), 5, 256, 256);
        if (currency.compareTo(capacity) >= 0) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"jackseconomy.max_capacity_reached").m_130940_(ChatFormatting.RED), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ - 12, -1);
        }
        if (pMouseX >= startX && pMouseX <= startX + 51 && pMouseY >= startY && pMouseY <= startY + 5) {
            this.tooltip = List.of(Component.m_237110_((String)"jackseconomy.balance", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(currency)).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), Component.m_237110_((String)"jackseconomy.max_storage", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(capacity)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)((int)(progress * 100.0) + "%")).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW));
        }
        if (this.tooltip != null) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
        }
    }
}

