/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.gamestages.GameStagesCheck;
import me.khajiitos.jackseconomy.gamestages.GameStagesManager;
import me.khajiitos.jackseconomy.init.ItemBlockReg;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.menu.AdminShopMenu;
import me.khajiitos.jackseconomy.packet.AcknowledgeUnlocksPacket;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.screen.AdminShopExitPromptScreen;
import me.khajiitos.jackseconomy.screen.EditAdminShopScreen;
import me.khajiitos.jackseconomy.screen.ShoppingCartScreen;
import me.khajiitos.jackseconomy.screen.widget.BetterScrollPanel;
import me.khajiitos.jackseconomy.screen.widget.CategoryEntry;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.ItemHelper;
import me.khajiitos.jackseconomy.util.NewShopUnlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AdminShopScreen
extends AbstractContainerScreen<AdminShopMenu> {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/admin_shop.png");
    protected static final ResourceLocation NO_WALLET = new ResourceLocation("jackseconomy", "textures/gui/no_wallet.png");
    protected static final ResourceLocation BALANCE_PROGRESS = new ResourceLocation("jackseconomy", "textures/gui/balance_progress.png");
    protected static final ResourceLocation QUESTION_MARK = new ResourceLocation("jackseconomy", "textures/gui/question_mark.png");
    protected static final ResourceLocation STAR = new ResourceLocation("jackseconomy", "textures/gui/star.png");
    protected static final ResourceLocation LOCK = new ResourceLocation("jackseconomy", "textures/gui/lock.png");
    protected final LinkedHashMap<Category, LinkedHashMap<InnerCategory, List<ShopItem>>> shopItems = new LinkedHashMap<Category, LinkedHashMap<InnerCategory, List<ShopItem>>>(){

        @Override
        public LinkedHashMap<InnerCategory, List<ShopItem>> get(Object key) {
            return this.getOrDefault(key, new LinkedHashMap());
        }
    };
    protected final HashMap<ItemDescription, ItemSellabilityInfo> sellPrices = new HashMap();
    public LinkedHashMap<CategorizedShopItem, Integer> shoppingCart = new LinkedHashMap();
    public LinkedHashMap<ItemDescription, Integer> itemsToSell = new LinkedHashMap();
    protected InnerCategory selectedCategory = null;
    protected Category selectedBigCategory = null;
    protected int categoryOffset = 0;
    protected int page = 0;
    protected List<Component> tooltip;
    protected ImageButton categoryPreviousButton;
    protected ImageButton categoryNextButton;
    protected ImageButton pageNextButton;
    protected ImageButton pagePreviousButton;
    protected ImageButton shoppingCartButton;
    protected boolean shouldRenderBackground;
    protected BetterScrollPanel categoryPanel;
    protected final NewShopUnlocks newShopUnlocks;
    protected final NewShopUnlocks acknowledgedShopUnlocks;
    public final boolean oneItemCurrencyMode;
    private static int animationTick;

    public AdminShopScreen(AdminShopMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.oneItemCurrencyMode = pMenu.oneItemCurrencyMode;
        CompoundTag data = pMenu.data;
        ListTag categoriesTag = data.m_128437_("categories", 10);
        ListTag itemsTag = data.m_128437_("items", 10);
        this.newShopUnlocks = new NewShopUnlocks();
        this.acknowledgedShopUnlocks = new NewShopUnlocks();
        categoriesTag.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                String categoryName = compoundTag.m_128461_("name");
                Item item = ItemHelper.getItem(compoundTag.m_128461_("item"));
                if (item == null) {
                    return;
                }
                if (compoundTag.m_128425_("recentlyUnlocked", 1) && compoundTag.m_128471_("recentlyUnlocked")) {
                    this.newShopUnlocks.unlockedCategories.add(categoryName);
                }
                Category category = new Category(categoryName, item);
                LinkedHashMap innerCategories = new LinkedHashMap();
                this.shopItems.put(category, innerCategories);
                ListTag categoriesInnerTag = compoundTag.m_128437_("categories", 10);
                categoriesInnerTag.forEach(innerTag -> {
                    if (innerTag instanceof CompoundTag) {
                        CompoundTag innerCompoundTag = (CompoundTag)innerTag;
                        String innerCategoryName = innerCompoundTag.m_128461_("name");
                        Item innerItem = ItemHelper.getItem(innerCompoundTag.m_128461_("item"));
                        if (innerItem == null) {
                            return;
                        }
                        if (innerCompoundTag.m_128425_("recentlyUnlocked", 1) && innerCompoundTag.m_128471_("recentlyUnlocked")) {
                            this.newShopUnlocks.unlockedCategories.add(categoryName + ":" + innerCategoryName);
                        }
                        InnerCategory innerCategory = new InnerCategory(innerCategoryName, innerItem);
                        innerCategories.put(innerCategory, new ArrayList());
                    }
                });
            }
        });
        LinkedHashMap<String, List> slotlessShopItems = new LinkedHashMap<String, List>();
        itemsTag.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                String stage;
                CompoundTag compoundTag = (CompoundTag)tag;
                ItemDescription itemDescription = ItemDescription.fromNbt(compoundTag);
                if (itemDescription == null) {
                    return;
                }
                if (compoundTag.m_128441_("adminShopSellPrice")) {
                    double sellPrice = compoundTag.m_128459_("adminShopSellPrice");
                    String sellStage = compoundTag.m_128441_("adminShopSellStage") ? compoundTag.m_128461_("adminShopSellStage") : null;
                    this.sellPrices.put(itemDescription, new ItemSellabilityInfo(this.oneItemCurrencyMode ? (double)Math.round(sellPrice) : sellPrice, sellStage));
                    return;
                }
                String category = compoundTag.m_128461_("category");
                double buyPrice = compoundTag.m_128459_("adminShopBuyPrice");
                int slot = compoundTag.m_128441_("slot") ? compoundTag.m_128451_("slot") : -1;
                String customName = compoundTag.m_128441_("customAdminShopName") ? compoundTag.m_128461_("customAdminShopName") : null;
                String string = stage = compoundTag.m_128441_("adminShopStage") ? compoundTag.m_128461_("adminShopStage") : null;
                if (compoundTag.m_128425_("recentlyUnlocked", 1) && compoundTag.m_128471_("recentlyUnlocked")) {
                    this.newShopUnlocks.unlockedItems.add(new NewShopUnlocks.Item(slot, category));
                }
                if (slot < 0) {
                    slotlessShopItems.computeIfAbsent(category, categoryName -> new ArrayList()).add(new UnpreparedShopItem(itemDescription, this.oneItemCurrencyMode ? (double)Math.round(buyPrice) : buyPrice, customName, stage));
                } else {
                    String[] categoryNamesInner = category.split(":", 2);
                    if (categoryNamesInner.length < 2) {
                        return;
                    }
                    String bigCategoryName = categoryNamesInner[0];
                    String innerCategoryName = categoryNamesInner[1];
                    block0: for (Map.Entry<Category, LinkedHashMap<InnerCategory, List<ShopItem>>> categoryEntry : this.shopItems.entrySet()) {
                        if (!categoryEntry.getKey().name.equals(bigCategoryName)) continue;
                        for (Map.Entry<InnerCategory, List<ShopItem>> entry : this.shopItems.get(categoryEntry.getKey()).entrySet()) {
                            if (!entry.getKey().name.equals(innerCategoryName)) continue;
                            entry.getValue().add(new ShopItem(itemDescription, this.oneItemCurrencyMode ? (double)Math.round(buyPrice) : buyPrice, slot, customName, stage));
                            break block0;
                        }
                    }
                }
            }
        });
        slotlessShopItems.forEach((categoryName, list) -> {
            String[] categoriesNames = categoryName.split(":", 2);
            if (categoriesNames.length < 2) {
                return;
            }
            String bigCategoryName = categoriesNames[0];
            String innerCategoryName = categoriesNames[1];
            for (Map.Entry<Category, LinkedHashMap<InnerCategory, List<ShopItem>>> entry : this.shopItems.entrySet()) {
                if (!entry.getKey().name.equals(bigCategoryName)) continue;
                block1: for (UnpreparedShopItem item : list) {
                    for (Map.Entry<InnerCategory, List<ShopItem>> entry1 : entry.getValue().entrySet()) {
                        if (!entry1.getKey().name.equals(innerCategoryName)) continue;
                        this.shopItems.get(entry.getKey()).get(entry1.getKey()).add(new ShopItem(item.itemDescription, item.price, this.findFirstAvailableSlot(entry.getKey()), item.customName, item.stage));
                        continue block1;
                    }
                }
            }
        });
        this.selectedBigCategory = this.shopItems.entrySet().stream().filter(entry -> ((LinkedHashMap)entry.getValue()).values().stream().anyMatch(this::hasAnyItemUnlocked)).map(Map.Entry::getKey).findFirst().orElse(this.selectedBigCategory);
        if (this.selectedBigCategory != null) {
            this.selectedCategory = this.shopItems.get(this.selectedBigCategory).entrySet().stream().filter(entry -> this.hasAnyItemUnlocked((List)entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
        }
        this.f_97727_ = 232;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private void initButtons() {
        if (this.categoryPreviousButton != null) {
            this.m_169411_((GuiEventListener)this.categoryPreviousButton);
            this.categoryPreviousButton = null;
        }
        if (this.categoryNextButton != null) {
            this.m_169411_((GuiEventListener)this.categoryNextButton);
            this.categoryNextButton = null;
        }
        if (this.pagePreviousButton != null) {
            this.m_169411_((GuiEventListener)this.pagePreviousButton);
            this.pagePreviousButton = null;
        }
        if (this.pageNextButton != null) {
            this.m_169411_((GuiEventListener)this.pageNextButton);
            this.pageNextButton = null;
        }
        if (this.categoryOffset > 0) {
            this.categoryPreviousButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 6, this.f_97736_ + 30, 6, 10, 176, 58, 10, BACKGROUND, b -> {
                --this.categoryOffset;
                this.initButtons();
            }));
        }
        if (this.categoryOffset + (this.isEditMode() ? 7 : 8) < this.shopItems.size()) {
            this.categoryNextButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 164, this.f_97736_ + 30, 6, 10, 182, 58, 10, BACKGROUND, b -> {
                ++this.categoryOffset;
                this.initButtons();
            }));
        }
        if (this.page > 0) {
            this.pagePreviousButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 55, this.f_97736_ + 126, 6, 10, 176, 58, 10, BACKGROUND, b -> {
                --this.page;
                this.initButtons();
            }));
        }
        if (this.isEditMode() || this.page < this.getPages(this.selectedCategory) - 1) {
            this.pageNextButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 113, this.f_97736_ + 126, 6, 10, 182, 58, 10, BACKGROUND, b -> {
                ++this.page;
                this.initButtons();
            }));
        }
    }

    protected <A, B> void addAtIndex(LinkedHashMap<A, B> hashMap, A key, B value, int index) {
        if (index == hashMap.size()) {
            hashMap.put(key, value);
            return;
        }
        LinkedHashMap<A, B> copy = new LinkedHashMap<A, B>(hashMap);
        hashMap.clear();
        int i = 0;
        for (Map.Entry<A, B> entry : copy.entrySet()) {
            if (i == index) {
                hashMap.put(key, value);
            }
            hashMap.put(entry.getKey(), entry.getValue());
            ++i;
        }
    }

    public boolean reduceSellItemsIfMissing() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        Inventory inventory = player.m_150109_();
        HashMap<ItemDescription, Integer> itemsInInventory = new HashMap<ItemDescription, Integer>();
        for (ItemStack itemStack : inventory.f_35974_) {
            if (itemStack.m_41619_()) continue;
            ItemDescription itemDescription = ItemDescription.ofItem(itemStack);
            itemsInInventory.put(itemDescription, itemsInInventory.getOrDefault(itemDescription, 0) + itemStack.m_41613_());
        }
        boolean modified = false;
        for (ItemDescription itemDescription : this.itemsToSell.keySet()) {
            int inventoryAmount;
            int amount = this.itemsToSell.get(itemDescription);
            if (amount <= (inventoryAmount = itemsInInventory.getOrDefault(itemDescription, 0).intValue())) continue;
            modified = true;
            if (inventoryAmount > 0) {
                this.itemsToSell.put(itemDescription, inventoryAmount);
                continue;
            }
            this.itemsToSell.remove(itemDescription);
        }
        return modified;
    }

    protected int getPages(InnerCategory selectedCategory) {
        if (selectedCategory == null) {
            return 0;
        }
        List<ShopItem> itemsList = this.shopItems.get(this.selectedBigCategory).get(selectedCategory);
        int pages = 1;
        for (ShopItem shopItem : itemsList) {
            int onPage = 1 + shopItem.slot() / 27;
            if (pages >= onPage) continue;
            pages = onPage;
        }
        return pages;
    }

    public BigDecimal getShoppingCartValue() {
        BigDecimal value = BigDecimal.ZERO;
        for (Map.Entry<CategorizedShopItem, Integer> items : this.shoppingCart.entrySet()) {
            value = value.add(BigDecimal.valueOf(items.getKey().price()).multiply(new BigDecimal(items.getValue())));
        }
        return value;
    }

    @Nullable
    protected InnerCategory getCategoryById(int id) {
        List<InnerCategory> categories = this.getInnerCategories();
        if (id < 0 || id >= categories.size()) {
            return null;
        }
        return categories.get(id);
    }

    protected void selectBigCategory(Category bigCategory) {
        this.selectedBigCategory = bigCategory;
        this.selectedCategory = null;
        for (Map.Entry<InnerCategory, List<ShopItem>> categoryEntry : this.shopItems.get(bigCategory).entrySet()) {
            if (!this.hasAnyItemUnlocked(categoryEntry.getValue())) continue;
            this.selectedCategory = categoryEntry.getKey();
            break;
        }
        this.page = 0;
        this.initButtons();
    }

    protected void initCategoryPanel() {
        this.categoryPanel = (BetterScrollPanel)this.m_142416_((GuiEventListener)new BetterScrollPanel(Minecraft.m_91087_(), this.f_97735_ - 80, this.f_97736_ + 20, 75, this.f_97727_ - 40));
        for (Category category : this.shopItems.keySet()) {
            if (!this.isEditMode() && !this.shopItems.get(category).isEmpty() && this.getInnerCategories(category).isEmpty()) continue;
            this.categoryPanel.children.add(new CategoryEntry(0, 0, 75, 25, category, (entry, button) -> this.selectBigCategory(category), () -> this.selectedBigCategory == category, () -> this.newShopUnlocks.unlockedCategories.contains(category.getName())));
        }
    }

    public void acknowledgeCategoryUnlocksForEmpties() {
        for (Map.Entry<Category, LinkedHashMap<InnerCategory, List<ShopItem>>> entry : this.shopItems.entrySet()) {
            boolean anyNewlyUnlockedItemsInCategory = false;
            for (Map.Entry<InnerCategory, List<ShopItem>> innerEntry : entry.getValue().entrySet()) {
                boolean anyNewlyUnlockedItemsInInnerCategory = false;
                for (ShopItem shopItem : innerEntry.getValue()) {
                    NewShopUnlocks.Item item = new NewShopUnlocks.Item(shopItem.slot, entry.getKey().name + ":" + innerEntry.getKey().name);
                    if (!this.newShopUnlocks.unlockedItems.contains(item)) continue;
                    anyNewlyUnlockedItemsInInnerCategory = true;
                    anyNewlyUnlockedItemsInCategory = true;
                    break;
                }
                String innerCategoryName = entry.getKey().name + ":" + innerEntry.getKey().name;
                if (anyNewlyUnlockedItemsInInnerCategory || !this.newShopUnlocks.unlockedCategories.contains(innerCategoryName)) continue;
                this.newShopUnlocks.unlockedCategories.remove(innerCategoryName);
                this.acknowledgedShopUnlocks.unlockedCategories.add(innerCategoryName);
            }
            String categoryName = entry.getKey().name;
            if (anyNewlyUnlockedItemsInCategory || !this.newShopUnlocks.unlockedCategories.contains(categoryName)) continue;
            this.newShopUnlocks.unlockedCategories.remove(categoryName);
            this.acknowledgedShopUnlocks.unlockedCategories.add(categoryName);
        }
    }

    protected void m_6597_(Slot pSlot, int pSlotId, int pMouseButton, @NotNull ClickType pType) {
        if (!(((Boolean)Config.disableAdminShopSelling.get()).booleanValue() || pSlot == null || pType != ClickType.QUICK_MOVE && pType != ClickType.SWAP && pType != ClickType.PICKUP || pMouseButton != 0 && pMouseButton != 1)) {
            String stage;
            ItemDescription itemDescription = ItemDescription.ofItem(pSlot.m_7993_());
            ItemSellabilityInfo info = this.sellPrices.get(itemDescription);
            String string = stage = info != null ? info.stage : null;
            if (stage != null && !GameStagesManager.hasGameStage((Player)Minecraft.m_91087_().f_91074_, stage)) {
                return;
            }
            if (this.sellPrices.containsKey(itemDescription)) {
                int newAmount;
                int oldAmount = this.itemsToSell.getOrDefault(itemDescription, 0);
                int count = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) ? 64 : (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) ? 10 : 1);
                if (pMouseButton == 1) {
                    count *= -1;
                }
                if ((newAmount = Math.max(0, oldAmount + count)) > 0) {
                    this.itemsToSell.put(itemDescription, Math.max(0, oldAmount + count));
                } else {
                    this.itemsToSell.remove(itemDescription);
                }
                this.reduceSellItemsIfMissing();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)(pMouseButton == 1 ? 0.75f : 1.25f)));
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initButtons();
        this.initCategoryPanel();
        if (!this.isEditMode()) {
            this.shoppingCartButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 139, this.f_97736_ + 121, 30, 26, 176, 0, 26, BACKGROUND, 256, 256, b -> {
                assert (this.f_96541_ != null);
                this.f_96541_.f_91080_ = new ShoppingCartScreen((AdminShopMenu)this.f_97732_, ((AdminShopMenu)this.f_97732_).inventory, this);
                this.f_96541_.f_91080_.m_6575_(this.f_96541_, this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_());
            }, (Component)Component.m_237119_()));
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_7500_() && player.m_8088_() >= 4) {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"jackseconomy.edit"), b -> {
                    Minecraft.m_91087_().f_91080_ = new EditAdminShopScreen((AdminShopMenu)this.f_97732_, ((AdminShopMenu)this.f_97732_).inventory, this.f_96539_);
                    Minecraft.m_91087_().f_91080_.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
                }).m_252987_(3, 3, 75, 20).m_253136_());
            }
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        if (!this.shouldRenderBackground) {
            return;
        }
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(BACKGROUND, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void addItemToCart(CategorizedShopItem shopItem, int amount) {
        int countAlready = this.shoppingCart.getOrDefault(shopItem, 0);
        int newCount = Math.max(0, countAlready + amount);
        if (newCount == 0) {
            this.shoppingCart.remove(shopItem);
        } else {
            this.shoppingCart.put(shopItem, newCount);
        }
    }

    protected boolean isHoverObstructed(int mouseX, int mouseY) {
        return false;
    }

    public static void renderStar(GuiGraphics guiGraphics, int x, int y) {
        int animationPhase = animationTick / 3 % 3;
        guiGraphics.m_280398_(STAR, x, y, 160, 0.0f, (float)animationPhase * 16.0f, 16, 16, 16, 48);
    }

    public static void renderDollarSignForSellableItems(GuiGraphics guiGraphics, int xOffset, int yOffset, List<Slot> slots, HashMap<ItemDescription, Integer> itemsToSell, HashMap<ItemDescription, ItemSellabilityInfo> sellPrices) {
        for (Slot slot : slots) {
            ItemStack itemStack = slot.m_7993_();
            if (itemStack.m_41619_()) continue;
            ItemDescription itemDescription = ItemDescription.ofItem(itemStack);
            if (itemsToSell.getOrDefault(itemDescription, 0) > 0) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 256.0f);
                guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, "$", xOffset + slot.f_40220_ + 1, yOffset + slot.f_40221_ + 1, -16733696, false);
                guiGraphics.m_280168_().m_85849_();
                continue;
            }
            if (!sellPrices.containsKey(itemDescription)) continue;
            ItemSellabilityInfo info = sellPrices.get(itemDescription);
            if (!(info.worth > 0.0) || info.stage() != null && !GameStagesManager.hasGameStage((Player)Minecraft.m_91087_().f_91074_, info.stage())) continue;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 256.0f);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, "$", xOffset + slot.f_40220_ + 1, yOffset + slot.f_40221_ + 1, -5636096, false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        ++animationTick;
        this.reduceSellItemsIfMissing();
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.tooltip = null;
        this.shouldRenderBackground = true;
        this.m_7286_(guiGraphics, pPartialTick, pMouseX, pMouseY);
        if (!this.isEditMode()) {
            if (this.selectedCategory != null) {
                guiGraphics.m_280137_(this.f_96547_, this.selectedCategory.name, this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 6, -1);
            }
        } else if (this.selectedCategory != null) {
            guiGraphics.m_280137_(this.f_96547_, this.selectedCategory.name, this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 6, -1);
        } else {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"jackseconomy.add_category").m_130940_(ChatFormatting.RED), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 6, -1);
        }
        if (this.shoppingCartButton != null && this.shoppingCartButton.m_274382_()) {
            this.tooltip = List.of(Component.m_237110_((String)"jackseconomy.items", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.shoppingCart.size()))}).m_130940_(ChatFormatting.GRAY), Component.m_237110_((String)"jackseconomy.value", (Object[])new Object[]{Component.m_237113_((String)(this.oneItemCurrencyMode ? "$" + this.getShoppingCartValue().longValue() : CurrencyHelper.format(this.getShoppingCartValue())))}).m_130940_(ChatFormatting.GRAY));
        }
        List<InnerCategory> categories = this.getInnerCategories();
        for (int i = 0; i < 8; ++i) {
            boolean hovered;
            int categoryId = this.categoryOffset + i;
            int categoryX = this.f_97735_ + 17 + i * 18;
            int categoryY = this.f_97736_ + 27;
            boolean bl = hovered = pMouseX >= categoryX && pMouseX <= categoryX + 16 && pMouseY >= categoryY && pMouseY <= categoryY + 16;
            if (hovered && !this.isHoverObstructed(pMouseX, pMouseY)) {
                AdminShopScreen.m_280359_((GuiGraphics)guiGraphics, (int)categoryX, (int)categoryY, (int)0);
            }
            if (categoryId < 0 || categoryId >= categories.size()) continue;
            InnerCategory category = categories.get(categoryId);
            String innerCategoryName = this.selectedBigCategory.name + ":" + category.name;
            guiGraphics.m_280480_(new ItemStack((ItemLike)category.item), categoryX, categoryY);
            if (!this.isEditMode() && this.newShopUnlocks.unlockedCategories.contains(innerCategoryName)) {
                AdminShopScreen.renderStar(guiGraphics, categoryX + 4, categoryY + 4);
            }
            if (hovered) {
                this.tooltip = this.isEditMode() ? List.of(Component.m_237113_((String)category.name), Component.m_237115_((String)"jackseconomy.right_click_to_rename").m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)"jackseconomy.middle_click_to_remove_category").m_130940_(ChatFormatting.RED)) : List.of(Component.m_237113_((String)category.name));
            }
            if (this.selectedCategory != category) continue;
            guiGraphics.m_280218_(BACKGROUND, categoryX + 4, categoryY + 19, 176, 52, 10, 6);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotX = this.f_97735_ + 8 + col * 18;
                int slotY = this.f_97736_ + 66 + row * 18;
                ShopItem shopItem = this.getItemAtSlot(this.page * 27 + row * 9 + col, this.selectedCategory);
                if (shopItem != null) {
                    if (!this.isEditMode() && shopItem.isLocked()) {
                        guiGraphics.m_280163_(QUESTION_MARK, slotX, slotY, 0.0f, 0.0f, 16, 16, 16, 16);
                    } else {
                        ItemStack itemStack = shopItem.itemDescription.createItemStack();
                        guiGraphics.m_280480_(itemStack, slotX, slotY);
                        if (!this.isEditMode() && this.newShopUnlocks.unlockedItems.contains(new NewShopUnlocks.Item(shopItem.slot, this.selectedBigCategory.name + ":" + this.selectedCategory.name))) {
                            AdminShopScreen.renderStar(guiGraphics, slotX + 4, slotY + 4);
                        }
                    }
                    if (this.isEditMode() && shopItem.stage != null) {
                        guiGraphics.m_280398_(LOCK, slotX + 6, slotY + 5, 160, 0.0f, 0.0f, 12, 12, 12, 12);
                    }
                }
                if (pMouseX < slotX || pMouseX > slotX + 16 || pMouseY < slotY || pMouseY > slotY + 16 || this.isHoverObstructed(pMouseX, pMouseY)) continue;
                AdminShopScreen.m_280359_((GuiGraphics)guiGraphics, (int)slotX, (int)slotY, (int)0);
                if (shopItem == null) continue;
                NewShopUnlocks.Item unlockedItem = new NewShopUnlocks.Item(shopItem.slot, this.selectedBigCategory.name + ":" + this.selectedCategory.name);
                if (this.newShopUnlocks.unlockedItems.contains(unlockedItem)) {
                    this.newShopUnlocks.unlockedItems.remove(unlockedItem);
                    this.acknowledgedShopUnlocks.unlockedItems.add(unlockedItem);
                    this.acknowledgeCategoryUnlocksForEmpties();
                }
                ItemStack itemStack = shopItem.itemDescription().createItemStack();
                this.tooltip = new ArrayList<Component>();
                if (this.isEditMode() || !shopItem.isLocked() || ((Boolean)Config.showNamesForLockedAdminShopItems.get()).booleanValue()) {
                    this.tooltip.add((Component)(shopItem.customName != null ? Component.m_237113_((String)shopItem.customName) : shopItem.itemDescription.item().m_41466_().m_6881_().m_130938_(shopItem.itemDescription.item().m_41460_(itemStack).getStyleModifier())));
                    Level level = Minecraft.m_91087_().f_91074_ == null ? null : Minecraft.m_91087_().f_91074_.m_9236_();
                    itemStack.m_41720_().m_7373_(itemStack, level, this.tooltip, (TooltipFlag)TooltipFlag.Default.f_256752_);
                    this.tooltip.add((Component)Component.m_237113_((String)" "));
                }
                if (this.isEditMode()) {
                    this.tooltip.add((Component)(shopItem.price == -1.0 ? Component.m_237115_((String)"jackseconomy.no_price").m_130940_(ChatFormatting.GRAY) : Component.m_237113_((String)(this.oneItemCurrencyMode ? "$" + (long)shopItem.price : CurrencyHelper.format(shopItem.price))).m_130940_(ChatFormatting.GRAY)));
                    if (GameStagesCheck.isInstalled() && shopItem.stage() != null) {
                        this.tooltip.add((Component)Component.m_237110_((String)"jackseconomy.locked_behind_stage", (Object[])new Object[]{shopItem.stage()}).m_130940_(ChatFormatting.GRAY));
                    }
                    this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.right_click_to_edit_price").m_130940_(ChatFormatting.AQUA));
                    this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.shift_right_click_to_rename").m_130940_(ChatFormatting.AQUA));
                    if (GameStagesCheck.isInstalled()) {
                        this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.lctrl_right_click_to_change_stage").m_130940_(ChatFormatting.AQUA));
                    }
                    this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.middle_click_to_remove").m_130940_(ChatFormatting.RED));
                    continue;
                }
                if (shopItem.isLocked()) {
                    this.tooltip.add((Component)Component.m_237115_((String)"jackseconomy.locked").m_130940_(ChatFormatting.GRAY));
                    if (!((Boolean)Config.showStageForLockedAdminShopItems.get()).booleanValue()) continue;
                    this.tooltip.add((Component)Component.m_237110_((String)"jackseconomy.required_game_stage", (Object[])new Object[]{Component.m_237113_((String)shopItem.stage())}).m_130940_(ChatFormatting.GRAY));
                    continue;
                }
                this.tooltip.add((Component)Component.m_237113_((String)(this.oneItemCurrencyMode ? "$" + (long)shopItem.price : CurrencyHelper.format(shopItem.price))).m_130940_(ChatFormatting.GRAY));
                this.tooltip.add((Component)Component.m_237110_((String)"jackseconomy.in_cart", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.shoppingCart.getOrDefault(new CategorizedShopItem(shopItem, this.selectedBigCategory.name + ":" + this.selectedCategory.name), 0))).m_130940_(ChatFormatting.AQUA)}));
            }
        }
        if (!this.isEditMode()) {
            Item slotX;
            ItemStack wallet = CuriosWallet.get((Player)Minecraft.m_91087_().f_91074_);
            if (!((Boolean)Config.oneItemCurrencyMode.get()).booleanValue() && wallet != null && (slotX = wallet.m_41720_()) instanceof WalletItem) {
                WalletItem walletItem = (WalletItem)slotX;
                BigDecimal balance = WalletItem.getBalance(wallet);
                MutableComponent component = Component.m_237113_((String)CurrencyHelper.formatShortened(balance));
                int textWidth = this.f_96547_.m_92852_((FormattedText)component);
                int totalWidth = 29 + textWidth;
                guiGraphics.m_280509_(this.f_97735_ + 181, this.f_97736_ + 5, this.f_97735_ + 181 + totalWidth, this.f_97736_ + 35, -11776948);
                guiGraphics.m_280509_(this.f_97735_ + 182, this.f_97736_ + 6, this.f_97735_ + 182 + totalWidth, this.f_97736_ + 34, -3750202);
                guiGraphics.m_280480_(wallet, this.f_97735_ + 183, this.f_97736_ + 8);
                guiGraphics.m_280430_(this.f_96547_, (Component)component, this.f_97735_ + 203, this.f_97736_ + 13, -1);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BALANCE_PROGRESS);
                int barStartX = this.f_97735_ + 181 + (totalWidth - 51) / 2;
                int barStartY = this.f_97736_ + 26;
                double progress = balance.divide(BigDecimal.valueOf(walletItem.getCapacity()), RoundingMode.DOWN).min(BigDecimal.ONE).doubleValue();
                guiGraphics.m_280398_(BALANCE_PROGRESS, barStartX, barStartY, 0, 0.0f, 0.0f, 51, 5, 256, 256);
                guiGraphics.m_280398_(BALANCE_PROGRESS, barStartX, barStartY, 0, 0.0f, 5.0f, (int)(51.0 * progress), 5, 256, 256);
                if (pMouseX >= barStartX && pMouseX <= barStartX + 51 && pMouseY >= barStartY && pMouseY <= barStartY + 5) {
                    this.tooltip = List.of(Component.m_237110_((String)"jackseconomy.balance_out_of", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(balance)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)CurrencyHelper.format(walletItem.getCapacity()))}).m_130940_(ChatFormatting.GOLD));
                }
            } else if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue()) {
                long balance = OIMWalletItem.getTotalDollars(wallet, (Player)Minecraft.m_91087_().f_91074_);
                MutableComponent component = Component.m_237113_((String)("$" + balance));
                int textWidth = this.f_96547_.m_92852_((FormattedText)component);
                int totalWidth = 29 + textWidth;
                guiGraphics.m_280509_(this.f_97735_ + 181, this.f_97736_ + 5, this.f_97735_ + 181 + totalWidth, this.f_97736_ + 27, -11776948);
                guiGraphics.m_280509_(this.f_97735_ + 182, this.f_97736_ + 6, this.f_97735_ + 182 + totalWidth, this.f_97736_ + 26, -3750202);
                guiGraphics.m_280480_(wallet != null && !wallet.m_41619_() ? wallet : new ItemStack((ItemLike)ItemBlockReg.WALLET_ITEM.get()), this.f_97735_ + 183, this.f_97736_ + 8);
                guiGraphics.m_280430_(this.f_96547_, (Component)component, this.f_97735_ + 203, this.f_97736_ + 13, -1);
            } else {
                MutableComponent component = Component.m_237115_((String)"jackseconomy.no_wallet").m_130940_(ChatFormatting.DARK_RED);
                int width = this.f_96547_.m_92852_((FormattedText)component);
                guiGraphics.m_280509_(this.f_97735_ + 181, this.f_97736_ + 5, this.f_97735_ + 209 + width, this.f_97736_ + 25, -11776948);
                guiGraphics.m_280509_(this.f_97735_ + 182, this.f_97736_ + 6, this.f_97735_ + 208 + width, this.f_97736_ + 24, -3750202);
                guiGraphics.m_280398_(NO_WALLET, this.f_97735_ + 183, this.f_97736_ + 8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, this.f_97735_ + 203, this.f_97736_ + 13, -1, false);
            }
        }
        this.shouldRenderBackground = false;
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        AdminShopScreen.renderDollarSignForSellableItems(guiGraphics, this.f_97735_, this.f_97736_, (List<Slot>)((AdminShopMenu)this.f_97732_).f_38839_, this.itemsToSell, this.sellPrices);
        this.renderStageTwo(guiGraphics, pMouseX, pMouseY, pPartialTick);
        if (((AdminShopMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            double price;
            ItemStack itemstack = this.f_97734_.m_7993_();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(this.m_280553_(itemstack));
            ItemDescription itemDescription = ItemDescription.ofItem(itemstack);
            ItemSellabilityInfo info = this.sellPrices.get(itemDescription);
            String stage = info != null ? info.stage : null;
            double d = price = info != null ? info.worth : -1.0;
            if (!((Boolean)Config.disableAdminShopSelling.get()).booleanValue()) {
                if (this.isEditMode()) {
                    tooltip.add(Component.m_237113_((String)" "));
                    if (price != -1.0) {
                        tooltip.add(Component.m_237113_((String)(this.oneItemCurrencyMode ? "$" + (long)price : CurrencyHelper.format(price))).m_130940_(ChatFormatting.GRAY));
                    } else {
                        tooltip.add(Component.m_237115_((String)"jackseconomy.no_sell_price").m_130940_(ChatFormatting.GRAY));
                    }
                    if (stage != null && GameStagesCheck.isInstalled()) {
                        tooltip.add(Component.m_237110_((String)"jackseconomy.required_game_stage", (Object[])new Object[]{stage}).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.add(Component.m_237115_((String)"jackseconomy.right_click_to_edit_price").m_130940_(ChatFormatting.AQUA));
                    if (GameStagesCheck.isInstalled()) {
                        tooltip.add(Component.m_237115_((String)"jackseconomy.shift_right_click_to_edit_stage").m_130940_(ChatFormatting.AQUA));
                    }
                    if (price != -1.0) {
                        tooltip.add(Component.m_237115_((String)"jackseconomy.middle_click_to_remove_sell_price").m_130940_(ChatFormatting.RED));
                    }
                    if (stage != null && GameStagesCheck.isInstalled()) {
                        tooltip.add(Component.m_237115_((String)"jackseconomy.shift_middle_click_to_remove_stage").m_130940_(ChatFormatting.RED));
                    }
                } else {
                    tooltip.add(Component.m_237113_((String)" "));
                    if (stage != null && !GameStagesManager.hasGameStage((Player)Minecraft.m_91087_().f_91074_, stage)) {
                        if (((Boolean)Config.showStageForLockedSellItems.get()).booleanValue()) {
                            tooltip.add(Component.m_237110_((String)"jackseconomy.selling_locked_behind_gamestage", (Object[])new Object[]{stage}).m_130940_(ChatFormatting.GRAY));
                        } else {
                            tooltip.add(Component.m_237115_((String)"jackseconomy.selling_locked").m_130940_(ChatFormatting.GRAY));
                        }
                    } else if (price != -1.0) {
                        tooltip.add(Component.m_237113_((String)(this.oneItemCurrencyMode ? "$" + (long)price : CurrencyHelper.format(price))).m_130940_(ChatFormatting.GRAY));
                        tooltip.add(Component.m_237110_((String)"jackseconomy.to_sell", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.itemsToSell.getOrDefault(itemDescription, 0))).m_130940_(ChatFormatting.AQUA)}));
                    } else {
                        tooltip.add(Component.m_237115_((String)"jackseconomy.no_sell_price").m_130940_(ChatFormatting.GRAY));
                    }
                }
            }
            guiGraphics.renderTooltip(this.f_96547_, tooltip, itemstack.m_150921_(), itemstack, pMouseX, pMouseY);
        }
        if (this.tooltip != null) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    public boolean hasAnyItemUnlocked(List<ShopItem> shopItems) {
        boolean anyUnlocked = shopItems.isEmpty();
        for (ShopItem shopItem : shopItems) {
            if (shopItem.isLocked()) continue;
            anyUnlocked = true;
            break;
        }
        return anyUnlocked;
    }

    protected List<InnerCategory> getInnerCategories(Category category) {
        return this.shopItems.get(category).entrySet().stream().filter(entry -> this.hasAnyItemUnlocked((List)entry.getValue())).map(Map.Entry::getKey).toList();
    }

    protected List<InnerCategory> getInnerCategories() {
        return this.getInnerCategories(this.selectedBigCategory);
    }

    protected void renderStageTwo(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    protected boolean onCategorySlotClicked(int pButton, int categoryId) {
        if (pButton == 0) {
            List<InnerCategory> categories = this.getInnerCategories();
            if (categoryId >= 0 && categoryId < categories.size()) {
                this.selectedCategory = categories.get(categoryId);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.25f));
                return true;
            }
        }
        return false;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (int i = 0; i < 8; ++i) {
            int categoryId = this.categoryOffset + i;
            int categoryX = this.f_97735_ + 17 + i * 18;
            int categoryY = this.f_97736_ + 27;
            if (!(pMouseX >= (double)categoryX) || !(pMouseX <= (double)(categoryX + 16)) || !(pMouseY >= (double)categoryY) || !(pMouseY <= (double)(categoryY + 16)) || !this.onCategorySlotClicked(pButton, categoryId)) continue;
            return true;
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotX = this.f_97735_ + 8 + col * 18;
                int slotY = this.f_97736_ + 66 + row * 18;
                if (!(pMouseX >= (double)slotX) || !(pMouseX <= (double)(slotX + 16)) || !(pMouseY >= (double)slotY) || !(pMouseY <= (double)(slotY + 16))) continue;
                this.onSlotClicked(this.page * 27 + row * 9 + col, pButton);
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Nullable
    protected ShopItem getItemAtSlot(int slot, InnerCategory category) {
        for (ShopItem shopItem : this.shopItems.get(this.selectedBigCategory).getOrDefault(category, List.of())) {
            if (shopItem.slot != slot) continue;
            return shopItem;
        }
        return null;
    }

    protected ShopItem setItemAtSlot(ShopItem shopItem, int slot, InnerCategory category) {
        if (!this.shopItems.get(this.selectedBigCategory).containsKey(category)) {
            return shopItem;
        }
        ShopItem existingItem = this.getItemAtSlot(slot, category);
        if (existingItem != null) {
            this.shopItems.get(this.selectedBigCategory).get(category).remove(existingItem);
        }
        if (shopItem != null) {
            this.shopItems.get(this.selectedBigCategory).get(category).add(new ShopItem(shopItem.itemDescription, shopItem.price, slot, shopItem.customName, shopItem.stage));
        }
        return existingItem;
    }

    protected void onSlotClicked(int slot, int pButton) {
        if (pButton != 0 && pButton != 1) {
            return;
        }
        ShopItem shopItem = this.getItemAtSlot(slot, this.selectedCategory);
        if (shopItem == null) {
            return;
        }
        if (shopItem.isLocked()) {
            return;
        }
        int count = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) ? 64 : (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) ? 10 : 1);
        if (pButton == 1) {
            count *= -1;
        }
        this.addItemToCart(new CategorizedShopItem(shopItem, this.selectedBigCategory.name + ":" + this.selectedCategory.name), count);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)(pButton == 1 ? 0.75f : 1.25f)));
    }

    protected int findFirstAvailableSlot(InnerCategory category) {
        int slot = 0;
        ShopItem existingShopItem;
        while ((existingShopItem = this.getItemAtSlot(slot, category)) != null) {
            ++slot;
        }
        return slot;
    }

    protected Pair<Integer, Integer> getSlotPos(int slot) {
        int slotInPage = slot % 27;
        int row = slotInPage / 9;
        int col = slotInPage % 9;
        return Pair.of((Object)(this.f_97735_ + 8 + col * 18), (Object)(this.f_97736_ + 66 + row * 18));
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        if (!this.shoppingCart.isEmpty()) {
            this.f_96541_.f_91080_ = new AdminShopExitPromptScreen((Screen)this);
            this.f_96541_.f_91080_.m_6575_(this.f_96541_, this.f_96541_.m_91268_().m_85445_(), this.f_96541_.m_91268_().m_85446_());
        } else {
            super.m_7379_();
            this.sendShopUnlocksAcknowledgements();
        }
    }

    public void sendShopUnlocksAcknowledgements() {
        if (!this.acknowledgedShopUnlocks.isEmpty()) {
            Packets.sendToServer(new AcknowledgeUnlocksPacket(this.acknowledgedShopUnlocks));
            this.acknowledgedShopUnlocks.unlockedCategories.clear();
            this.acknowledgedShopUnlocks.unlockedItems.clear();
        }
    }

    protected boolean isEditMode() {
        return false;
    }

    public static class InnerCategory {
        protected String name;
        protected Item item;

        public InnerCategory(String name, Item item) {
            this.name = name;
            this.item = item;
        }

        public String getName() {
            return this.name;
        }

        public Item getItem() {
            return this.item;
        }
    }

    public static class Category
    extends InnerCategory {
        public Category(String name, Item item) {
            super(name, item);
        }
    }

    public static class ShopItem {
        private final ItemDescription itemDescription;
        private final double price;
        private final int slot;
        private final String customName;
        private final String stage;

        public ShopItem(@NotNull ItemDescription itemDescription, double price, int slot, @Nullable String customName, @Nullable String stage) {
            this.itemDescription = itemDescription;
            this.price = price;
            this.slot = slot;
            this.customName = customName;
            this.stage = stage;
        }

        public ItemDescription itemDescription() {
            return this.itemDescription;
        }

        public double price() {
            return this.price;
        }

        public int slot() {
            return this.slot;
        }

        public String customName() {
            return this.customName;
        }

        public String stage() {
            return this.stage;
        }

        public boolean isLocked() {
            return this.stage != null && !GameStagesManager.hasGameStage((Player)Minecraft.m_91087_().f_91074_, this.stage);
        }

        public int hashCode() {
            return Objects.hash(this.itemDescription, this.price, this.slot, this.customName, this.stage);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ShopItem that = (ShopItem)obj;
            return Double.compare(that.price, this.price) == 0 && this.slot == that.slot && Objects.equals(this.itemDescription, that.itemDescription) && Objects.equals(this.customName, that.customName) && Objects.equals(this.stage, that.stage);
        }
    }

    public static class CategorizedShopItem
    extends ShopItem {
        private final String category;

        public CategorizedShopItem(@NotNull ItemDescription itemDescription, double price, int slot, @Nullable String customName, @Nullable String stage, String category) {
            super(itemDescription, price, slot, customName, stage);
            this.category = category;
        }

        public CategorizedShopItem(ShopItem shopItem, String category) {
            super(shopItem.itemDescription(), shopItem.price(), shopItem.slot(), shopItem.customName(), shopItem.stage());
            this.category = category;
        }

        public String category() {
            return this.category;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.category);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            CategorizedShopItem that = (CategorizedShopItem)obj;
            return Objects.equals(this.category, that.category);
        }
    }

    public record ItemSellabilityInfo(double worth, String stage) {
    }

    private record UnpreparedShopItem(@NotNull ItemDescription itemDescription, double price, @Nullable String customName, @Nullable String stage) {
    }
}

