/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.blockentity.IImporterBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.ImporterTicketItem;
import me.khajiitos.jackseconomy.item.TicketItem;
import me.khajiitos.jackseconomy.menu.IBlockEntityContainer;
import me.khajiitos.jackseconomy.packet.ChangeSelectedItemPacket;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.screen.widget.BalanceProgressWidget;
import me.khajiitos.jackseconomy.screen.widget.RedstoneControlWidget;
import me.khajiitos.jackseconomy.screen.widget.SideConfigWidget;
import me.khajiitos.jackseconomy.screen.widget.TicketPreviewWidget;
import me.khajiitos.jackseconomy.util.SideConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractImporterScreen<S extends IImporterBlockEntity, T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/importer.png");
    private static final ResourceLocation REDSTONE_SELECTION = new ResourceLocation("jackseconomy", "textures/gui/redstone_selection.png");
    protected TicketPreviewWidget ticketPreview;
    protected List<Component> tooltip;
    protected ItemStack ticketItemLastTick;
    protected SideConfigWidget sideConfig;

    public AbstractImporterScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, (Component)Component.m_237119_());
        this.f_97727_ = 177;
        this.f_97731_ = this.f_97727_ - 96;
    }

    @Nullable
    private IImporterBlockEntity getBlockEntity() {
        IBlockEntityContainer blockEntityContainer;
        Object object = this.f_97732_;
        if (object instanceof IBlockEntityContainer && (object = (blockEntityContainer = (IBlockEntityContainer)object).getBlockEntity()) instanceof IImporterBlockEntity) {
            IImporterBlockEntity importerBlockEntity = (IImporterBlockEntity)object;
            return importerBlockEntity;
        }
        return null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshTicketPreview();
        this.refreshSideConfig();
        IImporterBlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity != null) {
            this.m_142416_((GuiEventListener)new BalanceProgressWidget(this.f_97735_ + 128, this.f_97736_ + 9, blockEntity::getTotalBalance, () -> BigDecimal.valueOf((Double)Config.maxImporterBalance.get()), tooltip -> {
                this.tooltip = tooltip;
            }));
            this.m_142416_((GuiEventListener)new RedstoneControlWidget(this.f_97735_ - 24, this.f_97736_ + 1, blockEntity, tooltip -> {
                this.tooltip = tooltip;
            }));
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(BACKGROUND, i, j, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280411_(BACKGROUND, this.f_97735_ + 39, this.f_97736_ + 26, 18, 13, 212.0f, 0.0f, 36, 26, 256, 256);
    }

    public void refreshTicketPreview() {
        List<ItemDescription> items;
        IImporterBlockEntity blockEntity;
        if (this.ticketPreview != null) {
            this.m_169411_((GuiEventListener)this.ticketPreview);
        }
        if ((blockEntity = this.getBlockEntity()) == null) {
            return;
        }
        ItemStack ticketItem = blockEntity.m_8020_(9);
        this.ticketPreview = ticketItem.m_41720_() instanceof ImporterTicketItem ? (!(items = TicketItem.getItems(ticketItem)).isEmpty() ? (TicketPreviewWidget)this.m_142416_((GuiEventListener)new TicketPreviewWidget(this.f_97735_ + 39, this.f_97736_ + 65, true, items, blockEntity.getSelectedItem(), newItemDescription -> {
            blockEntity.selectItem((ItemDescription)newItemDescription);
            Packets.sendToServer(new ChangeSelectedItemPacket((ItemDescription)newItemDescription));
            this.refreshTicketPreview();
        }, tooltip -> {
            this.tooltip = tooltip;
        })) : null) : null;
    }

    @Nullable
    protected SideConfig getSideConfig() {
        IImporterBlockEntity blockEntity = this.getBlockEntity();
        return blockEntity != null ? blockEntity.getSideConfig() : new SideConfig();
    }

    protected Set<Direction> getAllowedDirections() {
        return Set.of(Direction.DOWN, Direction.WEST, Direction.EAST, Direction.UP, Direction.SOUTH);
    }

    public void refreshSideConfig() {
        if (this.sideConfig != null) {
            this.m_169411_((GuiEventListener)this.sideConfig);
        }
        int x = this.f_97735_ + this.f_97726_ + 8;
        int y = this.f_97736_;
        if (this.sideConfig == null) {
            this.sideConfig = new SideConfigWidget(x, y, new ResourceLocation("jackseconomy", "textures/block/importer.png"), this.getAllowedDirections(), this::getSideConfig, tooltip -> {
                this.tooltip = tooltip;
            });
        } else {
            this.sideConfig.m_252865_(x);
            this.sideConfig.m_253211_(y);
        }
        this.m_142416_((GuiEventListener)this.sideConfig);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        BigDecimal currency;
        this.tooltip = null;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        IImporterBlockEntity blockEntity = this.getBlockEntity();
        BigDecimal bigDecimal = currency = blockEntity == null ? BigDecimal.ZERO : blockEntity.getBalance();
        if (blockEntity != null) {
            int pixels = (int)(blockEntity.getProgress() * 18.0f);
            guiGraphics.m_280411_(BACKGROUND, this.f_97735_ + 39, this.f_97736_ + 26, pixels, 13, 176.0f, 0.0f, pixels * 2, 26, 256, 256);
        }
        BigDecimal capacity = BigDecimal.valueOf((Double)Config.maxImporterBalance.get());
        if (!(((Slot)this.f_97732_.f_38839_.get(9)).m_7993_().m_41720_() instanceof ImporterTicketItem)) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"jackseconomy.manifest_required").m_130940_(ChatFormatting.YELLOW), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ - 12, -1);
        } else if (currency.compareTo(capacity) >= 0) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"jackseconomy.max_capacity_reached").m_130940_(ChatFormatting.RED), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ - 12, -1);
        }
        this.renderTooltipsOrSomething(guiGraphics, pMouseX, pMouseY);
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        if (this.tooltip != null) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean hoveredTicketPreview;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int startXRedstone = this.f_97735_ - 53;
        boolean bl = hoveredTicketPreview = this.ticketPreview != null && pMouseX >= (double)this.ticketPreview.m_252754_() && pMouseX <= (double)(this.ticketPreview.m_252754_() + this.ticketPreview.m_5711_()) && pMouseY >= (double)this.ticketPreview.m_252907_() && pMouseY <= (double)(this.ticketPreview.m_252907_() + this.ticketPreview.m_93694_());
        if (hoveredTicketPreview && this.ticketPreview.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_181908_() {
        ItemStack ticketItem;
        IImporterBlockEntity blockEntity;
        if (this.ticketPreview != null) {
            this.ticketPreview.tick();
        }
        if ((blockEntity = this.getBlockEntity()) != null && ((ticketItem = blockEntity.m_8020_(9)) == null && this.ticketItemLastTick != null || ticketItem != null && this.ticketItemLastTick == null || ticketItem != null && !ItemStack.m_150942_((ItemStack)ticketItem, (ItemStack)this.ticketItemLastTick))) {
            this.refreshTicketPreview();
            this.ticketItemLastTick = ticketItem;
        }
        super.m_181908_();
    }

    protected void renderTooltipsOrSomething(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected boolean m_6774_(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        if (this.ticketPreview != null && this.ticketPreview.isOpen() && pWidth == 16 && pHeight == 16 && pMouseX >= (double)this.ticketPreview.m_252754_() && pMouseX <= (double)(this.ticketPreview.m_252754_() + this.ticketPreview.m_5711_()) && pMouseY >= (double)this.ticketPreview.m_252907_() && pMouseY <= (double)(this.ticketPreview.m_252907_() + this.ticketPreview.m_93694_())) {
            return false;
        }
        return super.m_6774_(pX, pY, pWidth, pHeight, pMouseX, pMouseY);
    }
}

