/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.blockentity.IExporterBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.ExporterTicketItem;
import me.khajiitos.jackseconomy.item.GoldenExporterTicketItem;
import me.khajiitos.jackseconomy.item.TicketItem;
import me.khajiitos.jackseconomy.menu.IBlockEntityContainer;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.screen.widget.BalanceProgressWidget;
import me.khajiitos.jackseconomy.screen.widget.RedstoneControlWidget;
import me.khajiitos.jackseconomy.screen.widget.SideConfigWidget;
import me.khajiitos.jackseconomy.screen.widget.TicketPreviewWidget;
import me.khajiitos.jackseconomy.util.SideConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractExporterScreen<S extends IExporterBlockEntity, T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jackseconomy", "textures/gui/exporter.png");
    private static final ResourceLocation REDSTONE_SELECTION = new ResourceLocation("jackseconomy", "textures/gui/redstone_selection.png");
    protected List<Component> tooltip;
    protected ItemStack ticketItemLastTick;
    protected TicketPreviewWidget ticketPreview;
    protected SideConfigWidget sideConfig;

    public AbstractExporterScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, (Component)Component.m_237119_());
        this.f_97727_ = 177;
        this.f_97731_ = this.f_97727_ - 96;
    }

    @Nullable
    private IExporterBlockEntity getBlockEntity() {
        IBlockEntityContainer blockEntityContainer;
        Object object = this.f_97732_;
        if (object instanceof IBlockEntityContainer && (object = (blockEntityContainer = (IBlockEntityContainer)object).getBlockEntity()) instanceof IExporterBlockEntity) {
            IExporterBlockEntity exporterBlockEntity = (IExporterBlockEntity)object;
            return exporterBlockEntity;
        }
        return null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshTicketPreview();
        this.refreshSideConfig();
        IExporterBlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity != null) {
            this.m_142416_((GuiEventListener)new BalanceProgressWidget(this.f_97735_ + 128, this.f_97736_ + 9, blockEntity::getTotalBalance, () -> BigDecimal.valueOf((Double)Config.maxImporterBalance.get()), tooltip -> {
                this.tooltip = tooltip;
            }));
            this.m_142416_((GuiEventListener)new RedstoneControlWidget(this.f_97735_ - 24, this.f_97736_ + 1, blockEntity, tooltip -> {
                this.tooltip = tooltip;
            }));
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.f_97735_;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(BACKGROUND, i, j, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280411_(BACKGROUND, this.f_97735_ + 41, this.f_97736_ + 21, 14, 24, 204.0f, 0.0f, 28, 48, 256, 256);
    }

    public BigDecimal getCurrencyInOutputSlots() {
        BigDecimal currency = BigDecimal.ZERO;
        for (int i = 3; i < 6; ++i) {
            ItemStack itemStack = ((Slot)this.f_97732_.f_38839_.get(i)).m_7993_();
            Item item = itemStack.m_41720_();
            if (!(item instanceof CurrencyItem)) continue;
            CurrencyItem coin = (CurrencyItem)item;
            currency = currency.add(coin.value.multiply(new BigDecimal(itemStack.m_41613_())));
        }
        return currency;
    }

    public void refreshTicketPreview() {
        List<ItemDescription> items;
        IExporterBlockEntity blockEntity;
        if (this.ticketPreview != null) {
            this.m_169411_((GuiEventListener)this.ticketPreview);
        }
        if ((blockEntity = this.getBlockEntity()) == null) {
            return;
        }
        ItemStack ticketItem = blockEntity.m_8020_(9);
        this.ticketPreview = ticketItem.m_41720_() instanceof ExporterTicketItem && !(ticketItem.m_41720_() instanceof GoldenExporterTicketItem) ? (!(items = TicketItem.getItems(ticketItem)).isEmpty() ? (TicketPreviewWidget)this.m_142416_((GuiEventListener)new TicketPreviewWidget(this.f_97735_ + 39, this.f_97736_ + 65, false, items, null, null, tooltip -> {
            this.tooltip = tooltip;
        })) : null) : null;
    }

    protected Set<Direction> getAllowedDirections() {
        return Set.of(Direction.DOWN, Direction.WEST, Direction.EAST, Direction.UP, Direction.SOUTH);
    }

    @Nullable
    protected SideConfig getSideConfig() {
        IExporterBlockEntity blockEntity = this.getBlockEntity();
        return blockEntity != null ? blockEntity.getSideConfig() : new SideConfig();
    }

    public void refreshSideConfig() {
        if (this.sideConfig != null) {
            this.m_169411_((GuiEventListener)this.sideConfig);
        }
        int x = this.f_97735_ + this.f_97726_ + 8;
        int y = this.f_97736_;
        if (this.sideConfig == null) {
            this.sideConfig = new SideConfigWidget(x, y, new ResourceLocation("jackseconomy", "textures/block/exporter.png"), this.getAllowedDirections(), this::getSideConfig, tooltip -> {
                this.tooltip = tooltip;
            });
        } else {
            this.sideConfig.m_252865_(x);
            this.sideConfig.m_253211_(y);
        }
        this.m_142416_((GuiEventListener)this.sideConfig);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.tooltip = null;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        IExporterBlockEntity blockEntity = this.getBlockEntity();
        BigDecimal currency = (blockEntity == null ? BigDecimal.ZERO : blockEntity.getBalance()).add(this.getCurrencyInOutputSlots());
        if (blockEntity != null) {
            int pixels = (int)Math.ceil(blockEntity.getProgress() * 24.0f);
            guiGraphics.m_280411_(BACKGROUND, this.f_97735_ + 41, this.f_97736_ + 21 + (24 - pixels), 14, pixels, 176.0f, (float)(48 - pixels * 2), 28, pixels * 2, 256, 256);
        }
        BigDecimal capacity = BigDecimal.valueOf((Double)Config.maxExporterBalance.get());
        if (!(((Slot)this.f_97732_.f_38839_.get(9)).m_7993_().m_41720_() instanceof ExporterTicketItem)) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"jackseconomy.manifest_required").m_130940_(ChatFormatting.YELLOW), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ - 12, -1);
        } else if (currency.compareTo(capacity) >= 0) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"jackseconomy.max_capacity_reached").m_130940_(ChatFormatting.RED), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ - 12, -1);
        }
        this.renderTooltipsOrSomething(guiGraphics, pMouseX, pMouseY);
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
        if (this.tooltip != null) {
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.tooltip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    protected void renderTooltipsOrSomething(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_181908_() {
        ItemStack ticketItem;
        super.m_181908_();
        IExporterBlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity != null && ((ticketItem = blockEntity.m_8020_(9)) == null && this.ticketItemLastTick != null || ticketItem != null && this.ticketItemLastTick == null || ticketItem != null && !ItemStack.m_150942_((ItemStack)ticketItem, (ItemStack)this.ticketItemLastTick))) {
            this.refreshTicketPreview();
            this.ticketItemLastTick = ticketItem;
        }
        if (this.ticketPreview != null) {
            this.ticketPreview.tick();
        }
    }
}

