/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.price;

import com.google.gson.JsonObject;
import java.util.List;
import me.khajiitos.jackseconomy.price.ItemPriceInfo;
import org.jetbrains.annotations.Nullable;

public class PricesItemPriceInfo
extends ItemPriceInfo {
    public double sellPrice;
    public double adminShopSellPrice;
    public double importerBuyPrice;
    public String adminShopSellStage;

    public PricesItemPriceInfo(double sellPrice, double adminShopSellPrice, double importerBuyPrice, String adminShopSellStage) {
        this.sellPrice = sellPrice;
        this.adminShopSellPrice = adminShopSellPrice;
        this.importerBuyPrice = importerBuyPrice;
        this.adminShopSellStage = adminShopSellStage;
    }

    @Nullable
    protected static ItemPriceInfo fromJsonOrNull(JsonObject jsonObject) {
        try {
            if (PricesItemPriceInfo.hasAny(jsonObject, List.of("sellPrice", "adminShopSellPrice", "importerBuyPrice"))) {
                double sellPrice = jsonObject.has("sellPrice") ? jsonObject.get("sellPrice").getAsDouble() : -1.0;
                double adminShopSellPrice = jsonObject.has("adminShopSellPrice") ? jsonObject.get("adminShopSellPrice").getAsDouble() : -1.0;
                double importerBuyPrice = jsonObject.has("importerBuyPrice") ? jsonObject.get("importerBuyPrice").getAsDouble() : -1.0;
                String adminShopSellStage = jsonObject.has("adminShopSellStage") ? jsonObject.get("adminShopSellStage").getAsString() : null;
                return new PricesItemPriceInfo(sellPrice, adminShopSellPrice, importerBuyPrice, adminShopSellStage);
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "prices");
        if (this.adminShopSellPrice != -1.0) {
            jsonObject.addProperty("adminShopSellPrice", (Number)this.adminShopSellPrice);
        }
        if (this.sellPrice != -1.0) {
            jsonObject.addProperty("sellPrice", (Number)this.sellPrice);
        }
        if (this.importerBuyPrice != -1.0) {
            jsonObject.addProperty("importerBuyPrice", (Number)this.importerBuyPrice);
        }
        if (this.adminShopSellStage != null) {
            jsonObject.addProperty("adminShopSellStage", this.adminShopSellStage);
        }
        return jsonObject;
    }
}

