/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.price;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.khajiitos.jackseconomy.JacksEconomy;
import me.khajiitos.jackseconomy.gamestages.GameStagesManager;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.packet.PricesInfoPacket;
import me.khajiitos.jackseconomy.price.AdminShopItemPriceInfo;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.price.ItemPriceInfo;
import me.khajiitos.jackseconomy.price.PricesItemPriceInfo;
import me.khajiitos.jackseconomy.util.ItemHelper;
import me.khajiitos.jackseconomy.util.NewShopUnlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemPriceManager {
    private static final List<ItemPriceEntry> itemPriceInfos = new ArrayList<ItemPriceEntry>();
    private static final LinkedHashMap<Category, List<Category>> categories = new LinkedHashMap();
    private static final File file = new File("config/jackseconomy_prices.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Deprecated
    public static ItemPriceInfo getInfo(ItemDescription itemDescription) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> itemPriceEntry.itemDescription.equals(itemDescription)).findFirst().map(ItemPriceEntry::itemPriceInfo).orElse(null);
    }

    public static PricesItemPriceInfo getPricesInfo(ItemDescription itemDescription) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> itemPriceEntry.itemDescription.equals(itemDescription) && itemPriceEntry.itemPriceInfo instanceof PricesItemPriceInfo).map(entry -> (PricesItemPriceInfo)entry.itemPriceInfo).findFirst().orElse(null);
    }

    public static ItemPriceInfo getInfo(ItemStack itemStack) {
        return ItemPriceManager.getInfo(ItemDescription.ofItem(itemStack));
    }

    public static List<ItemPriceEntry> getItemPriceInfos() {
        return itemPriceInfos;
    }

    public static LinkedHashMap<Category, List<Category>> getCategories() {
        return categories;
    }

    public static double getExporterSellPrice(ItemDescription itemDescription, int count) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> itemPriceEntry.itemDescription.equals(itemDescription) && itemPriceEntry.itemPriceInfo instanceof PricesItemPriceInfo).map(entry -> ((PricesItemPriceInfo)entry.itemPriceInfo).sellPrice * (double)count).findFirst().orElse(-1.0);
    }

    public static double getImporterBuyPrice(ItemDescription itemDescription, int count) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> itemPriceEntry.itemDescription.equals(itemDescription) && itemPriceEntry.itemPriceInfo instanceof PricesItemPriceInfo).map(entry -> ((PricesItemPriceInfo)entry.itemPriceInfo).importerBuyPrice * (double)count).findFirst().orElse(-1.0);
    }

    public static double getAdminShopSellPrice(ItemDescription itemDescription, int count) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> itemPriceEntry.itemDescription.equals(itemDescription) && itemPriceEntry.itemPriceInfo instanceof PricesItemPriceInfo).map(entry -> ((PricesItemPriceInfo)entry.itemPriceInfo).adminShopSellPrice * (double)count).findFirst().orElse(-1.0);
    }

    public static String getAdminShopSellStage(ItemDescription itemDescription) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> itemPriceEntry.itemDescription.equals(itemDescription) && itemPriceEntry.itemPriceInfo instanceof PricesItemPriceInfo).map(entry -> ((PricesItemPriceInfo)entry.itemPriceInfo).adminShopSellStage).map(Optional::ofNullable).findFirst().orElse(Optional.empty()).orElse(null);
    }

    public static double getAdminShopBuyPrice(ItemDescription itemDescription, int count, int slot, String category) {
        return itemPriceInfos.stream().filter(itemPriceEntry -> {
            if (!itemPriceEntry.itemDescription.equals(itemDescription)) return false;
            ItemPriceInfo patt4717$temp = itemPriceEntry.itemPriceInfo;
            if (!(patt4717$temp instanceof AdminShopItemPriceInfo)) return false;
            AdminShopItemPriceInfo adminShopItemPriceInfo = (AdminShopItemPriceInfo)patt4717$temp;
            if (adminShopItemPriceInfo.adminShopSlot != slot) return false;
            if (!Objects.equals(adminShopItemPriceInfo.category, category)) return false;
            return true;
        }).map(entry -> ((AdminShopItemPriceInfo)entry.itemPriceInfo).adminShopBuyPrice * (double)count).findFirst().orElse(-1.0);
    }

    public static void load() {
        if (file.exists()) {
            itemPriceInfos.clear();
            categories.clear();
            try (FileReader fileReader = new FileReader(file);){
                JsonObject pricesObj = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
                JsonArray itemsArray = pricesObj.getAsJsonArray("items");
                JsonArray categoriesArray = pricesObj.getAsJsonArray("categories");
                if (itemsArray == null || categoriesArray == null) {
                    JacksEconomy.LOGGER.error("Invalid jackseconomy_prices.json file");
                    ItemPriceManager.save();
                    return;
                }
                categoriesArray.forEach(jsonElement -> {
                    JsonObject object = jsonElement.getAsJsonObject();
                    String categoryName = object.get("name").getAsString();
                    String itemName = object.get("item").getAsString();
                    if (itemName == null) {
                        return;
                    }
                    Item item = ItemHelper.getItem(itemName);
                    if (item == null) {
                        return;
                    }
                    JsonArray categoriesList = object.getAsJsonArray("categories");
                    if (categoriesList != null) {
                        Category category = new Category(categoryName, item);
                        ArrayList innerCategories = new ArrayList();
                        categories.put(category, innerCategories);
                        categoriesList.forEach(jsonElementInner -> {
                            if (jsonElementInner instanceof JsonObject) {
                                JsonObject categoryObject = (JsonObject)jsonElementInner;
                                String categoryNameInner = categoryObject.get("name").getAsString();
                                String itemNameInner = categoryObject.get("item").getAsString();
                                if (itemNameInner == null) {
                                    return;
                                }
                                Item itemInner = ItemHelper.getItem(itemNameInner);
                                if (itemInner == null) {
                                    return;
                                }
                                innerCategories.add(new Category(categoryNameInner, itemInner));
                            }
                        });
                    }
                });
                itemsArray.forEach(jsonElement -> {
                    JsonObject object = jsonElement.getAsJsonObject();
                    ItemDescription itemDescription = ItemDescription.fromJson(object);
                    if (itemDescription != null) {
                        ItemPriceInfo[] priceInfos;
                        for (ItemPriceInfo priceInfo : priceInfos = ItemPriceInfo.fromJson(object)) {
                            itemPriceInfos.add(new ItemPriceEntry(itemDescription, priceInfo));
                        }
                    } else {
                        JacksEconomy.LOGGER.warn("Invalid price info");
                    }
                });
            }
            catch (JsonSyntaxException | IOException | ClassCastException e) {
                JacksEconomy.LOGGER.error("Failed to load item prices", e);
            }
        } else if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
            ItemPriceManager.save();
        }
    }

    public static void save() {
        try (FileWriter fileWriter = new FileWriter(file);){
            JsonObject object = new JsonObject();
            JsonArray itemsArray = new JsonArray();
            JsonArray categoriesArray = new JsonArray();
            itemPriceInfos.forEach(entry -> itemsArray.add((JsonElement)ItemPriceManager.merge(entry.itemDescription.toJson(), entry.itemPriceInfo.toJson())));
            ItemPriceManager.categories.forEach((category, categories) -> {
                String itemName = ItemHelper.getItemName(category.icon);
                if (itemName != null) {
                    JsonObject categoryObj = new JsonObject();
                    categoryObj.addProperty("item", itemName);
                    categoryObj.addProperty("name", category.name);
                    JsonArray innerCategories = new JsonArray();
                    categories.forEach(categoryInner -> {
                        JsonObject categoryInnerObj = new JsonObject();
                        String itemNameInner = ItemHelper.getItemName(categoryInner.icon);
                        if (itemNameInner != null) {
                            categoryInnerObj.addProperty("item", itemNameInner);
                            categoryInnerObj.addProperty("name", categoryInner.name);
                            innerCategories.add((JsonElement)categoryInnerObj);
                        }
                    });
                    categoryObj.add("categories", (JsonElement)innerCategories);
                    categoriesArray.add((JsonElement)categoryObj);
                }
            });
            object.add("items", (JsonElement)itemsArray);
            object.add("categories", (JsonElement)categoriesArray);
            fileWriter.write(GSON.toJson((JsonElement)object));
        }
        catch (IOException e) {
            JacksEconomy.LOGGER.error("Failed to save item prices", (Throwable)e);
        }
    }

    public static ListTag toTag() {
        ListTag listTag = new ListTag();
        itemPriceInfos.forEach(entry -> {
            ItemPriceInfo patt10469$temp = entry.itemPriceInfo;
            if (patt10469$temp instanceof PricesItemPriceInfo) {
                PricesItemPriceInfo itemPriceInfo = (PricesItemPriceInfo)patt10469$temp;
                CompoundTag itemTag = entry.itemDescription.toNbt().m_6426_();
                itemTag.m_128347_("sellPrice", itemPriceInfo.sellPrice);
                itemTag.m_128347_("importerBuyPrice", itemPriceInfo.importerBuyPrice);
                itemTag.m_128347_("adminShopSellPrice", itemPriceInfo.adminShopSellPrice);
                if (itemPriceInfo.adminShopSellStage != null) {
                    itemTag.m_128359_("adminShopSellStage", itemPriceInfo.adminShopSellStage);
                }
                listTag.add((Object)itemTag);
            }
        });
        return listTag;
    }

    public static CompoundTag toAdminShopCompound(Player player) {
        CompoundTag tag = new CompoundTag();
        ListTag itemsTag = new ListTag();
        ListTag categoriesTag = new ListTag();
        NewShopUnlocks shopUnlocks = GameStagesManager.getNewShopUnlocks(player);
        itemPriceInfos.forEach(entry -> {
            ItemPriceInfo patt11482$temp = entry.itemPriceInfo;
            if (patt11482$temp instanceof AdminShopItemPriceInfo) {
                AdminShopItemPriceInfo itemPriceInfo = (AdminShopItemPriceInfo)patt11482$temp;
                if (itemPriceInfo.adminShopBuyPrice <= 0.0) {
                    return;
                }
                itemTag = entry.itemDescription.toNbt();
                itemTag.m_128347_("adminShopBuyPrice", itemPriceInfo.adminShopBuyPrice);
                itemTag.m_128359_("category", itemPriceInfo.category);
                itemTag.m_128405_("slot", itemPriceInfo.adminShopSlot);
                if (itemPriceInfo.customAdminShopName != null) {
                    itemTag.m_128359_("customAdminShopName", itemPriceInfo.customAdminShopName);
                }
                if (itemPriceInfo.adminShopStage != null) {
                    itemTag.m_128359_("adminShopStage", itemPriceInfo.adminShopStage);
                }
                if (shopUnlocks != null && shopUnlocks.unlockedItems.contains(new NewShopUnlocks.Item(itemPriceInfo.adminShopSlot, itemPriceInfo.category))) {
                    itemTag.m_128379_("recentlyUnlocked", true);
                }
                itemsTag.add((Object)itemTag);
            } else {
                ItemPriceInfo patt12612$temp = entry.itemPriceInfo;
                if (patt12612$temp instanceof PricesItemPriceInfo) {
                    PricesItemPriceInfo itemPriceInfo = (PricesItemPriceInfo)patt12612$temp;
                    if (itemPriceInfo.adminShopSellPrice <= 0.0) {
                        return;
                    }
                    itemTag = entry.itemDescription.toNbt();
                    itemTag.m_128347_("adminShopSellPrice", itemPriceInfo.adminShopSellPrice);
                    if (itemPriceInfo.adminShopSellStage != null) {
                        itemTag.m_128359_("adminShopSellStage", itemPriceInfo.adminShopSellStage);
                    }
                    itemsTag.add((Object)itemTag);
                }
            }
        });
        ItemPriceManager.categories.forEach((category, categories) -> {
            CompoundTag compoundTag = new CompoundTag();
            String itemName = ItemHelper.getItemName(category.icon);
            if (itemName == null) {
                return;
            }
            compoundTag.m_128359_("name", category.name);
            compoundTag.m_128359_("item", itemName);
            if (shopUnlocks != null && shopUnlocks.unlockedCategories.contains(category.name)) {
                compoundTag.m_128379_("recentlyUnlocked", true);
            }
            ListTag innerCategories = new ListTag();
            categories.forEach(categoryInner -> {
                CompoundTag compoundTagInner = new CompoundTag();
                String itemNameInner = ItemHelper.getItemName(categoryInner.icon);
                if (itemNameInner == null) {
                    return;
                }
                compoundTagInner.m_128359_("name", categoryInner.name);
                compoundTagInner.m_128359_("item", itemNameInner);
                if (shopUnlocks != null && shopUnlocks.unlockedCategories.contains(category.name + ":" + categoryInner.name)) {
                    compoundTagInner.m_128379_("recentlyUnlocked", true);
                }
                innerCategories.add((Object)compoundTagInner);
            });
            compoundTag.m_128365_("categories", (Tag)innerCategories);
            categoriesTag.add((Object)compoundTag);
        });
        tag.m_128365_("items", (Tag)itemsTag);
        tag.m_128365_("categories", (Tag)categoriesTag);
        return tag;
    }

    public static void addPriceInfo(ItemDescription itemDescription, ItemPriceInfo priceInfo) {
        itemPriceInfos.add(new ItemPriceEntry(itemDescription, priceInfo));
    }

    public static void addPriceInfo(ItemStack itemStack, ItemPriceInfo priceInfo) {
        ItemPriceManager.addPriceInfo(ItemDescription.ofItem(itemStack), priceInfo);
    }

    public static void sendDataToPlayers() {
        JacksEconomy.server.m_6846_().m_11314_().forEach(serverPlayer -> Packets.sendToClient(serverPlayer, new PricesInfoPacket(ItemPriceManager.toTag())));
    }

    private static JsonObject merge(JsonObject object1, JsonObject object2) {
        JsonObject object = new JsonObject();
        object1.keySet().forEach(name -> object.add(name, object1.get(name)));
        object2.keySet().forEach(name -> object.add(name, object2.get(name)));
        return object;
    }

    static {
        itemPriceInfos.add(new ItemPriceEntry(new ItemDescription(Items.f_42415_, null), new PricesItemPriceInfo(50.0, 45.0, 100.0, null)));
        itemPriceInfos.add(new ItemPriceEntry(new ItemDescription(Items.f_42415_, null), new AdminShopItemPriceInfo(150.0, "General:Gems", 0, null, null)));
        ArrayList<Category> categoriesInnerDefault = new ArrayList<Category>();
        categoriesInnerDefault.add(new Category("Gems", Items.f_42415_));
        categories.put(new Category("General", Items.f_42329_), categoriesInnerDefault);
    }

    public record ItemPriceEntry(ItemDescription itemDescription, ItemPriceInfo itemPriceInfo) {
    }

    public record Category(String name, Item icon) {
    }
}

