/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.price;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import me.khajiitos.jackseconomy.util.ItemHelper;
import me.khajiitos.jackseconomy.util.NBTUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ItemDescription(Item item, CompoundTag compoundTag) {
    public ItemDescription(Item item, @Nullable CompoundTag compoundTag) {
        this.item = item;
        if (compoundTag == null) {
            CompoundTag tag = new CompoundTag();
            if (item.m_41465_()) {
                tag.m_128405_("Damage", 0);
            }
            this.compoundTag = tag;
        } else {
            this.compoundTag = compoundTag.m_6426_();
        }
    }

    public static ItemDescription ofItem(ItemStack itemStack) {
        return new ItemDescription(itemStack.m_41720_(), itemStack.m_41783_());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDescription that = (ItemDescription)o;
        return Objects.equals(this.item, that.item) && Objects.equals(this.compoundTag, that.compoundTag);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        String itemName = ItemHelper.getItemName(this.item);
        tag.m_128359_("item", itemName != null ? itemName : "");
        if (!this.compoundTag.m_128456_()) {
            tag.m_128365_("nbt", (Tag)this.compoundTag.m_6426_());
        }
        return tag;
    }

    @Nullable
    public static ItemDescription fromNbt(CompoundTag compoundTag) {
        String itemName = compoundTag.m_128461_("item");
        if (itemName.isEmpty()) {
            return null;
        }
        Item item = ItemHelper.getItem(itemName);
        if (item == null) {
            return null;
        }
        CompoundTag tag = compoundTag.m_128469_("nbt");
        return new ItemDescription(item, tag);
    }

    public ItemStack createItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.item);
        CompoundTag tag = this.compoundTag();
        if (!tag.m_128456_()) {
            itemStack.m_41751_(tag.m_6426_());
        }
        return itemStack;
    }

    public JsonObject toJson() {
        JsonElement jsonElement = NBTUtil.nbtToJson((Tag)this.toNbt());
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return object;
        }
        return new JsonObject();
    }

    @Nullable
    public static ItemDescription fromJson(JsonObject json) {
        Tag tag = NBTUtil.jsonToNbt((JsonElement)json);
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return ItemDescription.fromNbt(compoundTag);
        }
        return null;
    }
}

