/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.packet.handler;

import java.math.BigDecimal;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.menu.WalletMenu;
import me.khajiitos.jackseconomy.packet.UpdateWalletBalancePacket;
import me.khajiitos.jackseconomy.packet.WalletBalanceDifPacket;
import me.khajiitos.jackseconomy.packet.WithdrawBalanceSpecificPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class WithdrawBalanceSpecificHandler {
    public static void handle(WithdrawBalanceSpecificPacket msg, Supplier<NetworkEvent.Context> ctx) {
        int stackAmount;
        ServerPlayer sender = ctx.get().getSender();
        if (sender == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = sender.f_36096_;
        if (!(abstractContainerMenu instanceof WalletMenu)) {
            return;
        }
        WalletMenu walletMenu = (WalletMenu)abstractContainerMenu;
        if (msg.items() < 1) {
            return;
        }
        BigDecimal amount = msg.currencyType().worth.multiply(new BigDecimal(msg.items()));
        ItemStack walletStack = walletMenu.getItemStack();
        if (WalletItem.getBalance(walletStack).compareTo(amount) < 0) {
            return;
        }
        for (int itemsLeft = msg.items(); itemsLeft > 0; itemsLeft -= stackAmount) {
            stackAmount = Math.min(64, itemsLeft);
            ItemStack itemStack = new ItemStack((ItemLike)msg.currencyType().item, stackAmount);
            if (sender.m_150109_().m_36054_(itemStack)) continue;
            ItemEntity itemEntity = new ItemEntity(sender.m_9236_(), sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), itemStack);
            sender.m_9236_().m_7967_((Entity)itemEntity);
        }
        WalletItem.setBalance(walletStack, WalletItem.getBalance(walletStack).subtract(amount));
        Packets.sendToClient(sender, new UpdateWalletBalancePacket(WalletItem.getBalance(walletStack)));
        Packets.sendToClient(sender, new WalletBalanceDifPacket(amount.negate()));
    }
}

