/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.packet.handler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.packet.UpdateAdminShopPacket;
import me.khajiitos.jackseconomy.price.AdminShopItemPriceInfo;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.price.ItemPriceInfo;
import me.khajiitos.jackseconomy.price.ItemPriceManager;
import me.khajiitos.jackseconomy.price.PricesItemPriceInfo;
import me.khajiitos.jackseconomy.util.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;

public class UpdateAdminShopHandler {
    public static void handle(UpdateAdminShopPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (sender == null) {
            return;
        }
        if (!sender.m_20310_(4) || !sender.m_7500_()) {
            return;
        }
        CompoundTag data = msg.data();
        ListTag categoriesTag = data.m_128437_("categories", 10);
        ListTag itemsTag = data.m_128437_("items", 10);
        List<AdminShopItemPriceInfo> itemPriceInfos = ItemPriceManager.getItemPriceInfos().stream().filter(itemPriceEntry -> itemPriceEntry.itemPriceInfo() instanceof AdminShopItemPriceInfo).map(itemPriceEntry -> (AdminShopItemPriceInfo)itemPriceEntry.itemPriceInfo()).toList();
        LinkedHashMap<ItemPriceManager.Category, List<ItemPriceManager.Category>> categories = ItemPriceManager.getCategories();
        categories.clear();
        ItemPriceManager.getItemPriceInfos().removeIf(itemPriceEntry -> itemPriceEntry.itemPriceInfo() instanceof AdminShopItemPriceInfo);
        categoriesTag.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                String name = compoundTag.m_128461_("name");
                Item item = ItemHelper.getItem(compoundTag.m_128461_("item"));
                ItemPriceManager.Category category = new ItemPriceManager.Category(name, item);
                ArrayList innerCategories = new ArrayList();
                ListTag innerCategoriesTag = compoundTag.m_128437_("categories", 10);
                innerCategoriesTag.forEach(tag1 -> {
                    if (tag1 instanceof CompoundTag) {
                        CompoundTag innerCategoryTag = (CompoundTag)tag1;
                        String innerName = innerCategoryTag.m_128461_("name");
                        Item innerItem = ItemHelper.getItem(innerCategoryTag.m_128461_("item"));
                        ItemPriceManager.Category innerCategory = new ItemPriceManager.Category(innerName, innerItem);
                        innerCategories.add(innerCategory);
                    }
                });
                categories.put(category, innerCategories);
            }
        });
        ItemPriceManager.getItemPriceInfos().forEach(itemPriceEntry -> {
            ItemPriceInfo patt3569$temp = itemPriceEntry.itemPriceInfo();
            if (patt3569$temp instanceof PricesItemPriceInfo) {
                PricesItemPriceInfo priceInfo = (PricesItemPriceInfo)patt3569$temp;
                priceInfo.adminShopSellPrice = -1.0;
                priceInfo.adminShopSellStage = null;
            }
        });
        itemsTag.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                String sellStage;
                CompoundTag compoundTag = (CompoundTag)tag;
                ItemDescription itemDescription = ItemDescription.fromNbt(compoundTag);
                if (itemDescription == null) {
                    return;
                }
                double sellPrice = compoundTag.m_128441_("adminShopSellPrice") ? compoundTag.m_128459_("adminShopSellPrice") : -1.0;
                String string = sellStage = compoundTag.m_128441_("adminShopSellStage") ? compoundTag.m_128461_("adminShopSellStage") : null;
                if (sellPrice > 0.0) {
                    PricesItemPriceInfo pricesItemPriceInfo = ItemPriceManager.getPricesInfo(itemDescription);
                    if (pricesItemPriceInfo != null) {
                        pricesItemPriceInfo.adminShopSellPrice = sellPrice;
                        pricesItemPriceInfo.adminShopSellStage = sellStage;
                    } else {
                        ItemPriceManager.addPriceInfo(itemDescription, (ItemPriceInfo)new PricesItemPriceInfo(-1.0, sellPrice, -1.0, sellStage));
                    }
                    return;
                }
                String category = compoundTag.m_128461_("category");
                double buyPrice = compoundTag.m_128459_("adminShopBuyPrice");
                int slot = compoundTag.m_128441_("slot") ? compoundTag.m_128451_("slot") : -1;
                String customName = compoundTag.m_128441_("customAdminShopName") ? compoundTag.m_128461_("customAdminShopName") : null;
                String stage = compoundTag.m_128441_("adminShopStage") ? compoundTag.m_128461_("adminShopStage") : null;
                ItemPriceManager.addPriceInfo(itemDescription, (ItemPriceInfo)new AdminShopItemPriceInfo(buyPrice, category, slot, customName, stage));
            }
        });
        ItemPriceManager.save();
        ItemPriceManager.sendDataToPlayers();
    }
}

