/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.packet.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.CheckItem;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.packet.InsertToWalletPacket;
import me.khajiitos.jackseconomy.packet.UpdateWalletBalancePacket;
import me.khajiitos.jackseconomy.packet.WalletBalanceDifPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class InsertToWalletHandler {
    public static void handle(InsertToWalletPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (sender == null) {
            return;
        }
        if (msg.slotId() >= 0 && msg.slotId() < sender.f_36096_.f_38839_.size()) {
            int toConsume;
            BigDecimal value;
            Item item;
            ItemStack walletItemStack = CuriosWallet.get((Player)sender);
            if (walletItemStack == null || !((item = walletItemStack.m_41720_()) instanceof WalletItem)) {
                return;
            }
            WalletItem walletItem = (WalletItem)item;
            ItemStack clickedItem = ((Slot)sender.f_36096_.f_38839_.get(msg.slotId())).m_7993_();
            Item item2 = clickedItem.m_41720_();
            if (item2 instanceof CurrencyItem) {
                CurrencyItem currencyItem = (CurrencyItem)item2;
                value = currencyItem.value;
            } else if (clickedItem.m_41720_() instanceof CheckItem) {
                value = CheckItem.getBalance(clickedItem);
            } else {
                return;
            }
            int count = clickedItem.m_41613_();
            BigDecimal oldBalance = WalletItem.getBalance(walletItemStack);
            BigDecimal freeBalance = BigDecimal.valueOf(walletItem.getCapacity()).subtract(oldBalance);
            BigDecimal fraction = freeBalance.divide(value, RoundingMode.UP).setScale(0, RoundingMode.UP);
            int n = toConsume = value.compareTo(BigDecimal.ZERO) == 0 ? count : Math.min(fraction.intValue(), count);
            if (toConsume <= 0) {
                return;
            }
            BigDecimal dif = value.multiply(BigDecimal.valueOf(toConsume));
            BigDecimal newBalance = oldBalance.add(dif);
            WalletItem.setBalance(walletItemStack, newBalance);
            Packets.sendToClient(sender, new UpdateWalletBalancePacket(newBalance));
            Packets.sendToClient(sender, new WalletBalanceDifPacket(dif));
            clickedItem.m_41764_(count - toConsume);
        }
    }
}

