/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.packet.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.CheckItem;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.packet.DepositAllPacket;
import me.khajiitos.jackseconomy.packet.UpdateWalletBalancePacket;
import me.khajiitos.jackseconomy.packet.WalletBalanceDifPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DepositAllHandler {
    public static void handle(DepositAllPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Item item;
        ServerPlayer sender = ctx.get().getSender();
        if (sender == null) {
            return;
        }
        ItemStack walletItemStack = CuriosWallet.get((Player)sender);
        if (walletItemStack == null || !((item = walletItemStack.m_41720_()) instanceof WalletItem)) {
            return;
        }
        WalletItem walletItem = (WalletItem)item;
        List<ItemStack> currencyItems = sender.m_150109_().f_35974_.stream().filter(itemStack -> itemStack.m_41720_() instanceof CurrencyItem).sorted(Comparator.comparingDouble(itemStack -> ((CurrencyItem)itemStack.m_41720_()).value.doubleValue())).toList();
        BigDecimal startingBalance = WalletItem.getBalance(walletItemStack);
        currencyItems.forEach(itemStack -> {
            BigDecimal value;
            Item patt1694$temp = itemStack.m_41720_();
            if (patt1694$temp instanceof CurrencyItem) {
                CurrencyItem currencyItem = (CurrencyItem)patt1694$temp;
                value = currencyItem.value;
            } else if (itemStack.m_41720_() instanceof CheckItem) {
                value = CheckItem.getBalance(itemStack);
            } else {
                return;
            }
            int count = itemStack.m_41613_();
            BigDecimal oldBalance = WalletItem.getBalance(walletItemStack);
            BigDecimal freeBalance = BigDecimal.valueOf(walletItem.getCapacity()).subtract(oldBalance);
            BigDecimal fraction = freeBalance.divide(value, RoundingMode.UP).setScale(0, RoundingMode.UP);
            int toConsume = (int)(value.compareTo(BigDecimal.ZERO) == 0 ? (long)count : Math.min(fraction.longValue(), (long)count));
            if (toConsume <= 0) {
                return;
            }
            BigDecimal dif = value.multiply(BigDecimal.valueOf(toConsume));
            BigDecimal newBalance = oldBalance.add(dif);
            WalletItem.setBalance(walletItemStack, newBalance);
            itemStack.m_41764_(count - toConsume);
        });
        BigDecimal newBalance = WalletItem.getBalance(walletItemStack);
        if (startingBalance.compareTo(newBalance) != 0) {
            Packets.sendToClient(sender, new UpdateWalletBalancePacket(newBalance));
            Packets.sendToClient(sender, new WalletBalanceDifPacket(newBalance.subtract(startingBalance)));
        }
    }
}

