/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.packet.handler;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.gamestages.GameStagesManager;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.packet.AdminShopPurchasePacket;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.price.ItemPriceManager;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.ItemHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;

public class AdminShopPurchaseHandler {
    /*
     * WARNING - void declaration
     */
    public static void handle(AdminShopPurchasePacket msg, Supplier<NetworkEvent.Context> ctx) {
        double d;
        ServerPlayer sender = ctx.get().getSender();
        if (sender == null) {
            return;
        }
        ItemStack wallet = CuriosWallet.get((Player)sender);
        BigDecimal value = BigDecimal.ZERO;
        for (Map.Entry<AdminShopPurchasePacket.ShopItemDescription, Integer> entry : msg.shoppingCart().entrySet()) {
            d = ItemPriceManager.getAdminShopBuyPrice(entry.getKey().itemDescription(), entry.getValue(), entry.getKey().slot(), entry.getKey().category());
            if (d <= 0.0) {
                return;
            }
            if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue()) {
                value = value.add(BigDecimal.valueOf(Math.round(d)));
                continue;
            }
            value = value.add(BigDecimal.valueOf(d));
        }
        if (!((Boolean)Config.disableAdminShopSelling.get()).booleanValue()) {
            for (Map.Entry<Record, Integer> entry : msg.itemsToSell().entrySet()) {
                d = ItemPriceManager.getAdminShopSellPrice((ItemDescription)entry.getKey(), entry.getValue());
                if (d <= 0.0) {
                    return;
                }
                String stage = ItemPriceManager.getAdminShopSellStage((ItemDescription)entry.getKey());
                if (stage != null && !GameStagesManager.hasGameStage((Player)sender, stage)) {
                    return;
                }
                if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue()) {
                    value = value.subtract(BigDecimal.valueOf(Math.round(d)));
                    continue;
                }
                value = value.subtract(BigDecimal.valueOf(d));
            }
        }
        if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue()) {
            long valueLong = value.longValue();
            long l = OIMWalletItem.getTotalDollars(wallet, (Player)sender);
            if (l < valueLong) {
                return;
            }
        } else {
            BigDecimal walletBalance = WalletItem.getBalance(wallet);
            if (walletBalance.compareTo(value) < 0) {
                return;
            }
            Item item = wallet.m_41720_();
            if (item instanceof WalletItem) {
                WalletItem walletItem = (WalletItem)item;
                if (value.compareTo(BigDecimal.ZERO) <= 0 && BigDecimal.valueOf(walletItem.getCapacity()).compareTo(value) < 0) {
                    return;
                }
            }
        }
        if (!((Boolean)Config.disableAdminShopSelling.get()).booleanValue()) {
            HashSet<ItemStack> consideredItemStacks = new HashSet<ItemStack>();
            for (Map.Entry<ItemDescription, Integer> entry : msg.itemsToSell().entrySet()) {
                int countLeft = entry.getValue();
                ItemDescription itemDescription = entry.getKey();
                for (ItemStack itemStack2 : sender.m_150109_().f_35974_) {
                    ItemDescription itemStackDescription;
                    if (consideredItemStacks.contains(itemStack2) || !itemDescription.equals(itemStackDescription = ItemDescription.ofItem(itemStack2))) continue;
                    countLeft -= Math.min(countLeft, itemStack2.m_41613_());
                    consideredItemStacks.add(itemStack2);
                    if (countLeft != 0) continue;
                    break;
                }
                if (countLeft <= 0) continue;
                return;
            }
        }
        if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue()) {
            long valueLong = value.longValue();
            if (valueLong < 0L) {
                List<ItemStack> list = CurrencyHelper.getCurrencyItems(BigDecimal.valueOf(-valueLong));
                Optional handlerOptional = wallet.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
                list.forEach(itemStack -> {
                    ItemStack left = itemStack;
                    if (handlerOptional.isPresent()) {
                        IItemHandler itemHandler = (IItemHandler)handlerOptional.get();
                        for (int i = 0; i < itemHandler.getSlots(); ++i) {
                            if (!(left = itemHandler.insertItem(i, left, false)).m_41619_()) continue;
                            return;
                        }
                    }
                    if (!sender.m_150109_().m_36054_(left)) {
                        ItemHelper.dropItem(left, sender.m_9236_(), sender.m_20183_());
                    }
                });
            } else {
                Optional handlerOptional;
                long l = valueLong;
                for (ItemStack itemStack3 : sender.m_150109_().f_35974_) {
                    CurrencyItem currencyItem;
                    Item itemStackDescription = itemStack3.m_41720_();
                    if (!(itemStackDescription instanceof CurrencyItem) || (currencyItem = (CurrencyItem)itemStackDescription).isDisabled()) continue;
                    int toTake = Math.min(itemStack3.m_41613_(), (int)Math.ceil((double)l / currencyItem.value.doubleValue()));
                    l = (long)((double)l - (double)toTake * currencyItem.value.doubleValue());
                    itemStack3.m_41774_(toTake);
                    if (l > 0L) continue;
                    break;
                }
                if (l > 0L && (handlerOptional = wallet.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve()).isPresent()) {
                    IItemHandler handler = (IItemHandler)handlerOptional.get();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        CurrencyItem currencyItem;
                        ItemStack itemStack4 = handler.getStackInSlot(i);
                        Item item = itemStack4.m_41720_();
                        if (!(item instanceof CurrencyItem) || (currencyItem = (CurrencyItem)item).isDisabled()) continue;
                        int toTake = Math.min(itemStack4.m_41613_(), (int)Math.ceil((double)l / currencyItem.value.doubleValue()));
                        l = (long)((double)l - (double)toTake * currencyItem.value.doubleValue());
                        handler.extractItem(i, toTake, false);
                        if (l > 0L) {
                            continue;
                        }
                        break;
                    }
                }
            }
        } else {
            Item item;
            BigDecimal walletBalance = WalletItem.getBalance(wallet);
            if (value.compareTo(BigDecimal.ZERO) < 0 && (item = wallet.m_41720_()) instanceof WalletItem) {
                WalletItem walletItem = (WalletItem)item;
                BigDecimal bigDecimal = value.negate();
                BigDecimal capacity = BigDecimal.valueOf(walletItem.getCapacity());
                if (walletBalance.compareTo(capacity) < 0) {
                    BigDecimal spaceInWallet = capacity.subtract(walletBalance);
                    if (bigDecimal.compareTo(spaceInWallet) <= 0) {
                        WalletItem.setBalance(wallet, walletBalance.add(bigDecimal));
                    } else {
                        WalletItem.setBalance(wallet, capacity);
                        BigDecimal remainingAmount = bigDecimal.subtract(spaceInWallet);
                        CurrencyHelper.getCurrencyItems(remainingAmount).forEach(itemStack -> {
                            if (!sender.m_36356_(itemStack)) {
                                ItemHelper.dropItem(itemStack, sender.m_9236_(), sender.m_20183_());
                            }
                        });
                    }
                } else {
                    CurrencyHelper.getCurrencyItems(bigDecimal).forEach(itemStack -> {
                        if (!sender.m_36356_(itemStack)) {
                            ItemHelper.dropItem(itemStack, sender.m_9236_(), sender.m_20183_());
                        }
                    });
                }
            } else {
                WalletItem.setBalance(wallet, walletBalance.subtract(value));
            }
        }
        for (Map.Entry<AdminShopPurchasePacket.ShopItemDescription, Integer> entry : msg.shoppingCart().entrySet()) {
            double d2 = ItemPriceManager.getAdminShopBuyPrice(entry.getKey().itemDescription(), entry.getValue(), entry.getKey().slot(), entry.getKey().category());
            if (d2 <= 0.0) {
                return;
            }
            ItemStack itemStack5 = entry.getKey().itemDescription().createItemStack();
            itemStack5.m_41764_(entry.getValue().intValue());
            if (sender.m_36356_(itemStack5)) continue;
            ItemHelper.dropItem(itemStack5, sender.m_9236_(), sender.m_20183_());
        }
        if (!((Boolean)Config.disableAdminShopSelling.get()).booleanValue()) {
            block7: for (Map.Entry<Record, Integer> entry : msg.itemsToSell().entrySet()) {
                int n = entry.getValue();
                ItemDescription itemDescription = (ItemDescription)entry.getKey();
                for (ItemStack itemStack2 : sender.m_150109_().f_35974_) {
                    void var7_34;
                    ItemDescription itemStackDescription = ItemDescription.ofItem(itemStack2);
                    if (!itemDescription.equals(itemStackDescription)) continue;
                    int taken = Math.min((int)var7_34, itemStack2.m_41613_());
                    itemStack2.m_41774_(taken);
                    if ((var7_34 -= taken) != false) continue;
                    continue block7;
                }
            }
        }
    }
}

