/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.packet;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.packet.handler.AdminShopPurchaseHandler;
import me.khajiitos.jackseconomy.price.ItemDescription;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record AdminShopPurchasePacket(Map<ShopItemDescription, Integer> shoppingCart, Map<ItemDescription, Integer> itemsToSell) {
    public static void encode(AdminShopPurchasePacket msg, FriendlyByteBuf friendlyByteBuf) {
        CompoundTag compoundTag = new CompoundTag();
        ListTag shoppingCartData = new ListTag();
        ListTag sellData = new ListTag();
        msg.shoppingCart().forEach((shopItem, amount) -> {
            CompoundTag itemTag = shopItem.itemDescription().toNbt();
            itemTag.m_128405_("amount", amount.intValue());
            itemTag.m_128405_("slot", shopItem.slot());
            itemTag.m_128359_("category", shopItem.category());
            shoppingCartData.add((Object)itemTag);
        });
        msg.itemsToSell().forEach((itemDescription, integer) -> {
            CompoundTag itemTag = itemDescription.toNbt();
            itemTag.m_128405_("amount", integer.intValue());
            sellData.add((Object)itemTag);
        });
        compoundTag.m_128365_("shoppingCart", (Tag)shoppingCartData);
        compoundTag.m_128365_("sellData", (Tag)sellData);
        friendlyByteBuf.m_130079_(compoundTag);
    }

    public static AdminShopPurchasePacket decode(FriendlyByteBuf friendlyByteBuf) {
        CompoundTag compoundTag = friendlyByteBuf.m_130260_();
        HashMap<ShopItemDescription, Integer> shoppingCartMap = new HashMap<ShopItemDescription, Integer>();
        HashMap<ItemDescription, Integer> itemsToSellMap = new HashMap<ItemDescription, Integer>();
        if (compoundTag != null) {
            ListTag shoppingCartData = compoundTag.m_128437_("shoppingCart", 10);
            ListTag itemsToSellData = compoundTag.m_128437_("sellData", 10);
            shoppingCartData.forEach(tag -> {
                CompoundTag itemTag;
                ItemDescription itemDescription;
                if (tag instanceof CompoundTag && (itemDescription = ItemDescription.fromNbt(itemTag = (CompoundTag)tag)) != null) {
                    int amount = itemTag.m_128451_("amount");
                    String category = itemTag.m_128461_("category");
                    int slot = itemTag.m_128451_("slot");
                    if (amount > 0) {
                        shoppingCartMap.put(new ShopItemDescription(itemDescription, slot, category), amount);
                    }
                }
            });
            itemsToSellData.forEach(tag -> {
                int amount;
                CompoundTag itemTag;
                ItemDescription itemDescription;
                if (tag instanceof CompoundTag && (itemDescription = ItemDescription.fromNbt(itemTag = (CompoundTag)tag)) != null && (amount = itemTag.m_128451_("amount")) > 0) {
                    itemsToSellMap.put(itemDescription, amount);
                }
            });
        }
        return new AdminShopPurchasePacket(shoppingCartMap, itemsToSellMap);
    }

    public static void handle(AdminShopPurchasePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> AdminShopPurchaseHandler.handle(msg, ctx));
        ctx.get().setPacketHandled(true);
    }

    public record ShopItemDescription(ItemDescription itemDescription, int slot, String category) {
    }
}

