/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.menu;

import java.math.BigDecimal;
import java.math.RoundingMode;
import me.khajiitos.jackseconomy.JacksEconomy;
import me.khajiitos.jackseconomy.init.ContainerReg;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.item.CheckItem;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.packet.UpdateWalletBalancePacket;
import me.khajiitos.jackseconomy.packet.WalletBalanceDifPacket;
import me.khajiitos.jackseconomy.util.IDisablable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WalletMenu
extends AbstractContainerMenu {
    public final Container container;
    private final ItemStack itemStack;

    public WalletMenu(int pContainerId, Inventory playerInv, ItemStack itemStack) {
        super((MenuType)ContainerReg.WALLET_MENU.get(), pContainerId);
        this.itemStack = itemStack;
        this.container = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            this.m_38897_(new Slot(this.container, i, 8 + col * 18, 33 + row * 18));
        }
        this.addPlayerInventory(playerInv, 116);
    }

    public ItemStack m_7648_(Player player, int index) {
        int containerSize = 9;
        ItemStack clickedStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack clickedStack = slot.m_7993_();
            clickedStackCopy = clickedStack.m_41777_();
            if (index < containerSize ? !this.m_38903_(clickedStack, containerSize, containerSize + 36, false) : !this.m_38903_(clickedStack, 0, containerSize, false)) {
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (clickedStack.m_41613_() == clickedStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, clickedStack);
        }
        return clickedStackCopy;
    }

    public void m_6877_(Player pPlayer) {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemInSlot = this.container.m_8020_(i);
            if (itemInSlot.m_41619_()) continue;
            pPlayer.m_36176_(itemInSlot, true);
        }
        super.m_6877_(pPlayer);
    }

    public void tick() {
        for (int i = 0; i < 9; ++i) {
            BigDecimal value;
            Item item;
            ItemStack input = this.container.m_8020_(i);
            if (input.m_41619_() || !((item = this.itemStack.m_41720_()) instanceof WalletItem)) continue;
            WalletItem walletItem = (WalletItem)item;
            Item item2 = input.m_41720_();
            if (item2 instanceof CurrencyItem) {
                CurrencyItem currencyItem = (CurrencyItem)item2;
                value = currencyItem.value;
            } else if (input.m_41720_() instanceof CheckItem) {
                value = CheckItem.getBalance(input);
            } else {
                return;
            }
            int count = input.m_41613_();
            BigDecimal oldBalance = WalletItem.getBalance(this.itemStack);
            BigDecimal freeBalance = BigDecimal.valueOf(walletItem.getCapacity()).subtract(oldBalance);
            BigDecimal fraction = freeBalance.divide(value, RoundingMode.UP).setScale(0, RoundingMode.UP);
            int toConsume = (int)(value.compareTo(BigDecimal.ZERO) == 0 ? (long)count : Math.min(fraction.longValue(), (long)count));
            if (toConsume <= 0) {
                return;
            }
            BigDecimal dif = value.multiply(BigDecimal.valueOf(toConsume));
            BigDecimal newBalance = oldBalance.add(dif);
            WalletItem.setBalance(this.itemStack, newBalance);
            JacksEconomy.server.m_6846_().m_11314_().forEach(serverPlayer -> {
                if (serverPlayer.f_36096_ == this) {
                    Packets.sendToClient(serverPlayer, new UpdateWalletBalancePacket(newBalance));
                    Packets.sendToClient(serverPlayer, new WalletBalanceDifPacket(dif));
                }
            });
            input.m_41764_(count - toConsume);
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean m_6875_(Player pPlayer) {
        IDisablable disablable;
        Item item = this.itemStack.m_41720_();
        if (item instanceof IDisablable && (disablable = (IDisablable)item).isDisabled()) {
            return false;
        }
        return !this.itemStack.m_41619_();
    }

    public void addPlayerInventory(Inventory playerInv, int yOffset) {
        for (int rowY = 0; rowY < 3; ++rowY) {
            for (int rowX = 0; rowX < 9; ++rowX) {
                this.m_38897_(new Slot((Container)playerInv, rowX + rowY * 9 + 9, 8 + rowX * 18, yOffset + rowY * 18));
            }
        }
        for (int rowX = 0; rowX < 9; ++rowX) {
            this.m_38897_(new Slot((Container)playerInv, rowX, 8 + rowX * 18, yOffset + 58));
        }
    }
}

