/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.menu;

import me.khajiitos.jackseconomy.blockentity.ExporterBlockEntity;
import me.khajiitos.jackseconomy.blockentity.TransactionMachineBlockEntity;
import me.khajiitos.jackseconomy.init.ContainerReg;
import me.khajiitos.jackseconomy.item.ExporterTicketItem;
import me.khajiitos.jackseconomy.menu.TransactionMachineMenu;
import me.khajiitos.jackseconomy.util.FilteredSlot;
import me.khajiitos.jackseconomy.util.OutputSlot;
import me.khajiitos.jackseconomy.util.RedstoneToggle;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class ExporterMenu
extends TransactionMachineMenu {
    public final float machineSpeed;
    public final int energy;
    public final RedstoneToggle redstoneToggle;

    public ExporterMenu(int containerID, Inventory playerInv, TransactionMachineBlockEntity blockEntity) {
        super((MenuType)ContainerReg.EXPORTER_MENU.get(), containerID, blockEntity);
        if (blockEntity instanceof ExporterBlockEntity) {
            ExporterBlockEntity exporterBlockEntity = (ExporterBlockEntity)blockEntity;
            this.machineSpeed = exporterBlockEntity.getSpeed();
            this.energy = exporterBlockEntity.getEnergyStored();
            this.redstoneToggle = exporterBlockEntity.getRedstoneToggle();
        } else {
            this.machineSpeed = 0.0f;
            this.energy = 0;
            this.redstoneToggle = RedstoneToggle.IGNORED;
        }
        for (int row = 0; row < 3; ++row) {
            this.m_38897_(new FilteredSlot(blockEntity, row, 8, 21 + row * 18, null, itemStack -> !(itemStack.m_41720_() instanceof ExporterTicketItem)));
        }
        for (int i = 0; i < 6; ++i) {
            this.m_38897_(new OutputSlot(blockEntity, 3 + i, 71 + i % 2 * 18, 21 + i / 2 * 18));
        }
        this.m_38897_(new FilteredSlot(blockEntity, 9, 40, 48, new ResourceLocation("jackseconomy", "gui/ticket_slot"), itemStack -> itemStack.m_41720_() instanceof ExporterTicketItem));
        this.addPlayerInventory(playerInv, 95);
    }

    public ExporterMenu(int containerID, Inventory playerInv, BlockPos pos) {
        this(containerID, playerInv, (TransactionMachineBlockEntity)playerInv.f_35978_.m_9236_().m_7702_(pos));
    }

    @Override
    public int getContainerSize() {
        return 10;
    }
}

