/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.listener;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import me.khajiitos.jackseconomy.JacksEconomyClient;
import me.khajiitos.jackseconomy.config.ClientConfig;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientRenderEventListeners {
    protected static final ResourceLocation BALANCE_PROGRESS = new ResourceLocation("jackseconomy", "textures/gui/balance_progress.png");

    @SubscribeEvent
    public void onDrawHud(RenderGuiEvent.Post e) {
        MutableComponent balanceText;
        ItemStack wallet = CuriosWallet.get((Player)Minecraft.m_91087_().f_91074_);
        if (wallet == null || wallet.m_41619_()) {
            return;
        }
        int yOffset = (Integer)ClientConfig.walletHudPositionYOffset.get();
        Item item = wallet.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item;
            BigDecimal balance = WalletItem.getBalance(wallet);
            balanceText = Component.m_237113_((String)CurrencyHelper.formatShortened(balance));
            int balanceTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)balanceText);
            int startX = (Boolean)ClientConfig.walletHudPositionRight.get() != false ? e.getGuiGraphics().m_280182_() - Math.max(balanceTextWidth - 21, 54) : 1;
            e.getGuiGraphics().m_280480_(wallet, startX, 1 + yOffset);
            BigDecimal capacity = BigDecimal.valueOf(walletItem.getCapacity());
            double progress = balance.divide(capacity, RoundingMode.DOWN).min(BigDecimal.ONE).doubleValue();
            e.getGuiGraphics().m_280430_(Minecraft.m_91087_().f_91062_, (Component)balanceText, startX + 18, 7 + yOffset, -1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BALANCE_PROGRESS);
            e.getGuiGraphics().m_280398_(BALANCE_PROGRESS, startX + 2, 19 + yOffset, 0, 0.0f, 0.0f, 51, 5, 256, 256);
            e.getGuiGraphics().m_280398_(BALANCE_PROGRESS, startX + 2, 19 + yOffset, 0, 0.0f, 5.0f, (int)(51.0 * progress), 5, 256, 256);
        } else if (wallet.m_41720_() instanceof OIMWalletItem) {
            long balance = OIMWalletItem.getDollars(wallet);
            balanceText = Component.m_237113_((String)("$" + balance));
            int balanceTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)balanceText);
            int startX = (Boolean)ClientConfig.walletHudPositionRight.get() != false ? e.getGuiGraphics().m_280182_() - balanceTextWidth - 21 : 1;
            e.getGuiGraphics().m_280480_(wallet, startX, 1 + yOffset);
            e.getGuiGraphics().m_280430_(Minecraft.m_91087_().f_91062_, (Component)balanceText, startX + 18, 7 + yOffset, -1);
        } else {
            return;
        }
        if (JacksEconomyClient.balanceDifPopup != null) {
            long maxTimeDelta;
            long timeDelta = System.currentTimeMillis() - JacksEconomyClient.balanceDifPopupStartMillis;
            if (timeDelta > (maxTimeDelta = (long)((Double)ClientConfig.balanceChangePopupTime.get() * 1000.0))) {
                JacksEconomyClient.balanceDifPopup = null;
                JacksEconomyClient.balanceDifPopupStartMillis = -1L;
                return;
            }
            int alpha = timeDelta < 500L ? (int)(255.0 * Mth.m_14139_((double)((double)timeDelta / 500.0), (double)0.0, (double)1.0)) : (timeDelta >= maxTimeDelta - 500L ? (int)(255.0 * Mth.m_14139_((double)((double)(maxTimeDelta - timeDelta) / 500.0), (double)0.0, (double)1.0)) : 255);
            int balanceTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)balanceText);
            String balanceDif = CurrencyHelper.formatShortened(JacksEconomyClient.balanceDifPopup);
            boolean positive = JacksEconomyClient.balanceDifPopup.compareTo(BigDecimal.ZERO) > 0;
            MutableComponent balanceDifComponent = Component.m_237113_((String)((positive ? "(+" : "(") + balanceDif + ")")).m_130940_(positive ? ChatFormatting.GREEN : ChatFormatting.RED);
            int balanceDifWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)balanceDifComponent);
            int startX = (Boolean)ClientConfig.walletHudPositionRight.get() != false ? e.getGuiGraphics().m_280182_() - balanceTextWidth - balanceDifWidth - 22 : 16 + balanceDifWidth;
            e.getGuiGraphics().m_280430_(Minecraft.m_91087_().f_91062_, (Component)balanceDifComponent, startX, 7 + yOffset, 0xFFFFFF | alpha << 24);
        }
    }
}

