/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.item;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Supplier;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.IDisablable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class WalletItem
extends Item
implements IDisablable {
    public Supplier<ForgeConfigSpec.ConfigValue<Double>> capacity;

    public WalletItem(Supplier<ForgeConfigSpec.ConfigValue<Double>> capacity) {
        super(new Item.Properties().m_41487_(1));
        this.capacity = capacity;
    }

    public double getCapacity() {
        return (Double)this.capacity.get().get();
    }

    public static BigDecimal getBalance(ItemStack itemStack) {
        try {
            return new BigDecimal(itemStack.m_41784_().m_128461_("Balance"));
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static void setBalance(ItemStack itemStack, double balance) {
        WalletItem.setBalance(itemStack, new BigDecimal(balance));
    }

    public static void setBalance(ItemStack itemStack, BigDecimal balance) {
        itemStack.m_41784_().m_128359_("Balance", balance.toString());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.isDisabled()) {
            pTooltipComponents.addAll(this.getDisabledTooltip());
        } else {
            BigDecimal balance = WalletItem.getBalance(pStack);
            pTooltipComponents.add((Component)Component.m_237110_((String)"jackseconomy.balance_out_of", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(balance)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)CurrencyHelper.format(this.getCapacity())).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD));
        }
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)Config.oneItemCurrencyMode.get();
    }
}

