/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.item;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.util.IDisablable;
import me.khajiitos.jackseconomy.util.OIMWalletCapabilityWrapper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class OIMWalletItem
extends Item
implements IDisablable {
    public OIMWalletItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static long getDollars(ItemStack itemStack) {
        Optional capOptional;
        LazyOptional cap = itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (cap.isPresent() && (capOptional = cap.resolve()).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capOptional.get();
            long total = 0L;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                CurrencyItem currencyItem;
                ItemStack item = itemHandler.getStackInSlot(i);
                Item item2 = item.m_41720_();
                if (!(item2 instanceof CurrencyItem) || (currencyItem = (CurrencyItem)item2).isDisabled()) continue;
                total += currencyItem.value.multiply(BigDecimal.valueOf(item.m_41613_())).longValue();
            }
            return total;
        }
        return 0L;
    }

    public static long getTotalDollars(@Nullable ItemStack itemStack, @Nullable Player player) {
        long total = 0L;
        if (itemStack != null) {
            total += OIMWalletItem.getDollars(itemStack);
        }
        if (player != null) {
            for (ItemStack item : player.m_150109_().f_35974_) {
                CurrencyItem currencyItem;
                Item item2 = item.m_41720_();
                if (!(item2 instanceof CurrencyItem) || (currencyItem = (CurrencyItem)item2).isDisabled()) continue;
                total += currencyItem.value.multiply(BigDecimal.valueOf(item.m_41613_())).longValue();
            }
        }
        return total;
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)Config.oneItemCurrencyMode.get() == false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.isDisabled()) {
            pTooltipComponents.addAll(this.getDisabledTooltip());
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return OIMWalletCapabilityWrapper.create(stack);
    }
}

