/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.init.ItemBlockReg;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.init.Sounds;
import me.khajiitos.jackseconomy.item.OIMWalletItem;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.packet.WalletBalanceDifPacket;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.IDisablable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CurrencyItem
extends Item
implements IDisablable {
    public final BigDecimal value;
    public final boolean bill;

    public CurrencyItem(BigDecimal value, boolean bill) {
        super(new Item.Properties());
        this.value = value;
        this.bill = bill;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (((Boolean)Config.oneItemCurrencyMode.get()).booleanValue() && this == ItemBlockReg.DOLLAR_BILL_ITEM.get()) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"jackseconomy.value", (Object[])new Object[]{Component.m_237113_((String)("$" + this.value.longValue())).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.m_237110_((String)"jackseconomy.value", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(this.value)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD));
        }
        if (this.isDisabled()) {
            pTooltipComponents.addAll(this.getDisabledTooltip());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (this.isDisabled()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        ItemStack wallet = CuriosWallet.get(pPlayer);
        if (wallet.m_41619_()) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        Item item = wallet.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item;
            left = BigDecimal.valueOf(walletItem.getCapacity()).subtract(WalletItem.getBalance(wallet));
            BigDecimal fraction = ((BigDecimal)left).divide(this.value, RoundingMode.UP).setScale(0, RoundingMode.UP);
            long insertCount = Math.min(fraction.longValue(), (long)itemStack.m_41613_());
            if (insertCount <= 0L) {
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
            if (!pPlayer.m_6047_()) {
                insertCount = 1L;
            }
            BigDecimal balanceAdded = this.value.multiply(new BigDecimal(insertCount));
            WalletItem.setBalance(wallet, WalletItem.getBalance(wallet).add(balanceAdded));
            itemStack.m_41774_((int)insertCount);
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                Packets.sendToClient(serverPlayer, new WalletBalanceDifPacket(balanceAdded));
            }
        } else {
            left = wallet.m_41720_();
            if (left instanceof OIMWalletItem) {
                Optional capOptional;
                OIMWalletItem walletItem = (OIMWalletItem)left;
                LazyOptional cap = wallet.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (cap.isPresent() && (capOptional = cap.resolve()).isPresent()) {
                    IItemHandler itemHandler = (IItemHandler)capOptional.get();
                    int insertCount = pPlayer.m_6047_() ? itemStack.m_41613_() : 1;
                    ItemStack stack = itemStack.m_255036_(insertCount);
                    for (int i = 0; i < itemHandler.getSlots() && !(stack = itemHandler.insertItem(i, stack, false)).m_41619_(); ++i) {
                    }
                    int used = insertCount - stack.m_41613_();
                    if (used == 0) {
                        return super.m_7203_(pLevel, pPlayer, pUsedHand);
                    }
                    itemStack.m_41774_(used);
                }
            } else {
                return super.m_7203_(pLevel, pPlayer, pUsedHand);
            }
        }
        if (this.bill) {
            pPlayer.m_9236_().m_5594_(null, pPlayer.m_20183_(), (SoundEvent)Sounds.CASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            pPlayer.m_9236_().m_5594_(null, pPlayer.m_20183_(), (SoundEvent)Sounds.COIN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    @Override
    public boolean isDisabled() {
        return this != ItemBlockReg.DOLLAR_BILL_ITEM.get() && (Boolean)Config.oneItemCurrencyMode.get() != false;
    }
}

