/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.item;

import java.math.BigDecimal;
import java.util.List;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.curios.CuriosWallet;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.init.Sounds;
import me.khajiitos.jackseconomy.item.WalletItem;
import me.khajiitos.jackseconomy.packet.WalletBalanceDifPacket;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.IDisablable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CheckItem
extends Item
implements IDisablable {
    public CheckItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static BigDecimal getBalance(ItemStack itemStack) {
        try {
            return new BigDecimal(itemStack.m_41784_().m_128461_("Balance"));
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static void setBalance(ItemStack itemStack, double balance) {
        CheckItem.setBalance(itemStack, new BigDecimal(balance));
    }

    public static void setBalance(ItemStack itemStack, BigDecimal bigDecimal) {
        itemStack.m_41784_().m_128359_("Balance", bigDecimal.toString());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        BigDecimal balance = CheckItem.getBalance(pStack);
        if (balance != null) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"jackseconomy.value", (Object[])new Object[]{Component.m_237113_((String)CurrencyHelper.format(balance)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD));
        }
        if (this.isDisabled()) {
            pTooltipComponents.addAll(this.getDisabledTooltip());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        Item item;
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        ItemStack wallet = CuriosWallet.get(pPlayer);
        if (wallet.m_41619_() || !((item = wallet.m_41720_()) instanceof WalletItem)) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        WalletItem walletItem = (WalletItem)item;
        BigDecimal left = BigDecimal.valueOf(walletItem.getCapacity()).subtract(WalletItem.getBalance(wallet));
        BigDecimal checkValue = CheckItem.getBalance(itemStack);
        if (left.compareTo(BigDecimal.ZERO) <= 0) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        WalletItem.setBalance(wallet, WalletItem.getBalance(wallet).add(checkValue));
        itemStack.m_41774_(1);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            Packets.sendToClient(serverPlayer, new WalletBalanceDifPacket(checkValue));
        }
        pPlayer.m_9236_().m_5594_(null, pPlayer.m_20183_(), (SoundEvent)Sounds.CASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)Config.oneItemCurrencyMode.get();
    }
}

