/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.price.ItemPriceInfo;
import me.khajiitos.jackseconomy.price.ItemPriceManager;
import me.khajiitos.jackseconomy.price.PricesItemPriceInfo;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class PriceCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"price").requires(stack -> stack.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"exporter").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"price", (ArgumentType)DoubleArgumentType.doubleArg((double)-1.0)).executes(PriceCommands::setExporterPrice)).then(Commands.m_82127_((String)"strip_nbt").executes(PriceCommands::setExporterPriceStripNbt))))).then(Commands.m_82127_((String)"importer").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"price", (ArgumentType)DoubleArgumentType.doubleArg((double)-1.0)).executes(PriceCommands::setImporterPrice)).then(Commands.m_82127_((String)"strip_nbt").executes(PriceCommands::setImporterPriceStripNbt))))));
    }

    private static int setImporterPrice(CommandContext<CommandSourceStack> ctx) {
        return PriceCommands.setImporterPrice(ctx, false);
    }

    private static int setExporterPrice(CommandContext<CommandSourceStack> ctx) {
        return PriceCommands.setExporterPrice(ctx, false);
    }

    private static int setImporterPriceStripNbt(CommandContext<CommandSourceStack> ctx) {
        return PriceCommands.setImporterPrice(ctx, true);
    }

    private static int setExporterPriceStripNbt(CommandContext<CommandSourceStack> ctx) {
        return PriceCommands.setExporterPrice(ctx, true);
    }

    private static int setImporterPrice(CommandContext<CommandSourceStack> ctx, boolean stripNbt) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (player == null) {
            return 1;
        }
        double priceArg = DoubleArgumentType.getDouble(ctx, (String)"price");
        double price = priceArg <= 0.0 ? -1.0 : priceArg;
        ItemStack itemInHand = player.m_21205_();
        if (itemInHand.m_41619_()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"jackseconomy.hold_an_item").m_130940_(ChatFormatting.RED));
            return 1;
        }
        PricesItemPriceInfo existingInfo = ItemPriceManager.getPricesInfo(new ItemDescription(itemInHand.m_41720_(), stripNbt ? null : itemInHand.m_41783_()));
        if (existingInfo != null) {
            existingInfo.importerBuyPrice = price;
        } else {
            ItemPriceManager.addPriceInfo(itemInHand, (ItemPriceInfo)new PricesItemPriceInfo(-1.0, -1.0, price, null));
        }
        if (price > 0.0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"jackseconomy.importer_price_set", (Object[])new Object[]{itemInHand.m_41720_().m_41466_().m_6881_().m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)CurrencyHelper.format(price)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"jackseconomy.importer_price_removed", (Object[])new Object[]{itemInHand.m_41720_().m_41466_().m_6881_().m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD), true);
        }
        ItemPriceManager.save();
        ItemPriceManager.sendDataToPlayers();
        return 0;
    }

    private static int setExporterPrice(CommandContext<CommandSourceStack> ctx, boolean stripNbt) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        if (player == null) {
            return 1;
        }
        double priceArg = DoubleArgumentType.getDouble(ctx, (String)"price");
        double price = priceArg <= 0.0 ? -1.0 : priceArg;
        ItemStack itemInHand = player.m_21205_();
        if (itemInHand.m_41619_()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"jackseconomy.hold_an_item").m_130940_(ChatFormatting.RED));
            return 1;
        }
        PricesItemPriceInfo existingInfo = ItemPriceManager.getPricesInfo(new ItemDescription(itemInHand.m_41720_(), stripNbt ? null : itemInHand.m_41783_()));
        if (existingInfo != null) {
            existingInfo.sellPrice = price;
        } else {
            ItemPriceManager.addPriceInfo(itemInHand, (ItemPriceInfo)new PricesItemPriceInfo(price, -1.0, -1.0, null));
        }
        if (price > 0.0) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"jackseconomy.exporter_price_set", (Object[])new Object[]{itemInHand.m_41720_().m_41466_().m_6881_().m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)CurrencyHelper.format(price)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"jackseconomy.exporter_price_removed", (Object[])new Object[]{itemInHand.m_41720_().m_41466_().m_6881_().m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD), true);
        }
        ItemPriceManager.save();
        ItemPriceManager.sendDataToPlayers();
        return 0;
    }
}

