/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.gamestages;

import java.util.HashMap;
import java.util.UUID;
import me.khajiitos.jackseconomy.price.AdminShopItemPriceInfo;
import me.khajiitos.jackseconomy.price.ItemPriceInfo;
import me.khajiitos.jackseconomy.price.ItemPriceManager;
import me.khajiitos.jackseconomy.util.NewShopUnlocks;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;

class GameStagesIntegration {
    private static final HashMap<UUID, NewShopUnlocks> newShopUnlocks = new HashMap();

    GameStagesIntegration() {
    }

    static boolean hasGameStage(Player player, String gameStage) {
        IStageData stageData = GameStageHelper.getPlayerData((Player)player);
        return stageData != null && stageData.hasStage(gameStage);
    }

    static void init() {
        MinecraftForge.EVENT_BUS.addListener(GameStagesIntegration::onGameStageAdded);
    }

    static NewShopUnlocks getNewShopUnlocks(Player player) {
        return newShopUnlocks.get(player.m_20148_());
    }

    static void onUnlocksAcknowledged(ServerPlayer player, NewShopUnlocks acknowledgedUnlocks) {
        if (newShopUnlocks.containsKey(player.m_20148_())) {
            NewShopUnlocks shopUnlocks = newShopUnlocks.get(player.m_20148_());
            shopUnlocks.reduce(acknowledgedUnlocks);
            if (shopUnlocks.unlockedItems.isEmpty() && shopUnlocks.unlockedCategories.isEmpty()) {
                newShopUnlocks.remove(player.m_20148_());
            }
        }
    }

    private static void onGameStageAdded(GameStageEvent.Added e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NewShopUnlocks unlocks = new NewShopUnlocks();
            for (ItemPriceManager.ItemPriceEntry itemPriceEntry : ItemPriceManager.getItemPriceInfos()) {
                ItemPriceInfo itemPriceInfo = itemPriceEntry.itemPriceInfo();
                if (!(itemPriceInfo instanceof AdminShopItemPriceInfo)) continue;
                AdminShopItemPriceInfo adminShopItemPriceInfo = (AdminShopItemPriceInfo)itemPriceInfo;
                if (!e.getStageName().equals(adminShopItemPriceInfo.adminShopStage) || adminShopItemPriceInfo.category == null) continue;
                NewShopUnlocks.Item item = new NewShopUnlocks.Item(adminShopItemPriceInfo.adminShopSlot, adminShopItemPriceInfo.category);
                String mainCategory = adminShopItemPriceInfo.category.split(":")[0];
                unlocks.unlockedCategories.add(mainCategory);
                unlocks.unlockedCategories.add(adminShopItemPriceInfo.category);
                unlocks.unlockedItems.add(item);
            }
            if (newShopUnlocks.containsKey(serverPlayer.m_20148_())) {
                newShopUnlocks.get(serverPlayer.m_20148_()).merge(unlocks);
            } else {
                newShopUnlocks.put(serverPlayer.m_20148_(), unlocks);
            }
        }
    }
}

