/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.blockentity;

import java.math.BigDecimal;
import me.khajiitos.jackseconomy.block.TransactionMachineBlock;
import me.khajiitos.jackseconomy.blockentity.ExporterBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.util.JacksEnergyStorage;
import me.khajiitos.jackseconomy.util.RedstoneToggle;
import me.khajiitos.jackseconomy.util.SideConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransactionMachineBlockEntity
extends BlockEntity
implements WorldlyContainer,
Container,
MenuProvider,
Nameable {
    protected JacksEnergyStorage energyStorage = new JacksEnergyStorage(this instanceof ExporterBlockEntity ? (Integer)Config.maxExporterEnergy.get() : (Integer)Config.maxImporterEnergy.get(), this instanceof ExporterBlockEntity ? (Integer)Config.maxExporterEnergyReceive.get() : (Integer)Config.maxImporterEnergyReceive.get(), 256);
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    protected BigDecimal currency = BigDecimal.ZERO;
    protected float speed;
    protected RedstoneToggle redstoneToggle = RedstoneToggle.IGNORED;
    protected SideConfig sideConfig = new SideConfig();
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);

    public TransactionMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected abstract Component getDefaultName();

    public SideConfig getSideConfig() {
        return this.sideConfig;
    }

    public Component m_7755_() {
        return this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        this.saveMachineData(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransactionMachineBlock.FACING);
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void saveMachineData(CompoundTag tag) {
        tag.m_128405_("Energy", this.energyStorage.getEnergyStored());
        tag.m_128350_("Speed", this.speed);
        tag.m_128359_("Currency", this.currency.toString());
        tag.m_128405_("RedstoneToggle", this.redstoneToggle.ordinal());
        tag.m_128365_("SideConfig", (Tag)this.sideConfig.toNbt());
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void loadMachineData(CompoundTag tag) {
        this.energyStorage.setEnergy(tag.m_128451_("Energy"));
        this.speed = tag.m_128457_("Speed");
        try {
            this.currency = new BigDecimal(tag.m_128461_("Currency"));
        }
        catch (NumberFormatException e) {
            this.currency = BigDecimal.ZERO;
        }
        int redstoneToggleNum = tag.m_128451_("RedstoneToggle");
        this.redstoneToggle = redstoneToggleNum >= 0 && redstoneToggleNum < RedstoneToggle.values().length ? RedstoneToggle.values()[redstoneToggleNum] : RedstoneToggle.IGNORED;
        this.sideConfig = SideConfig.fromIntArray(tag.m_128465_("SideConfig"));
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.loadMachineData(tag);
    }

    public RedstoneToggle getRedstoneToggle() {
        return this.redstoneToggle;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public BigDecimal getBalance() {
        return this.currency;
    }

    public void setRedstoneToggle(RedstoneToggle redstoneToggle) {
        this.redstoneToggle = redstoneToggle;
    }

    @Nullable
    public ItemStack addItem(ItemStack itemStack, int[] slots) {
        ItemStack remainingItems = itemStack.m_41777_();
        for (int i : slots) {
            ItemStack slotStack = (ItemStack)this.items.get(i);
            if (slotStack.m_41619_()) {
                int stackSize = Math.min(remainingItems.m_41613_(), itemStack.m_41741_());
                ItemStack stackToAdd = remainingItems.m_41620_(stackSize);
                this.items.set(i, (Object)stackToAdd);
            } else if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remainingItems)) {
                int spaceAvailable = itemStack.m_41741_() - slotStack.m_41613_();
                int stackSize = Math.min(remainingItems.m_41613_(), spaceAvailable);
                slotStack.m_41769_(stackSize);
                remainingItems.m_41774_(stackSize);
            }
            if (!remainingItems.m_41619_()) continue;
            return null;
        }
        return remainingItems;
    }

    @Nullable
    public boolean canAddItem(ItemStack itemStack, int[] slots) {
        for (int i : slots) {
            ItemStack stackInSlot = (ItemStack)this.items.get(i);
            if (stackInSlot.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stackInSlot) || stackInSlot.m_41613_() + itemStack.m_41613_() > stackInSlot.m_41741_()) continue;
            return true;
        }
        return false;
    }

    public void markUpdated() {
        if (this.m_58904_() != null) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

