/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.blockentity;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import me.khajiitos.jackseconomy.block.TransactionMachineBlock;
import me.khajiitos.jackseconomy.blockentity.IImporterBlockEntity;
import me.khajiitos.jackseconomy.blockentity.TransactionKineticMachineBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.init.BlockEntityReg;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.TicketItem;
import me.khajiitos.jackseconomy.menu.MechanicalImporterMenu;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.price.ItemPriceManager;
import me.khajiitos.jackseconomy.util.RedstoneToggle;
import me.khajiitos.jackseconomy.util.SideConfig;
import me.khajiitos.jackseconomy.util.SlottedItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalImporterBlockEntity
extends TransactionKineticMachineBlockEntity
implements IImporterBlockEntity {
    protected static final int[] slotsInput = new int[]{0, 1, 2};
    protected static final int[] slotsOutput = new int[]{3, 4, 5, 6, 7, 8};
    protected static final int slotTicket = 9;
    protected SlottedItemStackHandler itemHandlerInput;
    protected SlottedItemStackHandler itemHandlerOutput;
    protected SlottedItemStackHandler itemHandlerRejectionOutput;
    protected LazyOptional<IItemHandler> itemHandlerInputLazy = LazyOptional.of(() -> this.itemHandlerInput);
    protected LazyOptional<IItemHandler> itemHandlerOutputLazy = LazyOptional.of(() -> this.itemHandlerOutput);
    protected LazyOptional<IItemHandler> itemHandlerRejectionOutputLazy = LazyOptional.of(() -> this.itemHandlerRejectionOutput);
    public ItemDescription selectedItem;
    private float progress;

    public MechanicalImporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.MECHANICAL_IMPORTER.get(), pos, state);
        this.itemHandlerInput = new SlottedItemStackHandler((NonNullList<ItemStack>)this.items, slotsInput, true, false);
        this.itemHandlerOutput = new SlottedItemStackHandler((NonNullList<ItemStack>)this.items, slotsOutput, false, true);
        this.itemHandlerRejectionOutput = new SlottedItemStackHandler((NonNullList<ItemStack>)this.items, slotsInput, false, true, this::isItemRejected);
    }

    protected boolean hitCapacityLimit() {
        return this.getTotalBalance().compareTo(BigDecimal.valueOf((Double)Config.maxImporterBalance.get())) >= 0;
    }

    @Override
    public BigDecimal getTotalBalance() {
        return this.getBalance();
    }

    protected boolean isItemRejected(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof CurrencyItem);
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return true;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public int m_6643_() {
        return 10;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MechanicalImporterMenu(pContainerId, pPlayerInventory, (TransactionKineticMachineBlockEntity)this);
    }

    @Override
    public void saveMachineData(CompoundTag tag) {
        super.saveMachineData(tag);
        tag.m_128350_("Progress", this.progress);
        if (this.selectedItem != null) {
            tag.m_128365_("SelectedItem", (Tag)this.selectedItem.toNbt());
        }
    }

    @Override
    public void loadMachineData(CompoundTag tag) {
        super.loadMachineData(tag);
        this.itemHandlerInput.changeItems((NonNullList<ItemStack>)this.items);
        this.itemHandlerOutput.changeItems((NonNullList<ItemStack>)this.items);
        this.itemHandlerRejectionOutput.changeItems((NonNullList<ItemStack>)this.items);
        this.progress = tag.m_128457_("Progress");
        this.selectedItem = tag.m_128441_("SelectedItem") ? ItemDescription.fromNbt(tag.m_128469_("SelectedItem")) : null;
    }

    public int[] m_7071_(Direction pSide) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransactionMachineBlock.FACING);
        switch (this.sideConfig.getValue(SideConfig.directionRelative(facing, pSide))) {
            case INPUT: {
                return slotsInput;
            }
            case OUTPUT: {
                return slotsOutput;
            }
            case REJECTION_OUTPUT: {
                return Arrays.stream(slotsInput).filter(slot -> this.isItemRejected((ItemStack)this.items.get(slot))).toArray();
            }
        }
        return new int[0];
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransactionMachineBlock.FACING);
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            switch (this.sideConfig.getValue(SideConfig.directionRelative(facing, side))) {
                case INPUT: {
                    return this.itemHandlerInputLazy.cast();
                }
                case OUTPUT: {
                    return this.itemHandlerOutputLazy.cast();
                }
                case REJECTION_OUTPUT: {
                    return this.itemHandlerRejectionOutputLazy.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerInputLazy.invalidate();
        this.itemHandlerOutputLazy.invalidate();
        this.itemHandlerRejectionOutputLazy.invalidate();
    }

    public double getProgressPerTick() {
        return (Double)Config.mechanicalImporterProgressPerSpeed.get() * (double)Math.abs(this.getSpeed());
    }

    private boolean doesRedstoneSettingMatchWorld(Level level, BlockPos pos) {
        return this.redstoneToggle == RedstoneToggle.SIGNAL_ON && level.m_276867_(pos) || this.redstoneToggle == RedstoneToggle.SIGNAL_OFF && !level.m_276867_(pos) || this.redstoneToggle == RedstoneToggle.IGNORED;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MechanicalImporterBlockEntity importer) {
        double price;
        importer.tick();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (importer.getTotalBalance().compareTo(BigDecimal.valueOf((Double)Config.maxImporterBalance.get())) < 0) {
            for (int i = 0; i < 3; ++i) {
                ItemStack inputItem = importer.m_8020_(i);
                Item item = inputItem.m_41720_();
                if (!(item instanceof CurrencyItem)) continue;
                CurrencyItem coin = (CurrencyItem)item;
                importer.currency = importer.currency.add(coin.value.multiply(new BigDecimal(inputItem.m_41613_())));
                inputItem.m_41764_(0);
            }
        }
        ItemStack ticketItemStack = (ItemStack)importer.items.get(9);
        List<ItemDescription> items = TicketItem.getItems(ticketItemStack);
        ItemStack itemStackToAdd = ItemStack.f_41583_;
        if (!items.isEmpty() && importer.selectedItem == null) {
            importer.selectedItem = items.get(0);
        }
        if (importer.selectedItem != null) {
            for (ItemDescription itemDescription : items) {
                if (!importer.selectedItem.equals(itemDescription)) continue;
                itemStackToAdd = itemDescription.createItemStack();
                break;
            }
        }
        double d = price = importer.selectedItem == null ? -1.0 : ItemPriceManager.getImporterBuyPrice(importer.selectedItem, 1);
        if (ticketItemStack.m_41619_() || !importer.canAddItem(itemStackToAdd, slotsOutput) || price < 0.0 || importer.currency.compareTo(new BigDecimal(price)) < 0) {
            if (importer.progress >= 0.0f) {
                importer.progress = Math.max(0.0f, importer.progress - 0.01f);
            }
        } else {
            double progressPerTick = importer.getProgressPerTick();
            if (!importer.doesRedstoneSettingMatchWorld(level, pos) || progressPerTick <= 0.0) {
                if (importer.progress >= 0.0f) {
                    importer.progress = Math.max(0.0f, importer.progress - 0.01f);
                }
            } else {
                importer.progress = (float)((double)importer.progress + progressPerTick);
                if (importer.progress >= 1.0f) {
                    importer.currency = importer.currency.subtract(new BigDecimal(price));
                    importer.addItem(itemStackToAdd, slotsOutput);
                    importer.progress = 0.0f;
                    level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 1.5f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, 3, 0.2, 0.15, 0.2, 0.25);
                }
            }
        }
        importer.markUpdated();
    }

    public Component m_7755_() {
        return Component.m_237115_((String)"block.jackseconomy.mechanical_importer");
    }

    @Override
    public void selectItem(ItemDescription itemDescription) {
        this.selectedItem = itemDescription;
    }

    @Override
    public ItemDescription getSelectedItem() {
        return this.selectedItem;
    }
}

