/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.blockentity;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import me.khajiitos.jackseconomy.block.TransactionMachineBlock;
import me.khajiitos.jackseconomy.blockentity.IExporterBlockEntity;
import me.khajiitos.jackseconomy.blockentity.TransactionKineticMachineBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.init.BlockEntityReg;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.item.ExporterTicketItem;
import me.khajiitos.jackseconomy.item.GoldenExporterTicketItem;
import me.khajiitos.jackseconomy.item.TicketItem;
import me.khajiitos.jackseconomy.menu.MechanicalExporterMenu;
import me.khajiitos.jackseconomy.price.ItemDescription;
import me.khajiitos.jackseconomy.price.ItemPriceManager;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.ItemHelper;
import me.khajiitos.jackseconomy.util.RedstoneToggle;
import me.khajiitos.jackseconomy.util.SideConfig;
import me.khajiitos.jackseconomy.util.SlottedItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalExporterBlockEntity
extends TransactionKineticMachineBlockEntity
implements IExporterBlockEntity {
    private static final int[] slotsInput = new int[]{0, 1, 2};
    private static final int[] slotsOutput = new int[]{3, 4, 5, 6, 7, 8};
    private static final int slotTicket = 9;
    private float progress = 0.0f;
    protected SlottedItemStackHandler itemHandlerInput;
    protected SlottedItemStackHandler itemHandlerOutput;
    protected SlottedItemStackHandler itemHandlerRejectionOutput;
    protected LazyOptional<IItemHandler> itemHandlerInputLazy = LazyOptional.of(() -> this.itemHandlerInput);
    protected LazyOptional<IItemHandler> itemHandlerOutputLazy = LazyOptional.of(() -> this.itemHandlerOutput);
    protected LazyOptional<IItemHandler> itemHandlerRejectionOutputLazy = LazyOptional.of(() -> this.itemHandlerRejectionOutput);

    public MechanicalExporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityReg.MECHANICAL_EXPORTER.get(), pos, state);
        this.itemHandlerInput = new SlottedItemStackHandler((NonNullList<ItemStack>)this.items, slotsInput, true, false);
        this.itemHandlerOutput = new SlottedItemStackHandler((NonNullList<ItemStack>)this.items, slotsOutput, false, true);
        this.itemHandlerRejectionOutput = new SlottedItemStackHandler((NonNullList<ItemStack>)this.items, slotsInput, false, true, this::isItemRejected);
    }

    protected boolean hitCapacityLimit() {
        return this.getTotalBalance().compareTo(BigDecimal.valueOf((Double)Config.maxExporterBalance.get())) >= 0;
    }

    protected boolean isItemRejected(ItemStack itemStack) {
        ItemStack ticketItem = (ItemStack)this.items.get(9);
        boolean isOnTicket = ticketItem.m_41720_() instanceof GoldenExporterTicketItem || ticketItem.m_41720_() instanceof ExporterTicketItem && ExporterTicketItem.getItems(ticketItem).contains(ItemDescription.ofItem(itemStack));
        return !isOnTicket || ItemPriceManager.getExporterSellPrice(ItemDescription.ofItem(itemStack), 1) == -1.0;
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.jackseconomy.mechanical_exporter");
    }

    public Component m_7755_() {
        return this.getDefaultName();
    }

    @Override
    public Component m_5446_() {
        return this.getDefaultName();
    }

    public int m_6643_() {
        return 10;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public BigDecimal getTotalBalance() {
        BigDecimal balance = this.getBalance();
        for (int slot : slotsOutput) {
            ItemStack itemStack = (ItemStack)this.items.get(slot);
            Item item = itemStack.m_41720_();
            if (!(item instanceof CurrencyItem)) continue;
            CurrencyItem currencyItem = (CurrencyItem)item;
            balance = balance.add(currencyItem.value.multiply(BigDecimal.valueOf(itemStack.m_41613_())));
        }
        return balance;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MechanicalExporterBlockEntity exporter) {
        exporter.tick();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        exporter.updateCoinsOutput();
        boolean progress = false;
        ItemStack progressItem = null;
        ItemStack ticketItem = (ItemStack)exporter.items.get(9);
        if (ticketItem.m_41720_() instanceof ExporterTicketItem && exporter.getTotalBalance().compareTo(BigDecimal.valueOf((Double)Config.maxExporterBalance.get())) < 0 && (exporter.redstoneToggle == RedstoneToggle.SIGNAL_ON && level.m_276867_(pos) || exporter.redstoneToggle == RedstoneToggle.SIGNAL_OFF && !level.m_276867_(pos) || exporter.redstoneToggle == RedstoneToggle.IGNORED)) {
            for (int i = 0; i < 6; ++i) {
                ItemStack item = (ItemStack)exporter.items.get(i);
                ItemDescription itemDescription = ItemDescription.ofItem(item);
                if (item.m_41619_() || ItemPriceManager.getExporterSellPrice(itemDescription, 1) == -1.0 || !(ticketItem.m_41720_() instanceof GoldenExporterTicketItem) && !TicketItem.getItems(ticketItem).stream().anyMatch(desc -> desc.equals(itemDescription))) continue;
                progressItem = item;
            }
        }
        if (progressItem != null) {
            double progressPerTick = exporter.getProgressPerTick();
            progress = progressPerTick > 0.0;
            exporter.progress = (float)((double)exporter.progress + progressPerTick);
            if (exporter.progress >= 1.0f) {
                exporter.progress = 0.0f;
                if (!exporter.sellItemFromItemstack(progressItem)) {
                    ItemHelper.dropItem(progressItem.m_41777_(), level, pos);
                    progressItem.m_41764_(0);
                }
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 1.5f);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, 3, 0.2, 0.15, 0.2, 0.25);
            }
        }
        if (!progress) {
            exporter.progress = Math.max(0.0f, exporter.progress - 0.005f);
        }
        exporter.markUpdated();
    }

    public double getProgressPerTick() {
        return (Double)Config.mechanicalExporterProgressPerSpeed.get() * (double)Math.abs(this.getSpeed());
    }

    public void updateCoinsOutput() {
        Item item;
        BigDecimal worth = BigDecimal.ZERO;
        for (int slot : slotsOutput) {
            ItemStack itemStack = (ItemStack)this.items.get(slot);
            item = itemStack.m_41720_();
            if (item instanceof CurrencyItem) {
                CurrencyItem coin = (CurrencyItem)item;
                worth = worth.add(coin.value.multiply(new BigDecimal(itemStack.m_41613_())));
            }
            itemStack.m_41764_(0);
        }
        this.currency = this.currency.add(worth);
        List<ItemStack> items = CurrencyHelper.getCurrencyItems(this.currency);
        for (int i = 0; i < Math.min(6, items.size()); ++i) {
            BigDecimal bigDecimal;
            int slot;
            ItemStack itemStack = items.get(i);
            slot = slotsOutput[i];
            this.items.set(slot, (Object)itemStack);
            item = itemStack.m_41720_();
            if (item instanceof CurrencyItem) {
                CurrencyItem currencyItem = (CurrencyItem)item;
                bigDecimal = currencyItem.value.multiply(new BigDecimal(itemStack.m_41613_()));
            } else {
                bigDecimal = BigDecimal.ZERO;
            }
            BigDecimal thisWorth = bigDecimal;
            this.currency = this.currency.subtract(thisWorth);
        }
    }

    public int[] m_7071_(Direction pSide) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransactionMachineBlock.FACING);
        switch (this.sideConfig.getValue(SideConfig.directionRelative(facing, pSide))) {
            case INPUT: {
                return slotsInput;
            }
            case OUTPUT: {
                return slotsOutput;
            }
            case REJECTION_OUTPUT: {
                return Arrays.stream(slotsInput).filter(slot -> this.isItemRejected((ItemStack)this.items.get(slot))).toArray();
            }
        }
        return new int[0];
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransactionMachineBlock.FACING);
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            switch (this.sideConfig.getValue(SideConfig.directionRelative(facing, side))) {
                case INPUT: {
                    return this.itemHandlerInputLazy.cast();
                }
                case OUTPUT: {
                    return this.itemHandlerOutputLazy.cast();
                }
                case REJECTION_OUTPUT: {
                    return this.itemHandlerRejectionOutputLazy.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerInputLazy.invalidate();
        this.itemHandlerOutputLazy.invalidate();
        this.itemHandlerRejectionOutputLazy.invalidate();
    }

    @Override
    public void saveMachineData(CompoundTag tag) {
        super.saveMachineData(tag);
        tag.m_128350_("Progress", this.progress);
    }

    @Override
    public void loadMachineData(CompoundTag tag) {
        super.loadMachineData(tag);
        this.itemHandlerInput.changeItems((NonNullList<ItemStack>)this.items);
        this.itemHandlerOutput.changeItems((NonNullList<ItemStack>)this.items);
        this.itemHandlerRejectionOutput.changeItems((NonNullList<ItemStack>)this.items);
        this.progress = tag.m_128457_("Progress");
    }

    public boolean sellItemFromItemstack(ItemStack itemStack) {
        double sellPrice = ItemPriceManager.getExporterSellPrice(ItemDescription.ofItem(itemStack), 1);
        if (sellPrice == -1.0) {
            return false;
        }
        this.currency = this.currency.add(BigDecimal.valueOf(sellPrice));
        itemStack.m_41769_(-1);
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new MechanicalExporterMenu(containerId, inventory, (TransactionKineticMachineBlockEntity)this);
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return ItemPriceManager.getExporterSellPrice(ItemDescription.ofItem(pItemStack), 1) != -1.0;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }
}

