/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.blockentity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import me.khajiitos.jackseconomy.block.CurrencyConverterBlock;
import me.khajiitos.jackseconomy.block.TransactionMachineBlock;
import me.khajiitos.jackseconomy.blockentity.ISideConfigurable;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.init.BlockEntityReg;
import me.khajiitos.jackseconomy.item.CurrencyItem;
import me.khajiitos.jackseconomy.menu.CurrencyConverterMenu;
import me.khajiitos.jackseconomy.util.CurrencyType;
import me.khajiitos.jackseconomy.util.IDisablable;
import me.khajiitos.jackseconomy.util.SideConfig;
import me.khajiitos.jackseconomy.util.SlottedItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrencyConverterBlockEntity
extends BlockEntity
implements WorldlyContainer,
Container,
MenuProvider,
ISideConfigurable,
IDisablable {
    public NonNullList<ItemStack> items;
    public CurrencyType selectedCurrencyType = CurrencyType.PENNY;
    protected BigDecimal currency = BigDecimal.ZERO;
    private static final int[] slotsInput = new int[]{0, 1, 2};
    private static final int[] slotsOutput = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11};
    protected SlottedItemStackHandler itemHandlerInput;
    protected SlottedItemStackHandler itemHandlerOutput;
    protected SlottedItemStackHandler itemHandlerRejectionOutput;
    protected LazyOptional<IItemHandler> itemHandlerInputLazy = LazyOptional.of(() -> this.itemHandlerInput);
    protected LazyOptional<IItemHandler> itemHandlerOutputLazy = LazyOptional.of(() -> this.itemHandlerOutput);
    protected LazyOptional<IItemHandler> itemHandlerRejectionOutputLazy = LazyOptional.of(() -> this.itemHandlerRejectionOutput);
    protected SideConfig sideConfig = new SideConfig();

    public CurrencyConverterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityReg.CURRENCY_CONVERTER.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        this.itemHandlerInput = new SlottedItemStackHandler(this.items, slotsInput, true, false);
        this.itemHandlerOutput = new SlottedItemStackHandler(this.items, slotsOutput, false, true);
        this.itemHandlerRejectionOutput = new SlottedItemStackHandler(this.items, slotsInput, false, true, this::isItemRejected);
    }

    protected boolean hitCapacityLimit() {
        return this.getTotalBalance().compareTo(BigDecimal.valueOf((Double)Config.maxCurrencyConverterBalance.get())) >= 0;
    }

    protected boolean isItemRejected(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof CurrencyItem) || this.hitCapacityLimit();
    }

    public BigDecimal getTotalBalance() {
        BigDecimal balance = this.getCurrency();
        for (int slot : slotsOutput) {
            ItemStack itemStack = (ItemStack)this.items.get(slot);
            Item item = itemStack.m_41720_();
            if (!(item instanceof CurrencyItem)) continue;
            CurrencyItem currencyItem = (CurrencyItem)item;
            balance = balance.add(currencyItem.value.multiply(BigDecimal.valueOf(itemStack.m_41613_())));
        }
        return balance;
    }

    public BigDecimal getCurrency() {
        return this.currency;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return false;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public int m_6643_() {
        return 12;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.jackseconomy.currency_converter");
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CurrencyConverterMenu(pContainerId, pPlayerInventory, this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, CurrencyConverterBlockEntity blockEntity) {
        CurrencyItem currencyItem;
        Item item;
        ItemStack itemStack;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (blockEntity.isDisabled()) {
            return;
        }
        boolean updated = false;
        if (blockEntity.getTotalBalance().compareTo(BigDecimal.valueOf((Double)Config.maxCurrencyConverterBalance.get())) < 0) {
            for (int slotInput : slotsInput) {
                itemStack = (ItemStack)blockEntity.items.get(slotInput);
                if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof CurrencyItem)) continue;
                currencyItem = (CurrencyItem)item;
                blockEntity.currency = blockEntity.currency.add(currencyItem.value.multiply(new BigDecimal(itemStack.m_41613_())));
                itemStack.m_41764_(0);
                updated = true;
            }
        }
        for (int slotOutput : slotsOutput) {
            itemStack = (ItemStack)blockEntity.items.get(slotOutput);
            if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof CurrencyItem) || blockEntity.selectedCurrencyType.item == (currencyItem = (CurrencyItem)item)) continue;
            blockEntity.currency = blockEntity.currency.add(currencyItem.value.multiply(new BigDecimal(itemStack.m_41613_())));
            itemStack.m_41764_(0);
            updated = true;
        }
        int toAdd = Math.min(blockEntity.selectedCurrencyType.item.m_41459_(), blockEntity.currency.divide(blockEntity.selectedCurrencyType.worth, RoundingMode.DOWN).intValue());
        if (toAdd > 0) {
            ItemStack stack = new ItemStack((ItemLike)blockEntity.selectedCurrencyType.item, toAdd);
            ItemStack left = blockEntity.addItem(stack, slotsOutput);
            BigDecimal worth = blockEntity.selectedCurrencyType.worth;
            blockEntity.currency = left != null && !left.m_41619_() ? blockEntity.currency.subtract(worth.multiply(new BigDecimal(toAdd - left.m_41613_()))) : blockEntity.currency.subtract(worth.multiply(new BigDecimal(toAdd)));
            updated = true;
        }
        if (updated) {
            blockEntity.markUpdated();
        }
    }

    public void markUpdated() {
        if (this.m_58904_() != null) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.loadAdditional(tag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128359_("Currency", this.currency.toString());
        pTag.m_128347_("CurrencyType", (double)this.selectedCurrencyType.ordinal());
        pTag.m_128365_("SideConfig", (Tag)this.sideConfig.toNbt());
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
    }

    public void loadAdditional(CompoundTag pTag) {
        try {
            this.currency = new BigDecimal(pTag.m_128461_("Currency"));
        }
        catch (NumberFormatException e) {
            this.currency = BigDecimal.ZERO;
        }
        int currencyType = pTag.m_128451_("CurrencyType");
        this.selectedCurrencyType = currencyType < CurrencyType.values().length ? CurrencyType.values()[currencyType] : CurrencyType.PENNY;
        this.sideConfig = SideConfig.fromIntArray(pTag.m_128465_("SideConfig"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.loadAdditional(pTag);
    }

    @Nullable
    public ItemStack addItem(ItemStack itemStack, int[] slots) {
        ItemStack remainingItems = itemStack.m_41777_();
        for (int i : slots) {
            ItemStack slotStack = (ItemStack)this.items.get(i);
            if (slotStack.m_41619_()) {
                int stackSize = Math.min(remainingItems.m_41613_(), itemStack.m_41741_());
                ItemStack stackToAdd = remainingItems.m_41620_(stackSize);
                this.items.set(i, (Object)stackToAdd);
            } else if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remainingItems)) {
                int spaceAvailable = itemStack.m_41741_() - slotStack.m_41613_();
                int stackSize = Math.min(remainingItems.m_41613_(), spaceAvailable);
                slotStack.m_41769_(stackSize);
                remainingItems.m_41774_(stackSize);
            }
            if (!remainingItems.m_41619_()) continue;
            return null;
        }
        return remainingItems;
    }

    public int[] m_7071_(Direction pSide) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransactionMachineBlock.FACING);
        switch (this.sideConfig.getValue(SideConfig.directionRelative(facing, pSide))) {
            case INPUT: {
                return slotsInput;
            }
            case OUTPUT: {
                return slotsOutput;
            }
        }
        return new int[0];
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CurrencyConverterBlock.FACING);
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            switch (this.sideConfig.getValue(SideConfig.directionRelative(facing, side))) {
                case INPUT: {
                    return this.itemHandlerInputLazy.cast();
                }
                case OUTPUT: {
                    return this.itemHandlerOutputLazy.cast();
                }
                case REJECTION_OUTPUT: {
                    return this.itemHandlerRejectionOutputLazy.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerInputLazy.invalidate();
        this.itemHandlerOutputLazy.invalidate();
        this.itemHandlerRejectionOutputLazy.invalidate();
    }

    @Override
    public SideConfig getSideConfig() {
        return this.sideConfig;
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)Config.oneItemCurrencyMode.get();
    }
}

