/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy.block;

import me.khajiitos.jackseconomy.blockentity.CurrencyConverterBlockEntity;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.init.BlockEntityReg;
import me.khajiitos.jackseconomy.util.CurrencyHelper;
import me.khajiitos.jackseconomy.util.IDisablable;
import me.khajiitos.jackseconomy.util.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CurrencyConverterBlock
extends BaseEntityBlock
implements IDisablable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public CurrencyConverterBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityReg.CURRENCY_CONVERTER.get()).m_155264_(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isDisabled()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CurrencyConverterBlockEntity) {
            CurrencyConverterBlockEntity currencyConverterBlockEntity = (CurrencyConverterBlockEntity)blockEntity;
            if (!level.m_5776_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)currencyConverterBlockEntity, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CurrencyConverterBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityReg.CURRENCY_CONVERTER.get()), CurrencyConverterBlockEntity::tick);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof CurrencyConverterBlockEntity) {
                CurrencyConverterBlockEntity blockEntity = (CurrencyConverterBlockEntity)blockentity;
                CurrencyHelper.getCurrencyItems(blockEntity.getCurrency()).forEach(itemStack -> ItemHelper.dropItem(itemStack, level, blockEntity.m_58899_()));
                for (int i = 0; i < blockEntity.items.size(); ++i) {
                    ItemStack stack = blockEntity.m_8020_(i);
                    ItemHelper.dropItem(stack, level, blockEntity.m_58899_());
                }
            }
            if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
                level.m_46747_(pos);
            }
        }
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)Config.oneItemCurrencyMode.get();
    }
}

