/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.jackseconomy;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.utility.Couple;
import me.khajiitos.jackseconomy.JacksEconomyClient;
import me.khajiitos.jackseconomy.config.ClientConfig;
import me.khajiitos.jackseconomy.config.Config;
import me.khajiitos.jackseconomy.curios.CuriosCheck;
import me.khajiitos.jackseconomy.curios.CuriosHandler;
import me.khajiitos.jackseconomy.gamestages.GameStagesManager;
import me.khajiitos.jackseconomy.init.AdminShopCommand;
import me.khajiitos.jackseconomy.init.BlockEntityReg;
import me.khajiitos.jackseconomy.init.ContainerReg;
import me.khajiitos.jackseconomy.init.ItemBlockReg;
import me.khajiitos.jackseconomy.init.Packets;
import me.khajiitos.jackseconomy.init.PriceCommands;
import me.khajiitos.jackseconomy.init.Sounds;
import me.khajiitos.jackseconomy.listener.ConfigEventListeners;
import me.khajiitos.jackseconomy.listener.OtherEventListeners;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="jackseconomy")
public class JacksEconomy {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "jackseconomy";
    public static MinecraftServer server;

    public JacksEconomy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventListeners());
        MinecraftForge.EVENT_BUS.register((Object)new OtherEventListeners());
        MinecraftForge.EVENT_BUS.addListener(JacksEconomy::onRegisterCommands);
        AdminShopCommand.init(MinecraftForge.EVENT_BUS);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (CuriosCheck.isInstalled()) {
            eventBus.register(CuriosHandler.class);
        }
        ItemBlockReg.init(eventBus);
        BlockEntityReg.init(eventBus);
        ContainerReg.init(eventBus);
        Sounds.init(eventBus);
        Packets.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> JacksEconomyClient::init);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        BlockStressValues.registerProvider((String)MOD_ID, (BlockStressValues.IStressValueProvider)new BlockStressValues.IStressValueProvider(){

            public double getImpact(Block block) {
                if (block == ItemBlockReg.MECHANICAL_EXPORTER.get()) {
                    return (Double)Config.mechanicalExporterStressPerRPM.get();
                }
                if (block == ItemBlockReg.MECHANICAL_IMPORTER.get()) {
                    return (Double)Config.mechanicalImporterStressPerRPM.get();
                }
                return 0.0;
            }

            public double getCapacity(Block block) {
                return 0.0;
            }

            public boolean hasImpact(Block block) {
                return this.getImpact(block) != 0.0;
            }

            public boolean hasCapacity(Block block) {
                return false;
            }

            @Nullable
            public Couple<Integer> getGeneratedRPM(Block block) {
                return null;
            }
        });
        GameStagesManager.init();
    }

    public static void onRegisterCommands(RegisterCommandsEvent e) {
        PriceCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }
}

