/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.impl.ListOptionEntryImpl;
import dev.isxander.yacl3.impl.SafeBinding;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ListOptionImpl<T>
implements ListOption<T> {
    private final Component name;
    private final OptionDescription description;
    private final Binding<List<T>> binding;
    private final Supplier<T> initialValue;
    private final List<ListOptionEntry<T>> entries;
    private final boolean collapsed;
    private boolean available;
    private final int minimumNumberOfEntries;
    private final int maximumNumberOfEntries;
    private final boolean insertEntriesAtEnd;
    private final ImmutableSet<OptionFlag> flags;
    private final EntryFactory entryFactory;
    private final List<BiConsumer<Option<List<T>>, List<T>>> listeners;
    private final List<Runnable> refreshListeners;
    private int listenerTriggerDepth = 0;

    public ListOptionImpl(@NotNull Component name, @NotNull OptionDescription description, @NotNull Binding<List<T>> binding, @NotNull Supplier<T> initialValue, @NotNull Function<ListOptionEntry<T>, Controller<T>> controllerFunction, ImmutableSet<OptionFlag> flags, boolean collapsed, boolean available, int minimumNumberOfEntries, int maximumNumberOfEntries, boolean insertEntriesAtEnd, Collection<BiConsumer<Option<List<T>>, List<T>>> listeners) {
        this.name = name;
        this.description = description;
        this.binding = new SafeBinding<List<List<T>>>(binding);
        this.initialValue = initialValue;
        this.entryFactory = new EntryFactory(controllerFunction);
        this.entries = this.createEntries((Collection)this.binding().getValue());
        this.collapsed = collapsed;
        this.flags = flags;
        this.available = available;
        this.minimumNumberOfEntries = minimumNumberOfEntries;
        this.maximumNumberOfEntries = maximumNumberOfEntries;
        this.insertEntriesAtEnd = insertEntriesAtEnd;
        this.listeners = new ArrayList<BiConsumer<Option<List<T>>, List<T>>>();
        this.listeners.addAll(listeners);
        this.refreshListeners = new ArrayList<Runnable>();
        this.callListeners(true);
    }

    @Override
    @NotNull
    public Component name() {
        return this.name;
    }

    @Override
    @NotNull
    public OptionDescription description() {
        return this.description;
    }

    @Override
    @NotNull
    public Component tooltip() {
        return this.description().text();
    }

    @Override
    @NotNull
    public ImmutableList<ListOptionEntry<T>> options() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    @NotNull
    public Controller<List<T>> controller() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Binding<List<T>> binding() {
        return this.binding;
    }

    @Override
    public boolean collapsed() {
        return this.collapsed;
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    @NotNull
    public ImmutableList<T> pendingValue() {
        return ImmutableList.copyOf(this.entries.stream().map(Option::pendingValue).toList());
    }

    @Override
    public void insertEntry(int index, ListOptionEntry<?> entry) {
        this.entries.add(index, entry);
        this.onRefresh();
    }

    @Override
    public ListOptionEntry<T> insertNewEntry() {
        ListOptionEntry newEntry = this.entryFactory.create(this.initialValue.get());
        if (this.insertEntriesAtEnd) {
            this.entries.add(newEntry);
        } else {
            this.entries.add(0, newEntry);
        }
        this.onRefresh();
        return newEntry;
    }

    @Override
    public void removeEntry(ListOptionEntry<?> entry) {
        if (this.entries.remove(entry)) {
            this.onRefresh();
        }
    }

    @Override
    public int indexOf(ListOptionEntry<?> entry) {
        return this.entries.indexOf(entry);
    }

    @Override
    public void requestSet(@NotNull List<T> value) {
        this.entries.clear();
        this.entries.addAll(this.createEntries(value));
        this.onRefresh();
    }

    @Override
    public boolean changed() {
        return !this.binding().getValue().equals(this.pendingValue());
    }

    @Override
    public boolean applyValue() {
        if (this.changed()) {
            this.binding().setValue((List<ImmutableList<T>>)this.pendingValue());
            return true;
        }
        return false;
    }

    @Override
    public void forgetPendingValue() {
        this.requestSet(this.binding().getValue());
    }

    @Override
    public void requestSetDefault() {
        this.requestSet(this.binding().defaultValue());
    }

    @Override
    public boolean isPendingValueDefault() {
        return this.binding().defaultValue().equals(this.pendingValue());
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        boolean changed = this.available != available;
        this.available = available;
        if (changed) {
            this.callListeners(false);
        }
    }

    @Override
    public int numberOfEntries() {
        return this.entries.size();
    }

    @Override
    public int maximumNumberOfEntries() {
        return this.maximumNumberOfEntries;
    }

    @Override
    public int minimumNumberOfEntries() {
        return this.minimumNumberOfEntries;
    }

    @Override
    public void addListener(BiConsumer<Option<List<T>>, List<T>> changedListener) {
        this.listeners.add(changedListener);
    }

    @Override
    public void addRefreshListener(Runnable changedListener) {
        this.refreshListeners.add(changedListener);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    private List<ListOptionEntry<T>> createEntries(Collection<T> values) {
        return values.stream().map(this.entryFactory::create).collect(Collectors.toList());
    }

    void callListeners(boolean bypass) {
        ImmutableList<T> pendingValue = this.pendingValue();
        if (bypass || this.listenerTriggerDepth == 0) {
            if (this.listenerTriggerDepth > 10) {
                throw new IllegalStateException("Listener trigger depth exceeded 10! This means a listener triggered a listener etc etc 10 times deep. This is likely a bug in the mod using YACL!");
            }
            ++this.listenerTriggerDepth;
            for (BiConsumer<Option<List<ListOptionImpl>>, List<ListOptionImpl>> biConsumer : this.listeners) {
                try {
                    biConsumer.accept(this, (List<ListOptionImpl>)pendingValue);
                }
                catch (Exception e) {
                    YACLConstants.LOGGER.error("Exception whilst triggering listener for option '%s'".formatted(this.name.getString()), (Throwable)e);
                }
            }
            --this.listenerTriggerDepth;
        }
    }

    private void onRefresh() {
        this.refreshListeners.forEach(Runnable::run);
        this.callListeners(true);
    }

    private class EntryFactory {
        private final Function<ListOptionEntry<T>, Controller<T>> controllerFunction;

        private EntryFactory(Function<ListOptionEntry<T>, Controller<T>> controllerFunction) {
            this.controllerFunction = controllerFunction;
        }

        public ListOptionEntry<T> create(T initialValue) {
            return new ListOptionEntryImpl(ListOptionImpl.this, initialValue, this.controllerFunction);
        }
    }

    @ApiStatus.Internal
    public static final class BuilderImpl<T>
    implements ListOption.Builder<T> {
        private Component name = Component.empty();
        private OptionDescription description = OptionDescription.EMPTY;
        private Function<ListOptionEntry<T>, Controller<T>> controllerFunction;
        private Binding<List<T>> binding = null;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private Supplier<T> initialValue;
        private boolean collapsed = false;
        private boolean available = true;
        private int minimumNumberOfEntries = 0;
        private int maximumNumberOfEntries = Integer.MAX_VALUE;
        private boolean insertEntriesAtEnd = false;
        private final List<BiConsumer<Option<List<T>>, List<T>>> listeners = new ArrayList<BiConsumer<Option<List<T>>, List<T>>>();

        @Override
        public ListOption.Builder<T> name(@NotNull Component name) {
            Validate.notNull((Object)name, (String)"`name` must not be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        public ListOption.Builder<T> description(@NotNull OptionDescription description) {
            Validate.notNull((Object)description, (String)"`description` must not be null", (Object[])new Object[0]);
            this.description = description;
            return this;
        }

        @Override
        public ListOption.Builder<T> initial(@NotNull Supplier<T> initialValue) {
            Validate.notNull(initialValue, (String)"`initialValue` cannot be empty", (Object[])new Object[0]);
            this.initialValue = initialValue;
            return this;
        }

        @Override
        public ListOption.Builder<T> initial(@NotNull T initialValue) {
            Validate.notNull(initialValue, (String)"`initialValue` cannot be empty", (Object[])new Object[0]);
            this.initialValue = () -> initialValue;
            return this;
        }

        @Override
        public ListOption.Builder<T> controller(@NotNull Function<Option<T>, ControllerBuilder<T>> controller) {
            Validate.notNull(controller, (String)"`controller` cannot be null", (Object[])new Object[0]);
            this.controllerFunction = opt -> ((ControllerBuilder)controller.apply((Option)opt)).build();
            return this;
        }

        @Override
        public ListOption.Builder<T> customController(@NotNull Function<ListOptionEntry<T>, Controller<T>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controllerFunction = control;
            return this;
        }

        @Override
        public ListOption.Builder<T> binding(@NotNull Binding<List<T>> binding) {
            Validate.notNull(binding, (String)"`binding` cannot be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        @Override
        public ListOption.Builder<T> binding(@NotNull List<T> def, @NotNull @NotNull Supplier<@NotNull List<T>> getter, @NotNull @NotNull Consumer<@NotNull List<T>> setter) {
            Validate.notNull(def, (String)"`def` must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"`getter` must not be null", (Object[])new Object[0]);
            Validate.notNull(setter, (String)"`setter` must not be null", (Object[])new Object[0]);
            this.binding = Binding.generic(def, getter, setter);
            return this;
        }

        @Override
        public ListOption.Builder<T> available(boolean available) {
            this.available = available;
            return this;
        }

        @Override
        public ListOption.Builder<T> minimumNumberOfEntries(int number) {
            this.minimumNumberOfEntries = number;
            return this;
        }

        @Override
        public ListOption.Builder<T> maximumNumberOfEntries(int number) {
            this.maximumNumberOfEntries = number;
            return this;
        }

        @Override
        public ListOption.Builder<T> insertEntriesAtEnd(boolean insertAtEnd) {
            this.insertEntriesAtEnd = insertAtEnd;
            return this;
        }

        @Override
        public ListOption.Builder<T> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        @Override
        public ListOption.Builder<T> flags(@NotNull Collection<OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        @Override
        public ListOption.Builder<T> collapsed(boolean collapsible) {
            this.collapsed = collapsible;
            return this;
        }

        @Override
        public ListOption.Builder<T> listener(@NotNull BiConsumer<Option<List<T>>, List<T>> listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public ListOption.Builder<T> listeners(@NotNull Collection<BiConsumer<Option<List<T>>, List<T>>> listeners) {
            this.listeners.addAll(listeners);
            return this;
        }

        @Override
        public ListOption<T> build() {
            Validate.notNull(this.controllerFunction, (String)"`controller` must not be null", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"`binding` must not be null", (Object[])new Object[0]);
            Validate.notNull(this.initialValue, (String)"`initialValue` must not be null", (Object[])new Object[0]);
            return new ListOptionImpl<T>(this.name, this.description, this.binding, this.initialValue, this.controllerFunction, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.collapsed, this.available, this.minimumNumberOfEntries, this.maximumNumberOfEntries, this.insertEntriesAtEnd, this.listeners);
        }
    }
}

