/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.debug.DebugProperties;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class DynamicTextureImage
implements ImageRenderer {
    protected static final TextureManager textureManager = Minecraft.getInstance().getTextureManager();
    protected NativeImage image;
    protected DynamicTexture texture;
    protected final ResourceLocation uniqueLocation;
    protected final int width;
    protected final int height;

    public DynamicTextureImage(NativeImage image, ResourceLocation location) {
        RenderSystem.assertOnRenderThread();
        this.image = image;
        this.texture = new DynamicTexture(image);
        this.uniqueLocation = location;
        textureManager.register(this.uniqueLocation, (AbstractTexture)this.texture);
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    @Override
    public int render(GuiGraphics graphics, int x, int y, int renderWidth, float tickDelta) {
        if (this.image == null) {
            return 0;
        }
        float ratio = (float)renderWidth / (float)this.width;
        int targetHeight = (int)((float)this.height * ratio);
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        graphics.pose().scale(ratio, ratio, 1.0f);
        if (DebugProperties.IMAGE_FILTERING) {
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        }
        graphics.blit(this.uniqueLocation, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        graphics.pose().popPose();
        return targetHeight;
    }

    @Override
    public void close() {
        this.image.close();
        this.image = null;
        this.texture = null;
        textureManager.release(this.uniqueLocation);
    }

    public static ImageRendererFactory fromPath(Path imagePath, ResourceLocation location) {
        return () -> () -> new DynamicTextureImage(NativeImage.read((InputStream)new FileInputStream(imagePath.toFile())), location);
    }
}

