/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.image.ImageRendererManager;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class YACLImageReloadListener
implements PreparableReloadListener {
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        YACLConstants.LOGGER.info("YACL is reloading images");
        Map imageResources = resourceManager.listResources("textures", location -> ImageRendererManager.PRELOADED_IMAGE_FACTORIES.stream().anyMatch(factory -> factory.predicate().test((ResourceLocation)location)));
        if (imageResources.isEmpty()) {
            preparationBarrier.wait(null);
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(imageResources.size());
        for (Map.Entry entry : imageResources.entrySet()) {
            ResourceLocation location2 = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            ImageRendererFactory imageFactory = ImageRendererManager.PRELOADED_IMAGE_FACTORIES.stream().filter(factory -> factory.predicate().test(location2)).map(factory -> factory.factory().apply(resource, location2)).findAny().orElseThrow();
            CompletionStage imageFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> ImageRendererManager.safelyPrepareFactory(location2, imageFactory), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenApplyAsync(imageSupplierOpt -> {
                ImageRenderer imageRenderer;
                if (imageSupplierOpt.isEmpty()) {
                    return Optional.empty();
                }
                ImageRendererFactory.ImageSupplier supplier = (ImageRendererFactory.ImageSupplier)imageSupplierOpt.get();
                try {
                    imageRenderer = supplier.completeImage();
                }
                catch (Exception e) {
                    YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)location2, (Object)e);
                    return Optional.empty();
                }
                ImageRendererManager.PRELOADED_IMAGE_CACHE.put(location2, imageRenderer);
                return Optional.of(imageRenderer);
            }, gameExecutor);
            futures.add(imageFuture);
            ((CompletableFuture)imageFuture).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Failed to load image");
                    CrashReportCategory category = crashReport.addCategory("YACL Gui");
                    category.setDetail("Image identifier", (Object)location2.toString());
                    throw new ReportedException(crashReport);
                }
            });
        }
        YACLConstants.LOGGER.info("YACL has found {} images", (Object)imageResources.size());
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }
}

