/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.image.impl.AnimatedDynamicTextureImage;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class ImageRendererManager {
    private static final ExecutorService SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(task -> new Thread(task, "YACL Image Prep"));
    private static final Map<ResourceLocation, CompletableFuture<ImageRenderer>> IMAGE_CACHE = new ConcurrentHashMap<ResourceLocation, CompletableFuture<ImageRenderer>>();
    static final Map<ResourceLocation, ImageRenderer> PRELOADED_IMAGE_CACHE = new ConcurrentHashMap<ResourceLocation, ImageRenderer>();
    static final List<PreloadedImageFactory> PRELOADED_IMAGE_FACTORIES = List.of(new PreloadedImageFactory(location -> location.getPath().endsWith(".webp"), AnimatedDynamicTextureImage::createWEBPFromResource), new PreloadedImageFactory(location -> location.getPath().endsWith(".gif"), AnimatedDynamicTextureImage::createGIFFromResource));

    public static <T extends ImageRenderer> Optional<T> getImage(ResourceLocation id) {
        if (PRELOADED_IMAGE_CACHE.containsKey(id)) {
            return Optional.of(PRELOADED_IMAGE_CACHE.get(id));
        }
        if (IMAGE_CACHE.containsKey(id)) {
            if (YACLPlatform.isDevelopmentEnv() && PRELOADED_IMAGE_FACTORIES.stream().anyMatch(factory -> factory.predicate().test(id))) {
                YACLConstants.LOGGER.error("Image '{}' not preloaded. MAKE SURE THAT ALL YACL WEBP/GIF IMAGES ARE INSIDE YOUR ASSETS `/textures` FOLDER, ELSE THEY WILL NOT BE PRELOADED!!! THIS ERROR WILL NOT APPEAR IN PROD", (Object)id);
            }
            return Optional.ofNullable(IMAGE_CACHE.get(id).getNow(null));
        }
        return Optional.empty();
    }

    public static <T extends ImageRenderer> CompletableFuture<T> registerImage(ResourceLocation id, ImageRendererFactory factory) {
        if (IMAGE_CACHE.containsKey(id)) {
            return IMAGE_CACHE.get(id);
        }
        CompletableFuture future = new CompletableFuture();
        IMAGE_CACHE.put(id, future);
        SINGLE_THREAD_EXECUTOR.submit(() -> {
            Supplier<Optional<ImageRendererFactory.ImageSupplier>> supplier = factory.requiresOffThreadPreparation() ? new CompletedSupplier<Optional<ImageRendererFactory.ImageSupplier>>(ImageRendererManager.safelyPrepareFactory(id, factory)) : () -> ImageRendererManager.safelyPrepareFactory(id, factory);
            Minecraft.getInstance().execute(() -> ImageRendererManager.completeImageFactory(id, supplier, future));
        });
        return future;
    }

    private static void completeImageFactory(ResourceLocation id, Supplier<Optional<ImageRendererFactory.ImageSupplier>> supplier, CompletableFuture<ImageRenderer> future) {
        ImageRenderer image;
        RenderSystem.assertOnRenderThread();
        ImageRendererFactory.ImageSupplier completableImage = supplier.get().orElse(null);
        if (completableImage == null) {
            return;
        }
        if (future.isDone()) {
            YACLConstants.LOGGER.error("Image '{}' was already completed", (Object)id);
            return;
        }
        try {
            image = completableImage.completeImage();
        }
        catch (Exception e) {
            YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)id, (Object)e);
            return;
        }
        future.complete(image);
    }

    public static void closeAll() {
        SINGLE_THREAD_EXECUTOR.shutdownNow();
        IMAGE_CACHE.values().removeIf(future -> {
            if (future.isDone()) {
                ((ImageRenderer)future.join()).close();
            }
            return true;
        });
    }

    static Optional<ImageRendererFactory.ImageSupplier> safelyPrepareFactory(ResourceLocation id, ImageRendererFactory factory) {
        try {
            return Optional.of(factory.prepareImage());
        }
        catch (Exception e) {
            YACLConstants.LOGGER.error("Failed to prepare image '{}'", (Object)id, (Object)e);
            IMAGE_CACHE.remove(id);
            return Optional.empty();
        }
    }

    private record CompletedSupplier<T>(T get) implements Supplier<T>
    {
    }

    public record PreloadedImageFactory(Predicate<ResourceLocation> predicate, BiFunction<Resource, ResourceLocation, ImageRendererFactory> factory) {
    }
}

