/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.dropdown;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.string.StringControllerElement;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class AbstractDropdownControllerElement<T, U>
extends StringControllerElement {
    public static final int MAX_SHOWN_NUMBER_OF_ITEMS = 7;
    private final AbstractDropdownController<T> dropdownController;
    protected boolean dropdownVisible = false;
    protected int selectedIndex = 0;
    protected List<U> matchingValues = null;

    public AbstractDropdownControllerElement(AbstractDropdownController<T> control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim, false);
        this.dropdownController = control;
        this.dropdownController.option.addListener((opt, val) -> {
            this.matchingValues = this.computeMatchingValues();
        });
    }

    public void showDropdown() {
        this.dropdownVisible = true;
        this.selectedIndex = 0;
    }

    public void closeDropdown() {
        this.dropdownVisible = false;
        this.ensureValidValue();
    }

    public void ensureValidValue() {
        this.inputField = this.dropdownController.getValidValue(this.inputField, this.selectedIndex);
        this.matchingValues = this.computeMatchingValues();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            if (!this.dropdownVisible) {
                this.showDropdown();
                this.doSelectAll();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused) {
            this.doSelectAll();
            super.setFocused(true);
        } else {
            this.unfocus();
        }
    }

    @Override
    public void unfocus() {
        this.closeDropdown();
        super.unfocus();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        if (this.dropdownVisible) {
            switch (keyCode) {
                case 264: {
                    this.selectNextEntry();
                    return true;
                }
                case 265: {
                    this.selectPreviousEntry();
                    return true;
                }
                case 258: {
                    if (Screen.hasShiftDown()) {
                        this.selectPreviousEntry();
                    } else {
                        this.selectNextEntry();
                    }
                    return true;
                }
            }
        } else if (keyCode == 257 || keyCode == 335) {
            this.showDropdown();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (!this.dropdownVisible) {
            this.showDropdown();
        }
        return super.charTyped(chr, modifiers);
    }

    @Override
    protected int getValueColor() {
        if (this.inputFieldFocused && !this.dropdownController.isValueValid(this.inputField)) {
            return -1023872;
        }
        return super.getValueColor();
    }

    public void selectNextEntry() {
        this.selectedIndex = this.selectedIndex == this.getDropdownLength() - 1 ? 0 : ++this.selectedIndex;
    }

    public void selectPreviousEntry() {
        this.selectedIndex = this.selectedIndex == 0 ? this.getDropdownLength() - 1 : --this.selectedIndex;
    }

    public int getDropdownLength() {
        return this.matchingValues.size();
    }

    @Override
    public boolean modifyInput(Consumer<StringBuilder> builder) {
        boolean success = super.modifyInput(builder);
        if (success) {
            this.matchingValues = this.computeMatchingValues();
        }
        return success;
    }

    public abstract List<U> computeMatchingValues();

    public boolean matchingValue(String value) {
        return value.toLowerCase().contains(this.inputField.toLowerCase());
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.matchingValues == null) {
            this.matchingValues = this.computeMatchingValues();
        }
        super.render(graphics, mouseX, mouseY, delta);
        if (this.inputFieldFocused && this.dropdownVisible) {
            PoseStack matrices = graphics.pose();
            matrices.pushPose();
            matrices.translate(0.0f, 0.0f, 200.0f);
            this.renderDropdown(graphics);
            matrices.popPose();
        }
    }

    public void renderDropdown(GuiGraphics graphics) {
        if (this.matchingValues.isEmpty()) {
            return;
        }
        int begin = Math.max(0, this.selectedIndex - 3);
        int end = begin + 7;
        if (end >= this.matchingValues.size()) {
            end = this.matchingValues.size();
            begin = Math.max(0, end - 7);
        }
        this.renderDropdownBackground(graphics, end - begin);
        if (!this.matchingValues.isEmpty()) {
            graphics.setColor(0.0f, 0.0f, 0.0f, 0.5f);
            int x = this.getDimension().x();
            int y = this.getDimension().yLimit() + 2 + this.getDimension().height() * (this.selectedIndex - begin);
            graphics.fill(x, y, x + this.getDimension().width(), y + this.getDimension().height(), -1);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.renderOutline(x, y, this.getDimension().width().intValue(), this.getDimension().height().intValue(), -1);
        }
        int n = 1;
        for (int i = begin; i < end; ++i) {
            this.renderDropdownEntry(graphics, this.matchingValues.get(i), n);
            ++n;
        }
    }

    protected int getDropdownEntryPadding() {
        return 0;
    }

    protected void renderDropdownEntry(GuiGraphics graphics, U value, int n) {
        String entry = this.getString(value);
        int color = -1;
        Object text = entry.isBlank() ? Component.translatable((String)"yacl.control.text.blank").withStyle(ChatFormatting.GRAY) : this.shortenString(entry);
        graphics.drawString(this.textRenderer, text, this.getDimension().xLimit() - this.textRenderer.width((FormattedText)text) - this.getDecorationPadding() - this.getDropdownEntryPadding(), this.getTextY() + n * this.getDimension().height() + 2, color, true);
    }

    public abstract String getString(U var1);

    public Component shortenString(String value) {
        return Component.literal((String)GuiUtils.shortenString(value, this.textRenderer, this.getDimension().width() - 20, "..."));
    }

    public void renderDropdownBackground(GuiGraphics graphics, int numberOfItems) {
        graphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
        graphics.blit(Screen.BACKGROUND_LOCATION, this.getDimension().x().intValue(), this.getDimension().yLimit() + 2, 0, 0.0f, 0.0f, this.getDimension().width().intValue(), this.getDimension().height() * numberOfItems + 2, 32, 32);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.renderOutline(this.getDimension().x().intValue(), this.getDimension().yLimit() + 2, this.getDimension().width().intValue(), this.getDimension().height() * numberOfItems, -1);
    }

    protected int getDecorationPadding() {
        return super.getXPadding();
    }
}

