/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.PlaceholderCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.api.utils.OptionUtils;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.OptionDescriptionWidget;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.SearchFieldWidget;
import dev.isxander.yacl3.gui.YACLTooltip;
import dev.isxander.yacl3.gui.tab.ListHolderWidget;
import dev.isxander.yacl3.gui.tab.ScrollableNavigationBar;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class YACLScreen
extends Screen {
    public final YetAnotherConfigLib config;
    private final Screen parent;
    public final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
    }, x$0 -> this.removeWidget((GuiEventListener)x$0));
    public TabNavigationBar tabNavigationBar;
    public ScreenRectangle tabArea;
    public Component saveButtonMessage;
    public Tooltip saveButtonTooltipMessage;
    private int saveButtonMessageTime;
    private boolean pendingChanges;

    public YACLScreen(YetAnotherConfigLib config, Screen parent) {
        super(config.title());
        this.config = config;
        this.parent = parent;
        OptionUtils.forEachOptions(config, option -> option.addListener((opt, val) -> this.onOptionChanged((Option<?>)opt)));
    }

    protected void init() {
        int currentTab;
        int n = currentTab = this.tabNavigationBar != null ? this.tabNavigationBar.tabs.indexOf((Object)this.tabManager.getCurrentTab()) : 0;
        if (currentTab == -1) {
            currentTab = 0;
        }
        this.tabNavigationBar = new ScrollableNavigationBar(this.width, this.tabManager, this.config.categories().stream().map(category -> {
            if (category instanceof PlaceholderCategory) {
                PlaceholderCategory placeholder = (PlaceholderCategory)category;
                return new PlaceholderTab(placeholder);
            }
            return new CategoryTab((ConfigCategory)category);
        }).toList());
        this.tabNavigationBar.selectTab(currentTab, false);
        this.tabNavigationBar.arrangeElements();
        ScreenRectangle navBarArea = this.tabNavigationBar.getRectangle();
        this.tabArea = new ScreenRectangle(0, navBarArea.height() - 1, this.width, this.height - navBarArea.height() + 1);
        this.tabManager.setTabArea(this.tabArea);
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        this.config.initConsumer().accept(this);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderDirtBackground(graphics);
        super.render(graphics, mouseX, mouseY, delta);
    }

    protected void finishOrSave() {
        this.saveButtonMessage = null;
        if (this.pendingChanges()) {
            HashSet flags = new HashSet();
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.applyValue()) {
                    flags.addAll(option.flags());
                }
            });
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.changed()) {
                    option.forgetPendingValue();
                    YACLConstants.LOGGER.error("Option '{}' value mismatch after applying! Reset to binding's getter.", (Object)option.name().getString());
                }
            });
            this.config.saveFunction().run();
            flags.forEach(flag -> flag.accept(this.minecraft));
            this.pendingChanges = false;
            Tab tab = this.tabManager.getCurrentTab();
            if (tab instanceof CategoryTab) {
                CategoryTab categoryTab = (CategoryTab)tab;
                categoryTab.updateButtons();
            }
        } else {
            this.onClose();
        }
    }

    protected void cancelOrReset() {
        if (this.pendingChanges()) {
            OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
            this.onClose();
        } else {
            OptionUtils.forEachOptions(this.config, Option::requestSetDefault);
        }
    }

    protected void undo() {
        OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
    }

    public void tick() {
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof TabExt) {
            TabExt tabExt = (TabExt)tab;
            tabExt.tick();
        }
        if ((tab = this.tabManager.getCurrentTab()) instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            if (this.saveButtonMessage != null) {
                if (this.saveButtonMessageTime > 140) {
                    this.saveButtonMessage = null;
                    this.saveButtonTooltipMessage = null;
                    this.saveButtonMessageTime = 0;
                } else {
                    ++this.saveButtonMessageTime;
                    categoryTab.saveFinishedButton.setMessage(this.saveButtonMessage);
                    if (this.saveButtonTooltipMessage != null) {
                        categoryTab.saveFinishedButton.setTooltip(this.saveButtonTooltipMessage);
                    }
                }
            }
        }
    }

    private void setSaveButtonMessage(Component message, Component tooltip) {
        this.saveButtonMessage = message;
        this.saveButtonTooltipMessage = Tooltip.create((Component)tooltip);
        this.saveButtonMessageTime = 0;
    }

    private boolean pendingChanges() {
        return this.pendingChanges;
    }

    private void onOptionChanged(Option<?> option) {
        this.pendingChanges = false;
        OptionUtils.consumeOptions(this.config, opt -> {
            this.pendingChanges |= opt.changed();
            return this.pendingChanges;
        });
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            categoryTab.updateButtons();
        }
    }

    public boolean shouldCloseOnEsc() {
        if (this.pendingChanges()) {
            this.setSaveButtonMessage((Component)Component.translatable((String)"yacl.gui.save_before_exit").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"yacl.gui.save_before_exit.tooltip"));
            return false;
        }
        return true;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public static void renderMultilineTooltip(GuiGraphics graphics, Font font, MultiLineLabel text, int centerX, int yAbove, int yBelow, int screenWidth, int screenHeight) {
        if (text.getLineCount() > 0) {
            int maxWidth = text.getWidth();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int height = text.getLineCount() * lineHeight - 1;
            int belowY = yBelow + 12;
            int aboveY = yAbove - height + 12;
            int maxBelow = screenHeight - (belowY + height);
            int minAbove = aboveY - height;
            int y = aboveY;
            if (minAbove < 8) {
                y = maxBelow > minAbove ? belowY : aboveY;
            }
            int x = Math.max(centerX - text.getWidth() / 2 - 12, -6);
            int drawX = x + 12;
            int drawY = y - 12;
            graphics.pose().pushPose();
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferBuilder = tesselator.getBuilder();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)drawX, (int)drawY, (int)maxWidth, (int)height, (int)400);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
            RenderSystem.disableBlend();
            graphics.pose().translate(0.0, 0.0, 400.0);
            text.renderLeftAligned(graphics, drawX, drawY, lineHeight, -1);
            graphics.pose().popPose();
        }
    }

    public class CategoryTab
    implements TabExt {
        private final ConfigCategory category;
        private final Tooltip tooltip;
        private ListHolderWidget<OptionListWidget> optionList;
        public final Button saveFinishedButton;
        private final Button cancelResetButton;
        private final Button undoButton;
        private final SearchFieldWidget searchField;
        private OptionDescriptionWidget descriptionWidget;

        public CategoryTab(ConfigCategory category) {
            this.category = category;
            this.tooltip = Tooltip.create((Component)category.tooltip());
            int columnWidth = YACLScreen.this.width / 3;
            int padding = columnWidth / 20;
            columnWidth = Math.min(columnWidth, 400);
            int paddedWidth = columnWidth - padding * 2;
            MutableDimension<Integer> actionDim = Dimension.ofInt(YACLScreen.this.width / 3 * 2 + YACLScreen.this.width / 6, YACLScreen.this.height - padding - 20, paddedWidth, 20);
            this.saveFinishedButton = Button.builder((Component)Component.literal((String)"Done"), btn -> YACLScreen.this.finishOrSave()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
            actionDim.expand(-((Integer)actionDim.width()).intValue() / 2 - 2, 0).move(-((Integer)actionDim.width()).intValue() / 2 - 2, -22);
            this.cancelResetButton = Button.builder((Component)Component.literal((String)"Cancel"), btn -> YACLScreen.this.cancelOrReset()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
            actionDim.move((Integer)actionDim.width() + 4, 0);
            this.undoButton = Button.builder((Component)Component.translatable((String)"yacl.gui.undo"), btn -> YACLScreen.this.undo()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).tooltip(Tooltip.create((Component)Component.translatable((String)"yacl.gui.undo.tooltip"))).build();
            this.searchField = new SearchFieldWidget(YACLScreen.this, YACLScreen.this.font, YACLScreen.this.width / 3 * 2 + YACLScreen.this.width / 6 - paddedWidth / 2 + 1, this.undoButton.getY() - 22, paddedWidth - 2, 18, (Component)Component.translatable((String)"gui.recipebook.search_hint"), (Component)Component.translatable((String)"gui.recipebook.search_hint"), searchQuery -> this.optionList.getList().updateSearchQuery((String)searchQuery));
            this.optionList = new ListHolderWidget<OptionListWidget>(() -> new ScreenRectangle(YACLScreen.this.tabArea.position(), YACLScreen.this.tabArea.width() / 3 * 2 + 1, YACLScreen.this.tabArea.height()), new OptionListWidget(YACLScreen.this, category, YACLScreen.this.minecraft, 0, 0, YACLScreen.this.width / 3 * 2 + 1, YACLScreen.this.height, desc -> this.descriptionWidget.setOptionDescription((DescriptionWithName)desc)));
            this.descriptionWidget = new OptionDescriptionWidget(() -> new ScreenRectangle(YACLScreen.this.width / 3 * 2 + padding, YACLScreen.this.tabArea.top() + padding, paddedWidth, this.searchField.getY() - 1 - YACLScreen.this.tabArea.top() - padding * 2), null);
            this.updateButtons();
        }

        public Component getTabTitle() {
            return this.category.name();
        }

        public void visitChildren(Consumer<AbstractWidget> consumer) {
            consumer.accept(this.optionList);
            consumer.accept((AbstractWidget)this.saveFinishedButton);
            consumer.accept((AbstractWidget)this.cancelResetButton);
            consumer.accept((AbstractWidget)this.undoButton);
            consumer.accept((AbstractWidget)this.searchField);
            consumer.accept(this.descriptionWidget);
        }

        public void doLayout(ScreenRectangle screenRectangle) {
        }

        @Override
        public void tick() {
            this.descriptionWidget.tick();
        }

        @Override
        @Nullable
        public Tooltip getTooltip() {
            return this.tooltip;
        }

        public void updateButtons() {
            boolean pendingChanges;
            this.undoButton.active = pendingChanges = YACLScreen.this.pendingChanges();
            this.saveFinishedButton.setMessage((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save") : GuiUtils.translatableFallback("yacl.gui.done", CommonComponents.GUI_DONE)));
            this.saveFinishedButton.setTooltip((Tooltip)new YACLTooltip((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save.tooltip") : Component.translatable((String)"yacl.gui.finished.tooltip")), (AbstractWidget)this.saveFinishedButton));
            this.cancelResetButton.setMessage((Component)(pendingChanges ? GuiUtils.translatableFallback("yacl.gui.cancel", CommonComponents.GUI_CANCEL) : Component.translatable((String)"controls.reset")));
            this.cancelResetButton.setTooltip((Tooltip)new YACLTooltip((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.cancel.tooltip") : Component.translatable((String)"yacl.gui.reset.tooltip")), (AbstractWidget)this.cancelResetButton));
        }
    }

    public class PlaceholderTab
    implements TabExt {
        private final PlaceholderCategory category;
        private final Tooltip tooltip;

        public PlaceholderTab(PlaceholderCategory category) {
            this.category = category;
            this.tooltip = Tooltip.create((Component)category.tooltip());
        }

        public Component getTabTitle() {
            return this.category.name();
        }

        public void visitChildren(Consumer<AbstractWidget> consumer) {
        }

        public void doLayout(ScreenRectangle screenRectangle) {
            YACLScreen.this.minecraft.setScreen(this.category.screen().apply(YACLScreen.this.minecraft, YACLScreen.this));
        }

        @Override
        @Nullable
        public Tooltip getTooltip() {
            return this.tooltip;
        }
    }
}

