/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ElementListWidgetExt<E extends Entry<E>>
extends ContainerObjectSelectionList<E>
implements LayoutElement {
    private double smoothScrollAmount = this.getScrollAmount();
    private boolean returnSmoothAmount = false;
    private final boolean doSmoothScrolling;

    public ElementListWidgetExt(Minecraft client, int x, int y, int width, int height, boolean smoothScrolling) {
        super(client, x, y, width, height);
        this.doSmoothScrolling = smoothScrolling;
        this.setRenderBackground(true);
        this.setRenderHeader(false, 0);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        this.setScrollAmount(this.getScrollAmount() - (vertical + horizontal) * 20.0);
        return true;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth() - 2;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.smoothScrollAmount = Mth.lerp((double)((double)Minecraft.getInstance().getDeltaFrameTime() * 0.5), (double)this.smoothScrollAmount, (double)this.getScrollAmount());
        this.returnSmoothAmount = true;
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        super.renderWidget(graphics, mouseX, mouseY, delta);
        graphics.disableScissor();
        this.returnSmoothAmount = false;
    }

    public void updateDimensions(ScreenRectangle rectangle) {
        this.setX(rectangle.left());
        this.setY(rectangle.top());
        this.setWidth(rectangle.width());
        this.setHeight(rectangle.height());
    }

    public double getScrollAmount() {
        if (this.returnSmoothAmount && this.doSmoothScrolling) {
            return this.smoothScrollAmount;
        }
        return super.getScrollAmount();
    }

    protected void resetSmoothScrolling() {
        this.smoothScrollAmount = this.getScrollAmount();
    }

    @Nullable
    protected E getEntryAtPosition(double x, double y) {
        y += this.getScrollAmount();
        if (x < (double)this.getX() || x > (double)(this.getX() + this.getWidth())) {
            return null;
        }
        int currentY = this.getY() - this.headerHeight + 4;
        for (Entry entry : this.children()) {
            if (y >= (double)currentY && y <= (double)(currentY + entry.getItemHeight())) {
                return (E)((Object)entry);
            }
            currentY += entry.getItemHeight();
        }
        return null;
    }

    protected int getMaxPosition() {
        return this.children().stream().map(Entry::getItemHeight).reduce(0, Integer::sum) + this.headerHeight;
    }

    protected void centerScrollOn(E entry) {
        double d = (double)this.height / -2.0;
        for (int i = 0; i < this.children().indexOf(entry) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)((Object)this.children().get(i))).getItemHeight();
        }
        this.setScrollAmount(d);
    }

    protected int getRowTop(int index) {
        int integer = this.getY() + 4 - (int)this.getScrollAmount() + this.headerHeight;
        for (int i = 0; i < this.children().size() && i < index; ++i) {
            integer += ((Entry)((Object)this.children().get(i))).getItemHeight();
        }
        return integer;
    }

    protected void renderList(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int left = this.getRowLeft();
        int right = this.getRowWidth();
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            Entry entry = (Entry)((Object)this.children().get(i));
            int top = this.getRowTop(i);
            int bottom = top + entry.getItemHeight();
            int entryHeight = entry.getItemHeight() - 4;
            if (bottom < this.getY() || top > this.getY() + this.getHeight()) continue;
            this.renderItem(graphics, mouseX, mouseY, delta, i, left, top, right, entryHeight);
        }
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ContainerObjectSelectionList.Entry<E> {
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (GuiEventListener child : this.children()) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                if (button == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.isDragging() && button == 0) {
                for (GuiEventListener child : this.children()) {
                    if (!child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
                    return true;
                }
            }
            return false;
        }

        public int getItemHeight() {
            return 22;
        }
    }
}

